/**********************************************************************
	MENU2.C	Menu demonstration program (version 2)

	This program shows the use of menus in an application
	with multiple events.
**********************************************************************/

/**************************************************
	System Header Files & Constants
**************************************************/

#include	<stdio.h>				/* Standard IO */
#include	<osbind.h>			/* GEMDOS routines */
#include	<gemdefs.h>			/* GEM AES */
#include	<obdefs.h>			/* GEM constants */

#define	FALSE	0
#define	TRUE		!FALSE

/**************************************************
	GEM Application Overhead
**************************************************/

/* Declare global arrays for VDI. */
typedef	int	WORD;			/* WORD is 16 bits */
WORD		contrl[12],			/* VDI control array */
		intout[128], intin[128],	/* VDI input arrays */
		ptsin[128], ptsout[128];	/* VDI output arrays */

WORD		screen_vhandle,		/* virtual screen workstation */
		screen_phandle,		/* physical screen workstation */
		screen_rez,			/* screen resolution 0,1, or 2 */
		color_screen,			/* flag if color monitor */
		x_max,				/* max x screen coord */
		y_max;				/* max y screen coord */

/**************************************************
	Application Specific Data
**************************************************/

#include	"menu.h"
#define	QUIT_KEY	0x1011		/* control-Q to quit */
#define	INFO_KEY	0x1e01		/* control-A for about info */

char	ding_dong[] = {			/* array for Dosound */
	0, 239, 1, 0, 7, 62, 8, 8, 130, 25,
	0, 63, 1, 1, 130, 40, 7, 63, 8, 0, 255, 0
};


/**************************************************
	GEM-related Functions
**************************************************/

WORD	open_vwork(phys_handle)
WORD	phys_handle;
/**************************************************
Function:	This function opens a virtual workstation.
Input:	phys_handle	= physical workstation handle
Output:	Returns handle of workstation.
**************************************************/
{
WORD	work_in[11],
		work_out[57],
		new_handle;				/* handle of workstation */
int		i;

	for (i = 0; i < 10; i++)			/* set for default values */
		work_in[i] = 1;
	work_in[10] = 2;				/* use raster coords */
	new_handle = phys_handle;		/* use currently open wkstation */
	v_opnvwk(work_in, &new_handle, work_out);
	return(new_handle);
}


set_screen_attr()
/**************************************************
Function:	Set global values about screen.
Input:	None. Uses screen_vhandle.
Output:	Sets x_max, y_max, color_screen, and screen_rez.
**************************************************/
{
WORD	work_out[57];

	vq_extnd(screen_vhandle, 0, work_out);
	x_max = work_out[0];
	y_max = work_out[1];
	screen_rez = Getrez();		/* 0 = low, 1 = med, 2 = high */
	color_screen = (screen_rez < 2);	/* mono 2, color 0 or 1 */
}


/**************************************************
	Application Functions
**************************************************/
	
do_dialog(box_index)
WORD	box_index;
/**************************************************
Function:	Display a dialog box.
Input:	box_addr	= index of dialog box
Output:	Returns index of object used for exit.
**************************************************/
{
WORD	xbox, ybox, hbox, wbox;
WORD	smallx, smally, smallw, smallh;
WORD	exit_object;
OBJECT	*box_addr;

/* get address of box */
	rsrc_gaddr(0, box_index, &box_addr);

/* get size and location of a box centered on screen */
	form_center(box_addr, &xbox, &ybox, &wbox, &hbox);
	smallx = xbox + (wbox / 2);
	smally = ybox + (hbox / 2);
	smallw = 0;
	smallh = 0;

/* reserve area on screen for box display */
	form_dial(FMD_START,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw an expanding box */
	form_dial(FMD_GROW,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* draw dialog box */
	objc_draw(box_addr, 0, 10, xbox, ybox, wbox, hbox);

/* handle dialog input */
	exit_object = form_do(box_addr, 0);

/* draw a shrinking box */
	form_dial(FMD_SHRINK,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* reserve area on screen for box display */
	form_dial(FMD_FINISH,
		smallx, smally, smallw, smallh,
		xbox, ybox, wbox, hbox);

/* reset exit object state to unselected */
	box_addr[exit_object].ob_state = NORMAL;

	return(exit_object);
}


control()
/**************************************************
Function:	Master control function.
Input:	None. Program initialization must be done before
		entering this function.
Output:	None. Returns for normal program termination.
**************************************************/
{
OBJECT	*menu_addr;			/* address for menu */
WORD		mevx, mevy,			/* evnt_multi parameters */
		mevbut,
		keystate,
		keycode,
		mbreturn,
		msg_buf[8];			/* message buffer */
WORD		event,				/* evnt_multi result */
		menu_index;			/* keyboard menu title selected */

/* get address of menu */
	rsrc_gaddr(0, MAINMENU, &menu_addr);

/* display menu bar */
	menu_bar(menu_addr, TRUE);

/* wait for a message indicating a menu selection */
for(;;)						/* continue loop until quit */
{
	event = evnt_multi( (MU_KEYBD | MU_MESAG),
		0,					/* # mouse clicks */
		0,					/* mouse buttons of interest */
		0,					/* button state */
		0,					/* first rectangle flags */
		0, 0,				/* x,y of 1st rectangle */
		0, 0,				/* height, widht of 1st rect */
		0,					/* second rectand flags */
		0, 0,				/* x,y of 2nd rect */
		0, 0,				/* w,h of 2nd rect */
		msg_buf,				/* message buffer */
		0, 0,				/* low, high words for timer */
		&mevx, &mevy,			/* x,y of mouse event */
		&mevbut,					/* button state at event */
		&keystate,			/* status of keyboard at event */
		&keycode,				/* keyboard code for key pressed */
		&mbreturn);			/* # times mouse key enter state */

	if (event & MU_MESAG)
	{
		if (msg_buf[0] != MN_SELECTED)	/* not a menu message */
			continue;					/* then ignore */
		if (msg_buf[4] == QUIT)
			break;			/* exit loop */

		switch(msg_buf[4])		/* find object index */
		{
		case	SAMPLE1:			/* ring bell */
			Dosound(ding_dong);
			break;

		case SAMPLE2:			/* change item 1 state */
			if (menu_addr[SAMPLE1].ob_state == DISABLED)
			{
				menu_ienable(menu_addr, SAMPLE1, 1);
				menu_text(menu_addr, SAMPLE2,
					"  Disable Door Bell");
			}
			else
			{
				menu_ienable(menu_addr, SAMPLE1, 0);
				menu_text(menu_addr, SAMPLE2,
					"  Enable Door Bell");
			}
			break;

		case  SAMPLE3:			/* check or uncheck item */
			if (menu_addr[SAMPLE3].ob_state == CHECKED)
			{
				menu_icheck(menu_addr, SAMPLE3, 0);
				menu_text(menu_addr, SAMPLE3, "  Check item");
			}
			else
			{
				menu_icheck(menu_addr, SAMPLE3, 1);
				menu_text(menu_addr, SAMPLE3, "  Uncheck item");
			}
			break;

		case	INFO:			/* display program info */
			do_dialog(INFOBOX);
			break;

		default:
			break;
		}
							/* reset title state */
		menu_tnormal(menu_addr, msg_buf[3], 1);
	}						/* end message handler */

	if (event & MU_KEYBD)
	{
		if (keycode == QUIT_KEY)
		{
			menu_index = FILE;
			menu_tnormal(menu_addr, menu_index, 0);
			break;
		}

		switch(keycode)
		{
		case	INFO_KEY:
			menu_index = DESK;
			menu_tnormal(menu_addr, menu_index, 0);
			do_dialog(INFOBOX);
			break;

		default:
			break;
		}
		menu_tnormal(menu_addr, menu_index, 1);
	}						/* end keyboard handler */
}							/* end infinite loop */
	return;
}							/* end function */


/**************************************************
	Main Program
**************************************************/

main()
{
int	ap_id;					/* application init verify */

WORD	gr_wchar, gr_hchar,			/* values for VDI handle */ 
	gr_wbox, gr_hbox;

/**************************************************
	Initialize GEM Access
**************************************************/

	ap_id = appl_init();		/* Initialize AES routines */
	if (ap_id < 0)				/* no calls can be made to AES */
	{						/* use GEMDOS */
		Cconws("***> Initialization Error. <***\n");
		Cconws("Press any key to continue.\n");
		Crawcin();
		exit(-1);				/* set exit value to show error */
	}
		
	screen_phandle = 			/* Get handle for screen */
		graf_handle(&gr_wchar, &gr_hchar, &gr_wbox, &gr_hbox);
	screen_vhandle = open_vwork(screen_phandle);
	set_screen_attr();			/* Get screen attributes */

/***************************************************
	Application Specific Routines
***************************************************/

	if (!rsrc_load("MENU.RSC"))
	{
		form_alert(1, "[0][Cannot file MENU.RSC file|Exiting ...][OK]");
		exit(1);
	}

	control();

/***************************************************
	Program Clean-up and Exit
***************************************************/
	
/* Wait for keyboard before exiting program */
	rsrc_free();
	v_clsvwk(screen_vhandle);	/* close workstation */
	appl_exit();				/* end program */
}
/**************************************************/

