THIS PROGRAM REQUIRES THAT MiNT BE ACTIVE IN ORDER TO RUN.
If you try to run it without MiNT, you will get funny error messages
every time you try to run a program. Also note that it requires version 0.6
or higher of MiNT.

This is a port of bash, the GNU Bourne Again shell, to MiNT. It's essentially
equivalent to the BSD version, right down to the (useless, on the ST) check
for new mail. This means, in particular, that the backslash character ('\')
is special, and must be duplicated to be passed to a program, i.e. type
'ls c:\\bin' instead of 'ls c:\bin'. For this reason, it's best used with
utilities that allow forward slashes to separate directories.

The following ST specific features should be noted:
(1) Searches for executable programs always consider the current directory
first; this is a bug that I introduced in order to provide feature (2) easily.
(2) Executable files with the "usual" extensions need not have those extensions
added, i.e. if you type 'ls' then bash will look for 'ls', 'ls.ttp', 'ls.prg',
and 'ls.tos' in that order in each directory on your path.
(3) The ".bashrc" file is called "bash.rc" on the ST. Similarly, the .profile
file is called "profile", the ".bash_profile" file is called "bash_pro",
the ".bash_login" file is called "bash_log", and the ".bash_history" file
is called "bash_his".
(4) Only some of the "ulimit" options are supported under MiNT, namely
the -d (malloc'd memory limit), -m (total memory limit), and -t (cpu
time limit) options; note also that -d and -m mean slightly different
things under MiNT than they do under BSD.
(5) There's a bug (?) in the job control feature such that if you run
bash from a program that doesn't know about job control, that program
will be suspended when bash exits. Use "fg" (or whatever) to start
the program again, or else never leave bash (half :-); I'm sure bash
could be used as a replacement for the MiNT init.prg).

If you don't know bash already... sorry, but there isn't much in the way
of docs. Get the source code (see below), and/or a good book on the Unix
/bin/sh. There is (some) online help; just enter "help" on a line by
itself. See also the "features" file.

The source code is available from the usual GNU places (prep.ai.mit.edu
being the "canonical" place). I used bash 1.05 taken from my local Sun
network; it already had some diffs on it (probably most of the known bug
fixes), and I used Eric Smith's original diffs as a starting point.
The diffs included in this distribution are from the patched Sun version,
so you will NOT need Eric's diffs to re-build this. I re-wrote the Makefile
virtually from scratch; it's not terribly complete, but it does mean that
the whole process is totally automatic. It was compiled under the MiNT-gcc
library version 0.8; getting it to work with another compiler/library
setup will probably prove impossible. Note also that I have the
readline/history library installed as a standard library on my machine.

I will attempt to support this, but I don't have much time to do so, and
I intend abandoning 1.05 and porting 1.07 or higher later this year (91).

Happy bashing!

'Grave' Dave Gymer | Note that I don't have access to the net during
 dpg@Cs.Nott.AC.UK | vacations, so don't be surprised if you get an
                   | automatic message or no response from July to early
                   | October. Sorry for any inconvenience.
