diff -c orig/bashline.c ./bashline.c
*** orig/bashline.c	Wed Jun  5 19:30:06 1991
--- ./bashline.c	Wed Jun  5 19:32:48 1991
***************
*** 19,25 ****
  Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
  
  #include <stdio.h>
! #include <readline/readline.h>
  #include "config.h"
  #include "general.h"
  #include "variables.h"
--- 19,25 ----
  Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
  
  #include <stdio.h>
! #include "readline/readline.h"
  #include "config.h"
  #include "general.h"
  #include "variables.h"
diff -c orig/builtins.c ./builtins.c
*** orig/builtins.c	Wed Jun  5 19:30:24 1991
--- ./builtins.c	Fri Jun  7 19:54:34 1991
***************
*** 212,225 ****
  	printed" },
  
    { "history", history_builtin, 1, "history [n] [-s] [ [-w | -r] [filename]]",
        "	Display the history list with line numbers.  Lines listed with\n\
  	with a `*' have been modified.  Argument of N says to list only\n\
  	the last N lines.  Argument `-w' means write out the current\n\
  	history file.  `-r' means to read it instead.  If FILENAME is\n\
  	given, then use that file, else if $HISTFILE has a value, use\n\
  	that, else use ~/.bash_history.  Argument -s oerforms history\n\
  	substitution on the following args" },
! 
  #ifdef JOB_CONTROL
    { "jobs", jobs_builtin, 1, "jobs [-l]",
        "	Lists the active jobs; given the -l options lists process id's\n\
--- 212,234 ----
  	printed" },
  
    { "history", history_builtin, 1, "history [n] [-s] [ [-w | -r] [filename]]",
+ #ifdef MiNT
        "	Display the history list with line numbers.  Lines listed with\n\
  	with a `*' have been modified.  Argument of N says to list only\n\
  	the last N lines.  Argument `-w' means write out the current\n\
  	history file.  `-r' means to read it instead.  If FILENAME is\n\
  	given, then use that file, else if $HISTFILE has a value, use\n\
+ 	that, else use ~/bash_his.  Argument -s oerforms history\n\
+ 	substitution on the following args" },
+ #else
+       "	Display the history list with line numbers.  Lines listed with\n\
+ 	with a `*' have been modified.  Argument of N says to list only\n\
+ 	the last N lines.  Argument `-w' means write out the current\n\
+ 	history file.  `-r' means to read it instead.  If FILENAME is\n\
+ 	given, then use that file, else if $HISTFILE has a value, use\n\
  	that, else use ~/.bash_history.  Argument -s oerforms history\n\
  	substitution on the following args" },
! #endif
  #ifdef JOB_CONTROL
    { "jobs", jobs_builtin, 1, "jobs [-l]",
        "	Lists the active jobs; given the -l options lists process id's\n\
***************
*** 725,730 ****
--- 734,750 ----
    char *orig_string = string;
    extern COMMAND *global_command;
  
+ #ifdef MiNT /* we want to convert excess \r's to spaces */
+   {
+     char *s = string;
+ 
+     while (*s) {
+       if(*s == '\r')
+         *s = ' ';
+       ++s;
+     }
+   }
+ #endif
    push_stream ();
    interactive = 0;
    indirection_level++;
***************
*** 1699,1729 ****
  
  	return (result ? EXECUTION_FAILURE : EXECUTION_SUCCESS);
        }
!     }
! 
!   if (strcmp (list->word->word, "-s") == 0)
!     {
!       extern int history_expand ();
!       char *expanded;
!       int rval;
  
!       list = list->next;
  
!       while (list)
! 	{
! 	  rval = history_expand (list->word->word, &expanded);
! 	  printf ("%s", expanded);
! 	  fflush (stdout);
  
! 	  if (rval == -1)
! 	    return (EXECUTION_FAILURE);
  
! 	  free (expanded);
  
! 	  list = list->next;
! 	}
      }
!   
    limit = get_numeric_arg (list);
    if (limit < 0)
      limit = -limit;
--- 1719,1749 ----
  
  	return (result ? EXECUTION_FAILURE : EXECUTION_SUCCESS);
        }
! /* (Was this a bug??? It appears so. Oh well, it's fixed now.) */
!       if (strcmp (list->word->word, "-s") == 0) 
! 	{
!           extern int history_expand ();
!           char *expanded;
!           int rval;
  
!           list = list->next;
  
!           while (list)
! 	    {
! 	      rval = history_expand (list->word->word, &expanded);
! 	      printf ("%s", expanded);
! 	      fflush (stdout);
  
! 	      if (rval == -1)
! 	        return (EXECUTION_FAILURE);
  
! 	      free (expanded);
  
! 	      list = list->next;
! 	    }
!         }
      }
! 
    limit = get_numeric_arg (list);
    if (limit < 0)
      limit = -limit;
***************
*** 2195,2201 ****
--- 2215,2225 ----
  scale60 (tvalp)
       struct timeval *tvalp;
  {
+ # ifdef MiNT /* I don't know what's going on here, so I'll do it myself. */
+   return tvalp->tv_sec;
+ # else
    return (tvalp->tv_sec * 60 + tvalp->tv_usec / 16667);
+ # endif /* MiNT */
  }
  #endif /* !SYSV */
  
***************
*** 2210,2222 ****
    no_args (list);
  
    getrusage (RUSAGE_SELF, &self);
!   getrusage (RUSAGE_CHILDREN, &kids);	/* terminated child processes */
  
    user_seconds_used = scale60(&self.ru_utime) + scale60(&kids.ru_utime);
    system_seconds_used = scale60(&self.ru_stime) + scale60(&kids.ru_stime);
  
  #else /* SYSV */
- 
  #ifndef HZ
  #define HZ 100		/* From my Sys V.3.2 manual for times(2) */
  #endif /* !HZ */
--- 2234,2245 ----
    no_args (list);
  
    getrusage (RUSAGE_SELF, &self);
!   getrusage (RUSAGE_CHILDREN, &kids); /* terminated child processes */
  
    user_seconds_used = scale60(&self.ru_utime) + scale60(&kids.ru_utime);
    system_seconds_used = scale60(&self.ru_stime) + scale60(&kids.ru_stime);
  
  #else /* SYSV */
  #ifndef HZ
  #define HZ 100		/* From my Sys V.3.2 manual for times(2) */
  #endif /* !HZ */
diff -c orig/config.h ./config.h
*** orig/config.h	Wed Jun  5 19:39:52 1991
--- ./config.h	Wed Jun  5 19:39:30 1991
***************
*** 52,59 ****
--- 52,64 ----
  #define READLINE
  
  /* The default value of the PATH variable. */
+ #ifdef MiNT
  #define DEFAULT_PATH_VALUE \
+ 	",/dev/c/bin,/dev/d/bin"
+ #else
+ #define DEFAULT_PATH_VALUE \
  	":/usr/gnu/bin:/usr/local/bin:/usr/ucb:/bin:/etc:/usr/etc"
+ #endif
  
  /* Define V9_ECHO if you want to give the echo builtin backslash-escape
     interpretation, in the style of the Bell Labs 9th Edition version of
diff -c orig/execute_.c ./execute_.c
*** orig/execute_.c	Wed Jun  5 19:30:38 1991
--- ./execute_.c	Wed Jun  5 19:33:18 1991
***************
*** 35,41 ****
--- 35,45 ----
  #include <errno.h>
  
  #include "shell.h"
+ #ifdef MiNT
+ #include "parse-t.h"
+ #else
  #include "y.tab.h"
+ #endif
  #include "builtins.h"
  #include "flags.h"
  #include "hash.h"
***************
*** 877,883 ****
--- 881,891 ----
  		  struct stat finfo;
  		  extern int errno;
  
+ #ifdef MiNT
+ 		  if (!executable_file(args[0]))
+ #else
  		  if (errno != ENOEXEC)
+ #endif
  		    {
  		      if ((stat (command, &finfo) == 0) &&
  			  ((finfo.st_mode & S_IFMT) == S_IFDIR))
***************
*** 1381,1397 ****
  }
  
  #ifndef SYSV
  /* The number of groups (within 64) that this user is a member of. */
  static int default_group_array_size = 0;
  static int ngroups = 0;
  static int *group_array = (int *)NULL;
  #endif
  
  /* Return non-zero if GID is one that we have in our groups list. */
  group_member (gid)
       int gid;
  {
! #ifdef SYSV
    return ((gid == getgid ()) || (gid == geteuid ()));
  #else
  
--- 1389,1407 ----
  }
  
  #ifndef SYSV
+ #ifndef MiNT
  /* The number of groups (within 64) that this user is a member of. */
  static int default_group_array_size = 0;
  static int ngroups = 0;
  static int *group_array = (int *)NULL;
  #endif
+ #endif
  
  /* Return non-zero if GID is one that we have in our groups list. */
  group_member (gid)
       int gid;
  {
! #if defined(SYSV) || defined(MiNT)
    return ((gid == getgid ()) || (gid == geteuid ()));
  #else
  
***************
*** 1556,1561 ****
--- 1566,1580 ----
       char *path_list;
       int must_be_executable;
  {
+ #ifdef MiNT
+   static char *extensions[] = {"ttp", "prg", "tos", "sh", 0};
+   extern char *findfile();
+   char *foo;
+ 
+   foo = findfile(name, path_list, extensions);
+   if (!foo) return foo;
+   return savestring(foo);
+ #else
    extern char *extract_colon_unit ();
    extern int file_exists_p;
    char *full_path;
***************
*** 1635,1640 ****
--- 1654,1660 ----
      return (file_to_lose_on);
    else
      return (char *)NULL;
+ #endif
  }
  
  /* Given a string containing units of information separated by colons,
***************
*** 1652,1664 ****
    if ((i >= strlen (string)) || !string)
      return ((char *)NULL);
  
    if (string[i] == ':')
      i++;
  
    start = i;
  
    while (string[i] && string[i] != ':') i++;
! 
    *index = i;
  
    if (i == start)
--- 1672,1691 ----
    if ((i >= strlen (string)) || !string)
      return ((char *)NULL);
  
+ #ifdef MiNT
+   if (string[i] == ',')
+ #else
    if (string[i] == ':')
+ #endif
      i++;
  
    start = i;
  
+ #ifdef MiNT
+   while (string[i] && string[i] != ',') i++;
+ #else
    while (string[i] && string[i] != ':') i++;
! #endif
    *index = i;
  
    if (i == start)
diff -c orig/general.h ./general.h
*** orig/general.h	Wed Jun  5 19:39:54 1991
--- ./general.h	Wed Jun  5 19:39:32 1991
***************
*** 39,45 ****
  #endif
  
  /* The output of `signal' is different on different systems.  Yechh. */
! #if defined(SunOS4) || defined (NeXT) || defined (Ultrix)
  #define sighandler void
  #else
  #define sighandler int
--- 39,45 ----
  #endif
  
  /* The output of `signal' is different on different systems.  Yechh. */
! #if defined(SunOS4) || defined (NeXT) || defined (Ultrix) || defined(atarist)
  #define sighandler void
  #else
  #define sighandler int
diff -c orig/parse.y ./parse.y
*** orig/parse.y	Wed May 29 12:23:52 1991
--- ./parse.y	Wed Jun  5 16:28:32 1991
***************
*** 98,104 ****
  			  eof_encountered = 0;
  			  discard_parser_constructs (1);
  			  if (interactive)
! 			    YYACCEPT
  			  else
  			    YYABORT;
  			}
--- 98,104 ----
  			  eof_encountered = 0;
  			  discard_parser_constructs (1);
  			  if (interactive)
! 			    YYACCEPT;
  			  else
  			    YYABORT;
  			}
diff -c orig/print_cm.c ./print_cm.c
*** orig/print_cm.c	Wed Jun  5 19:31:10 1991
--- ./print_cm.c	Wed Jun  5 19:34:04 1991
***************
*** 25,31 ****
--- 25,35 ----
  #endif
  
  #include "shell.h"
+ #ifdef MiNT
+ #include "parse-t.h"
+ #else
  #include "y.tab.h"
+ #endif
  
  static int indentation = 0;
  static int indentation_amount = 4;
diff -c orig/shell.c ./shell.c
*** orig/shell.c	Wed Jun  5 19:31:14 1991
--- ./shell.c	Fri Jun  7 13:03:30 1991
***************
*** 49,54 ****
--- 49,58 ----
  #include <varargs.h>
  #endif
  
+ #ifdef atarist
+ long _stksize = 32*1024L;
+ #endif
+ 
  #include "shell.h"
  #include "flags.h"
  
***************
*** 140,146 ****
--- 144,154 ----
  char *shell_name;
  
  /* The name of the .(shell)rc file. */
+ #ifdef MiNT
+ char *bashrc_file = "~/bash.rc";
+ #else
  char *bashrc_file = "~/.bashrc";
+ #endif
  
  /* Non-zero means to act more like the Bourne shell on startup. */
  int act_like_sh = 0;
***************
*** 368,373 ****
--- 376,391 ----
  	  /* If we are doing the .bash_profile, then don't do the .bashrc. */
  	  no_rc++;
  
+ #ifdef MiNT
+ 	  if (act_like_sh)
+ 	     maybe_execute_file ("~/profile");
+ 	  else
+ 	    {
+ 	      if (maybe_execute_file ("~/bash_profile") == 0)
+ 		if (maybe_execute_file ("~/bash_login") == 0)
+ 		  maybe_execute_file ("~/profile");
+ 	    }
+ #else
  	  if (act_like_sh)
  	    maybe_execute_file ("~/.profile");
  	  else
***************
*** 376,382 ****
  		if (maybe_execute_file ("~/.bash_login") == 0)
  		  maybe_execute_file ("~/.profile");
  	    }
! 
  	  /* I turn on the restrictions afterwards because it is explictly
  	     stated in the POSIX spec that PATH cannot be set in a restricted
  	     shell, except in .profile. */
--- 394,400 ----
  		if (maybe_execute_file ("~/.bash_login") == 0)
  		  maybe_execute_file ("~/.profile");
  	    }
! #endif
  	  /* I turn on the restrictions afterwards because it is explictly
  	     stated in the POSIX spec that PATH cannot be set in a restricted
  	     shell, except in .profile. */
***************
*** 704,710 ****
--- 722,732 ----
    initialize_signals ();
    initialize_traps ();
  
+   initialize_shell_variables (shell_environment);
+ 
    /* Initialize current_user_name and current_host_name. */
+   /* dpg moved this here because currently gethostname on the ST calls
+ 	getenv which is not the same in BASH as the library routine */
    {
      struct passwd *entry = getpwuid (getuid ());
      char hostname[256];
***************
*** 720,726 ****
        current_user_name = savestring ("I have no name!");
    }
  
-   initialize_shell_variables (shell_environment);
    initialize_filename_hashing ();
    initialize_jobs ();
  }
--- 742,747 ----
***************
*** 919,925 ****
  /* Make a bug report, even to the extent of mailing it.  Hope that it
     gets where it is supposed to go.  If not, maybe the user will send
     it back to me. */
! #include <readline/history.h>
  /* Number of commands to place in the bug report. */
  #define LAST_INTERESTING_HISTORY_COUNT 6
  
--- 940,946 ----
  /* Make a bug report, even to the extent of mailing it.  Hope that it
     gets where it is supposed to go.  If not, maybe the user will send
     it back to me. */
! #include "readline/history.h"
  /* Number of commands to place in the bug report. */
  #define LAST_INTERESTING_HISTORY_COUNT 6
  
diff -c orig/variable.c ./variable.c
*** orig/variable.c	Wed Jun  5 19:31:42 1991
--- ./variable.c	Fri Jun  7 13:07:14 1991
***************
*** 110,118 ****
    set_if_not ("PATH", DEFAULT_PATH_VALUE);
    set_var_auto_export ("PATH");
  
    set_if_not ("TERM", "dumb");
    set_var_auto_export ("TERM");
! 	
    set_if_not ("PS1", primary_prompt);
    set_if_not ("PS2", secondary_prompt);
    set_if_not ("IFS", " \t\n");
--- 110,122 ----
    set_if_not ("PATH", DEFAULT_PATH_VALUE);
    set_var_auto_export ("PATH");
  
+ #ifdef MiNT
+   set_if_not ("TERM", "vt52");
+ #else
    set_if_not ("TERM", "dumb");
+ #endif
    set_var_auto_export ("TERM");
! 
    set_if_not ("PS1", primary_prompt);
    set_if_not ("PS2", secondary_prompt);
    set_if_not ("IFS", " \t\n");
***************
*** 231,237 ****
--- 235,245 ----
       do if the variable had just been set. */
    {
      char *tilde_expand ();
+ #ifdef MiNT
+     char *tem = tilde_expand("~/bash_his");
+ #else
      char *tem = tilde_expand ("~/.bash_history");
+ #endif
  
      set_if_not ("HISTFILE", tem);
      free (tem);
***************
*** 438,444 ****
  {
    SHELL_VAR *entry = find_variable (name);
  
!   
    if (!entry)
      {
        /* Make a new entry for this variable.  Then do the binding. */
--- 446,452 ----
  {
    SHELL_VAR *entry = find_variable (name);
  
! 
    if (!entry)
      {
        /* Make a new entry for this variable.  Then do the binding. */
diff -c orig/version.h ./version.h
*** orig/version.h	Wed Jun  5 19:40:08 1991
--- ./version.h	Fri Jun  7 19:28:22 1991
***************
*** 5,8 ****
  #define DISTVERSION "1.05"
  
  /* The last built version of this shell. */
! #define BUILDVERSION 2
--- 5,8 ----
  #define DISTVERSION "1.05"
  
  /* The last built version of this shell. */
! #define BUILDVERSION 1
