# (Makefile for Mint-BASH under GCC)
# (Hacked together by Dave Gymer 05 Jun 91 (dpg@Cs.Nott.AC.UK))
# (Any suggestions for improvement will be greatly appreciated.)
# (This has been tested on a 4meg STE on a Minix partition with GCC 1.39.)

# (I have these. Why not you?)
BISON = bison
CC = gcc

# (This is where I keep my login shells.)
SHELL = d:/usr/bin/bash.prg

# (This is me. Unless you want to take over responsability, please leave
# this alone.)
MAINTAINER = dpg

# (I'm looking foward to the day when we can get rid of these and just
# pretend to be a UN*X box. MiNT will get there, in the end, I hope. :-)
MACHINE = atarist
OS = MiNT 

# (GCC-ST libraries now pretty complete. Most impressive.)
LINEBUF = -DHAVE_SETLINEBUF
VPRINTF = -DHAVE_VPRINTF

# (I've got a 4 meg machine. Those with less memory may find that -O is
# too big. Please let me know if you try. Also, while you're testing, you
# may find that taking -O out speeds compilation up _a lot_.)
SYSTEM_FLAGS = $(LINEBUF) $(VPRINTF) -D$(MACHINE) -D$(OS)
CFLAGS = -O -fomit-frame-pointer -fcombine-regs $(SYSTEM_FLAGS)

# These are required for sending bug reports.
SYSTEM_NAME = $(MACHINE)
OS_NAME = $(OS)

# The type of machine Bash is being compiled on.
HOSTTYPE_DECL = -DHOSTTYPE='"$(SYSTEM_NAME)"'

# The default primary and secondary prompts.
PPROMPT = '"${PROGRAM}\\$$ "'
SPROMPT = '"${PROGRAM}>"'

# The group of configuration flags.  These are for shell.c
CFG_FLAGS = -DMAINTAINER='"$(MAINTAINER)"' -DPPROMPT=$(PPROMPT) \
	    -DSPROMPT=$(SPROMPT) -DOS_NAME='$(OS_NAME)' \
	    -DSYSTEM_NAME='$(SYSTEM_NAME)' $(SIGLIST_FLAG)

RM = rm -f
AR = gcc-ar 

# Locally required libraries.
# (Integer only. Don't include symbol table (saves about 20k).)
LOCAL_LIBS = -s -liio

# (Must keep these in order, I think.)
LIBRARIES = -lreadline -ltermcap

OBJECTS  = shell.o parse-t.o general.o make_cmd.o print_cmd.o \
	   dispose_cmd.o execute_cmd.o variables.o builtins.o copy_cmd.o \
	   flags.o jobs.o subst.o glob.o hash.o mailcheck.o test.o \
	   trap.o alias.o braces.o unwind_prot.o \
	   $(SIGLIST) bashline.o ulimit.o version.o

# (build it, circumventing GCC's braindeaded-ness on Minix partitions)
xbash.prg:	.build $(OBJECTS)
	$(CC) -o NEWBASH.PRG $(OBJECTS) $(LIBRARIES) $(LOCAL_LIBS)
	mv NEWBASH.PRG xbash.prg

# (I built this on a Minix partition. I don't know how happy it'll be if
# you do this on a TOS parition. If you try, please let me know.)
.build:		.make newvers.ttp
	if ./newvers -build; then mv newversion.h version.h; fi

.make:
	@echo "   *   Making Bash for a $(MACHINE) running $(OS)."
	@echo "$(PROGRAM) last made for a $(MACHINE) running $(OS)" >.machine
	touch .make

version.h:	newvers.ttp
	if ./newvers -build; then mv newversion.h version.h; fi

shell.h:	general.h variables.h config.h
		touch shell.h

# (The problem with bison is that it needs lines in UN*X text file format.
# If you edit it with an editor which saves out the lines MeSsy-DOS-style
# (ie. with \n\r) like JOVE, make sure you transform it back somehow prior
# to re-making.)
parse-t.c:	parse.y shell.h
		$(BISON) -d parse.y

shell.o:	shell.h flags.h shell.c
		$(CC) $(CFG_FLAGS) $(CFLAGS) -c shell.c

braces.o:	braces.c
		$(CC) $(CFLAGS) -DSHELL -c braces.c

bashline.o:	bashline.c config.h variables.h builtins.h
jobs.o:		jobs.c nojobs.c jobs.h config.h
version.o:	version.h version.c .build
general.o:	general.c shell.h
parse-t.h:	parse-t.c
alias.o:	alias.h alias.c
subst.o:	subst.c shell.h
make_cmd.o:	shell.h config.h make_cmd.c
print_cmd.o:	shell.h parse-t.h print_cmd.c
execute_cmd.o:	shell.h parse-t.h builtins.h flags.h config.h execute_cmd.c
dispose_cmd.o:	shell.h dispose_cmd.c
copy_cmd.o:	shell.h copy_cmd.c
builtins.o:	shell.h flags.h trap.h builtins.h jobs.h config.h builtins.c
flags.o:	flags.h flags.c config.h
hash.o:		hash.h hash.c
trap.o:		shell.h trap.h config.h trap.c
variables.o:	variables.h flags.h variables.c
	$(CC) -c $(CFLAGS) $(HOSTTYPE_DECL) variables.c

# (I built this on a Minix partition. GCC is brain-dead!)
newvers.ttp:	newversion.c
		$(CC) -o NEWVERSI.PRG newversion.c -lpml
		mv NEWVERSI.PRG newvers.ttp
