/* 
 *  BATCH.C - batch file processor for COMMAND.COM.
 *
 *
 *
 *  Comments:
 *
 *  ??/??/?? (Evan Jeffrey) -------------------------------------------------
 *    started.
 *  
 *  07/15/95 (Tim Norman) ---------------------------------------------------
 *    modes and bugfixes.
 *
 *  08/08/95 (Matt Rains) ---------------------------------------------------
 *    i have cleaned up the source code. changes now bring this source into
 *    guidelines for recommended programming practice.
 *
 *    i have added some constants to help making changes easier.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <conio.h>

#include "command.h"

#define D_LABELERR   "ERROR: label not found!"
#define D_SYNTAXERR  "ERROR: syntax error!"
#define D_PAUSEMSG   "[press any key to continue]"
#define D_BEEP       "beep"
#define D_CALL       "call"
#define D_DOWN       "down"
#define D_ECHO       "echo"
#define D_ERRORLEVEL "errorlevel"
#define D_EXISTS     "exists"
#define D_GOTO       "goto"
#define D_IF         "if"
#define D_NOT        "not"
#define D_ON         "on"
#define D_OFF        "off"
#define D_PAUSE      "pause"
#define D_REM        "rem"
#define D_SHIFT      "shift"

/*
 *
 *
 *
 */
int batch(char *fullpath, int argc, char *argv[])
{
   FILE *bfile;

   static int nestlevel = 0; 
   static int called;
   static int echo = 1;
   int count; 
   int tokens;
   int shiftlevel = 0;
   int offset = 0;
   int linecho = 1; 
   int charnum;
   char textline[1024];
   char cmdline[1024]; 
   char *p[128];
   
   /* varibles found within code */
   int notval = 0;
   int found = 0;
   char varname[64];
   char filestring[256];

   nestlevel++; /* keep track of how many batch files are running */
   printf("\n");

   if(!(bfile = fopen(fullpath, "rt")))
   {
      return(1);
   }
   
   called = 1; /* used to determine if a batch file has been nested without the CALL comand */
   
   while(fgets(textline, 1023, bfile))
   {
      if(!strip(textline))
      {
         puts(D_SYNTAXERR);
         return(0);
      }
      if(textline[strlen(textline) - 2] == ' ' && textline[strlen(textline) - 1] == '\\')
      {
         fgets(textline+strlen(textline) - 1, 1023, bfile);
         
         if(!strip(textline))
         {
            puts(D_SYNTAXERR);
            return(0);
         }
      }
      tokens = split(textline, p);

      for(count = 0, offset = 0; count < tokens; count++)
      {
         charnum = 0;

         while(p[count][charnum])
         {
            if(p[count][charnum] == '%')
            {
               if(isdigit(p[count][charnum+1]))
               {
                  if(p[count][charnum+1] - '0' < argc - shiftlevel)
                  {
                     strcpy(&cmdline[offset], argv[p[count][charnum + 1] + shiftlevel - '0']);
                     offset += strlen(argv[p[count][charnum+1] + shiftlevel - '0']) + 1;
                     cmdline[offset - 1] = ' ';
                  }
                  
                  charnum++;
               }
               else if(p[count][charnum + 1] == '%')
               {
                  cmdline[offset] = '%';
                  offset++;
                  charnum += 2;
               }
               else if(strchr(p[count] + charnum + 1, '%'))
               {
                  strcpy(varname, p[count] + charnum + 1);
                  *strchr(varname, '%') = 0;
                  
                  strupr(varname); /* env. var must be upper case */

                  if(getenv(varname))
                  {
                     strcpy(&cmdline[offset], getenv(varname));
                     offset += strlen(getenv(varname));
                  }

                  charnum+=strlen(varname)+2;
               }
               else /* add code for environmental variables, strip 1 % sign from FOR variables */
               {
                  ; /* ignore the % sign, print the rest */
               }
            }
            else
            {
               cmdline[offset] = p[count][charnum];
               offset++;
            }
            
            charnum++;
         }
         
         cmdline[offset] = ' ';
         offset++;
      }
      
      cmdline[offset - 1] = 0;
      strcpy(textline, cmdline);
      tokens = split(textline,p);
      
      if(textline[0] == '@')
      {
         linecho = 0;
         strcpy(cmdline, cmdline + 1);
         p[0]++;
      }
      if(linecho && echo)
      {
         printprompt();
         puts(cmdline);
      }
      if(p[0][0] == 0)
      {
         ;
      }
      else if(!strcmpi(p[0], D_SHIFT))
      {
         if(!strcmpi(p[1], D_DOWN))
         {
            shiftlevel--;
            
            if(shiftlevel < 0)
            {
               shiftlevel = 0;
            }
         }
         else
         {
            shiftlevel++;
         }
      }
      else if(!strcmpi(p[0], D_PAUSE))
      {
         puts(D_PAUSEMSG);
         _getch();
      }                      
      else if(!strcmpi(p[0], D_ECHO))
      {
         if(!strcmpi(p[1], D_OFF))
         {
            echo = 0;
         }
         else if(!strcmpi(p[1], D_ON))
         {
            echo = 1;
         }
         else
         {
            puts(cmdline + 5);
         }
      }
      else if(!strcmpi(p[0], D_GOTO))
      {
         rewind(bfile);
         
         while((found - 1) && fgets(filestring, 255, bfile))
         {
            filestring[strlen(filestring) - 1] = 0;
            *strchr(filestring,' ') = 0;
            
            if(filestring[0] == ':')
            {
               if(!strcmpi(filestring + 1, p[1]))
               {
                  found = 1;
               }
            }
         }
         
         if(!found)
         {
            puts(D_LABELERR);
            return(1);
         }
      }
      else if(!strcmpi(p[0], D_IF))
      {
         if(!strcmpi(p[1], D_NOT))
         {
            notval++;
         }
         if(!strcmpi(p[1 + notval], D_ERRORLEVEL))
         {
            ;
         }
         else if(!strcmpi(p[1 + notval], D_EXISTS))
         {
            ;
         }
         else
         {
            ;
         }
      }
      else if(!strcmpi(p[0], D_REM))
      {
         ;
      }
      else if(!strcmpi(p[0], D_BEEP))
      {
         printf("\a");
      }
      else if(!strcmpi(p[0], D_CALL))
      {
         parsecommandline(cmdline + 5);
      }
      else if(p[0][0] == ':')
      {
         ;
      }
      else
      {
         called = 0;
         parsecommandline(cmdline);
         
         if(called)
         {
            return(0);
         }
         
         called = 1;
      }
   }
   
   fclose(bfile);
   nestlevel--;
   
   if(argc)
   {
      ;
   }
   
   if(nestlevel == 0)
   {
      echo = 1;
   }

   return(0);
}

/*
 * comment this out if you want to use MickeySoft C
 *
 *
 */
int _getch()
{
   return(getch());
}
