/* WADDIR.C list the directory of a WAD file */
/* Stefan Gustavson 1994 */

#include <stdio.h>


int getshort(filep)
     FILE *filep;
{
  short s;
  s = getc(filep) & 0xff;
  s += (getc(filep) & 0xff)<<8;
  return(s);
}

int getlong(filep)
     FILE *filep;
{
  int l;
  l = getc(filep) & 0xff;
  l += (getc(filep) & 0xff) <<8;
  l += (getc(filep) & 0xff) <<16;
  l += (getc(filep) & 0xff) <<24;
  return(l);
}


main(argc, argv)
     int argc;
     char *argv[];
{
  FILE *wadfile;
  char identifier[4];
  int i, numentries, dirstart, entrypos, entrysize;
  char entryname[8];
  
  if (argc != 2)
    {
      fprintf(stderr, "Usage: %s wadfile\n", argv[0]);
      exit(-1);
    }
  wadfile = fopen(argv[1], "r");
  if(wadfile == NULL)
    {
      fprintf(stderr, "File %s not found.\n", argv[1]);
      exit(-1);
    }
  fread(identifier, 4, 1, wadfile);
  if(strncmp("PWAD", identifier, 4) & strncmp("IWAD", identifier, 4))
    {
      fprintf(stderr, "File %s is not a WAD file.\n", argv[1]);
      exit(-1);
    }
  numentries = getlong(wadfile);
  dirstart = getlong(wadfile);
  if(fseek(wadfile, dirstart, 0))
    {
      fprintf(stderr, "File seek error.\n");
      exit(-1);
    }
 for(i=0; i<numentries; i++)
   {
     entrypos = getlong(wadfile);
     entrysize = getlong(wadfile);
     fread(entryname, 8, 1, wadfile);
     printf("%07d %5d %8s\n", entrypos, entrysize, entryname);
   }
  printf("\n");
  fclose(wadfile);
}

