/* WADLC.C */
/* A simple program to make custom Doom levels.
   Temporary beta version only - no support guaranteed!
   Author: Stefan Gustavson (stefang@isy.liu.se) 1994
   The entries SEGS, SSECTORS, NODES, REJECT and BLOCKMAP
   are left empty, but they are created in order not to
   confuse level editors and the program WAD_DWD used as
   a preprocessor to IDBSP.
*/

#include <stdio.h>
#include <string.h>
#include "wadlc.h"


void putshort(d, filep)
     short d;
     FILE *filep;
{
  putc(d & 0xff, filep);
  putc((d & 0xff00) >> 8, filep);  
}


void putlong(d, filep)
     long d;
     FILE *filep;
{
  putc(d & 0xff, filep);
  putc((d & 0xff00) >> 8, filep);
  putc((d & 0xff0000) >> 16, filep);
  putc((d & 0xff000000) >> 24, filep);
}

void addentry(pos, length, name, wadfile)
     int *pos, length;
     char *name;
     FILE *wadfile;
{
  static char entryname8[8];

  putlong(*pos, wadfile);
  putlong(length, wadfile);
  *pos += length;
  strncpy(entryname8, name, 8);
  fwrite(entryname8, 8, 1, wadfile);
  printf("Adding entry %s (%d bytes)\n", name, length);
}

int findmatch(name, table, numentries, length)
     char *name;
     char *table;
     int numentries;
     int length;
{
  int i;
  i=0;
  while(strncmp(name, table, 8) && (i<numentries))
    {
      i++;
      table += length;
    }
  if(i==numentries)
    {
      fprintf(stderr,"Couldn't match name: %s", name);
      exit(-1);
    }
  return(i);
}


void allowcomment(infile)
     FILE *infile;
{
  while (ungetc(getc(infile),infile) == '#')
    while (getc(infile) != '\n');
}


main(argc, argv)
     int argc;
     char *argv[];
{
  FILE *infile, *wadfile;
  FILE *datafile;
  char keyword[20];
  char vertexname[20], sectorname[20];
  char fromvertexname[20], tovertexname[20];
  int ox, oy, x, y;
  int numentries, reslength;
  int i, j;
  int episode, level;
  int lastitem;
  int floorh, ceilingh, brightness, special, tag, type, attrs, angle;
  char floort[20], ceilingt[20];
  char uppert[20], lowert[20], normalt[20];
  char rightsidedefname[20], leftsidedefname[20], thingname[20];
  int fromvertexindex, tovertexindex, rightsidedefindex, leftsidedefindex;
  int sectorindex;
  
  vertex_t  vertices[4096];
  sector_t  sectors[1024];
  sidedef_t sidedefs[8192];
  linedef_t linedefs[8192];
  thing_t   things[1024];
  int numvertices, numsectors, numsidedefs, numlinedefs, numthings;

  char entryname[9];
  int entrysize, entrypos;

  if (argc != 3)
    {
      fprintf(stderr,"Usage: %s infile outfile\n", argv[0]);
      exit(-1);
    }
  infile=fopen(argv[1],"r");
  if(infile==NULL)
    {
      fprintf(stderr,"Unable to open input file %s\n", argv[1]);
      exit(-1);
    }
  wadfile=fopen(argv[2],"w");
  if(wadfile==NULL)
    {
      fprintf(stderr,"Unable to create output file %s\n", argv[2]);
      exit(-1);
    }
  allowcomment(infile);
  fscanf(infile, " %s ", keyword);

  if(!strcmp(keyword,"LEVEL_START"))
    {
      fscanf(infile, " %d %d ", &episode, &level);
      allowcomment(infile);
      fscanf(infile, " %s ", keyword);
    }
  else
    {
      fprintf(stderr,"LEVEL_START marker missing!\n");
      exit(-1);
    }

  if(!strcmp(keyword,"VERTEXES_START") |
     !strcmp(keyword, "VERTICES_START"))
    {
      /* Process vertices until VERTEXES_END is found */
      lastitem = 0;
      numvertices = 0;
      while(!lastitem)
	{
	  allowcomment(infile);
	  fscanf(infile, " %s ", vertexname);
	  if(!strcmp(vertexname,"VERTEXES_END") |
	     !strcmp(vertexname, "VERTICES_END"))
	    lastitem = 1;
	  else
	    {
	      fscanf(infile, " : %d %d ", &x, &y);
	      allowcomment(infile);
	      vertices[numvertices].x = x;
	      vertices[numvertices].y = y;
	      strncpy(vertices[numvertices].name, vertexname, 8);
	      numvertices++;
	    }
	}
      fscanf(infile, " %s ", keyword);
    }
  else
    {
      fprintf(stderr,"VERTEXES_START marker missing!\n");
      exit(-1);
    }
  
  if(!strcmp(keyword,"SECTORS_START"))
    {
      /* Process sectors until SECTORS_END is found */
      lastitem = 0;
      numsectors = 0;
      while(!lastitem)
	{
	  allowcomment(infile);
	  fscanf(infile, " %s ", sectorname);
	  if(!strcmp(sectorname,"SECTORS_END")) lastitem = 1;
	  else
	    {
	      fscanf(infile, " : %d %d %s %s %d %d %d ", &floorh, &ceilingh,
		     floort, ceilingt, &brightness, &special, &tag);
	      allowcomment(infile);
	      sectors[numsectors].floorheight = floorh;
	      sectors[numsectors].ceilingheight = ceilingh;
	      sectors[numsectors].brightness = brightness;
	      sectors[numsectors].special = special;
	      sectors[numsectors].tag = tag;
	      strncpy(sectors[numsectors].name, sectorname, 8);
	      strncpy(sectors[numsectors].floortexture, floort, 8);
	      strncpy(sectors[numsectors].ceilingtexture, ceilingt, 8);
	      numsectors++;
	    }
	}
      fscanf(infile, " %s ", keyword);
    }
  else
    {
      fprintf(stderr,"SECTORS_START marker missing!\n");
      exit(-1);
    }

  if(!strcmp(keyword,"LINEDEFS_START"))
    {
      /* Process sectors until LINEDEFS_END is found */
      lastitem = 0;
      numlinedefs = 0;
      while(!lastitem)
	{
	  allowcomment(infile);
	  fscanf(infile, " %s ", fromvertexname);
	  if(!strcmp(fromvertexname,"LINEDEFS_END")) lastitem = 1;
	  else
	    {
	      fscanf(infile, " %s : %d %d %d ", tovertexname,
		     &attrs, &type, &tag);
	      allowcomment(infile);
	      fromvertexindex = findmatch(fromvertexname, (char*)vertices,
				      numvertices, sizeof(vertex_t));
	      tovertexindex = findmatch(tovertexname, (char*)vertices,
				      numvertices, sizeof(vertex_t));
	      /* Read one or two SIDEDEFS */
	      fscanf(infile, " %s %d %d %s %s %s ", sectorname, &ox, &oy,
		     uppert, lowert, normalt);
	      allowcomment(infile);
	      sectorindex = findmatch(sectorname, (char*)sectors,
				      numsectors, sizeof(sector_t));
	      sidedefs[numsidedefs].sector = sectorindex;
	      sidedefs[numsidedefs].xoffset = ox;
	      sidedefs[numsidedefs].yoffset = oy;
	      strncpy(sidedefs[numsidedefs].uppertexture, uppert, 8);
	      strncpy(sidedefs[numsidedefs].lowertexture, lowert, 8);
	      strncpy(sidedefs[numsidedefs].normaltexture, normalt, 8);
	      rightsidedefindex = numsidedefs;
	      numsidedefs++;
	      fscanf(infile, "%s", sectorname);
	      if(!strcmp(sectorname, "-"))
		{
		  allowcomment(infile);
		  leftsidedefindex = -1;
		}
	      else
		{
		  fscanf(infile, " %d %d %s %s %s ", &ox, &oy,
			 uppert, lowert, normalt);
		  allowcomment(infile);
		  sectorindex = findmatch(sectorname, (char*)sectors,
					  numsectors, sizeof(sector_t));
		  sidedefs[numsidedefs].sector = sectorindex;
		  sidedefs[numsidedefs].xoffset = ox;
		  sidedefs[numsidedefs].yoffset = oy;
		  strncpy(sidedefs[numsidedefs].uppertexture, uppert, 8);
		  strncpy(sidedefs[numsidedefs].lowertexture, lowert, 8);
		  strncpy(sidedefs[numsidedefs].normaltexture, normalt, 8);
		  leftsidedefindex = numsidedefs;
		  numsidedefs++;
		}
	      linedefs[numlinedefs].from = fromvertexindex;
	      linedefs[numlinedefs].to = tovertexindex;
	      linedefs[numlinedefs].attrs = attrs;
	      linedefs[numlinedefs].type = type;
	      linedefs[numlinedefs].tag = tag;
	      linedefs[numlinedefs].rightsidedef = rightsidedefindex;
	      linedefs[numlinedefs].leftsidedef = leftsidedefindex;
	      numlinedefs++;
	    }
	}
      fscanf(infile, " %s ", keyword);
    }
  else
    {
      fprintf(stderr,"LINEDEFS_START marker missing!\n");
      exit(-1);
    }

  if(!strcmp(keyword,"THINGS_START"))
    {
      /* Process things until THINGS_END is found */
      lastitem = 0;
      numthings = 0;
      while(!lastitem)
	{
	  allowcomment(infile);
	  fscanf(infile, " %s ", thingname);
	  if(!strcmp(thingname,"THINGS_END")) lastitem = 1;
	  else
	    {
	      sscanf(thingname, "%d", &type);
	      fscanf(infile, " : %d %d %d %d ", &x, &y, &angle, &attrs);
	      allowcomment(infile);
	      things[numthings].type = type;
	      things[numthings].x = x;
	      things[numthings].y = y;
	      things[numthings].angle = angle;
	      things[numthings].attrs = attrs;
	      numthings++;
	    }
	}
      fscanf(infile, " %s ", keyword);
    }
  else
    {
      fprintf(stderr,"THINGS_START marker missing!\n");
      exit(-1);
    }

  fclose(infile);

  /* Concatenate all the data into the final PWAD file */

  /* Header */
  fprintf(wadfile,"PWAD");
  numentries = 11;
  putlong(numentries, wadfile);
  reslength = numthings*10 + numlinedefs*14 + numsidedefs*30 +
    numvertices*4 + numsectors*26 + 12; /* The header is 12 bytes */
  putlong(reslength, wadfile);

  /* ExMy - start at position 12 (zero length entry) */

  /* THINGS - start at position 12 */
  for(i=0; i<numthings; i++)
    {
      putshort(things[i].x, wadfile);
      putshort(things[i].y, wadfile);
      putshort(things[i].angle, wadfile);
      putshort(things[i].type, wadfile);
      putshort(things[i].attrs, wadfile);
    }
  
  /* LINEDEFS - start at position 12 + numthings*10 */
  for(i=0; i<numlinedefs; i++)
    {
      putshort(linedefs[i].from, wadfile);
      putshort(linedefs[i].to, wadfile);
      putshort(linedefs[i].attrs, wadfile);
      putshort(linedefs[i].type, wadfile);
      putshort(linedefs[i].tag, wadfile);
      putshort(linedefs[i].rightsidedef, wadfile);
      putshort(linedefs[i].leftsidedef, wadfile);
    }

  /* SIDEDEFS - start at position 12 + numthings*10 + numlinedefs*14 */
  for(i=0; i<numsidedefs; i++)
    {
      putshort(sidedefs[i].xoffset, wadfile);
      putshort(sidedefs[i].yoffset, wadfile);
      fwrite(sidedefs[i].uppertexture, 8, 1, wadfile);
      fwrite(sidedefs[i].lowertexture, 8, 1, wadfile);
      fwrite(sidedefs[i].normaltexture, 8, 1, wadfile);	
      putshort(sidedefs[i].sector, wadfile);
    }
  
  /* VERTEXES - start at position 12 + numthings*10 + numlinedefs*14 + */
  /* numsidedefs*30 */
  for(i=0; i<numvertices; i++)
    {
      putshort(vertices[i].x, wadfile);
      putshort(vertices[i].y, wadfile);
    }
  
  /* SECTORS - start at position 12 + numthings*10 + numlinedefs*14+ */
  /* numsidedefs*30 + numvertices*4 */
  for(i=0; i<numsectors; i++)
    {
      putshort(sectors[i].floorheight, wadfile);
      putshort(sectors[i].ceilingheight, wadfile);
      fwrite(sectors[i].floortexture, 8, 1, wadfile);
      fwrite(sectors[i].ceilingtexture, 8, 1, wadfile);
      putshort(sectors[i].brightness, wadfile);
      putshort(sectors[i].special, wadfile);
      putshort(sectors[i].tag, wadfile);
    }

  
  /* Now, write the main directory */
  entrypos = 12;
  sprintf(entryname, "E%1dM%1d", episode, level);
  addentry(&entrypos, 0, entryname, wadfile);
  addentry(&entrypos, numthings*10, "THINGS", wadfile);
  addentry(&entrypos, numlinedefs*14, "LINEDEFS", wadfile);
  addentry(&entrypos, numsidedefs*30, "SIDEDEFS", wadfile);
  addentry(&entrypos, numvertices*4, "VERTEXES", wadfile);
  addentry(&entrypos, 0, "SEGS", wadfile);
  addentry(&entrypos, 0, "SSECTORS", wadfile);
  addentry(&entrypos, 0, "NODES", wadfile);
  addentry(&entrypos, numsectors*26, "SECTORS", wadfile);
  addentry(&entrypos, 0, "REJECT", wadfile);
  addentry(&entrypos, 0, "BLOCKMAP", wadfile);
  
  /* DONE! */
  fclose(wadfile);
}
