#!/bin/sh
# mkman.sh: Script to format manual pages

if [ $# -eq 0 ]; then
        echo "usage: `basename $0` command_name"
        exit 1
fi
if [ ! -r $1.[1-8ln] ]; then
	echo "$1.[1-8ln]: No such manual page"
        exit 1
fi

if [ "`which gnroff | grep ' in '`" = "" ]; then
	gnroff -man $1.[1-8ln] -P-u -P-b | cat -s > $1.man
else
	nroff -man $1.[1-8ln] | sed '1,$s/_//g' | cat -s > $1.man
fi

