' Program  "J2000"

' copyright (C) 1986 by David Eagle

' public domain on November 14, 1986

' IBM-PC  << QuickBASIC Compiler Version 3.0 >>

' conversion of stellar positions, proper motions, parallax and
' radial velocity from the standard epoch B1950 (FK4) to J2000 (FK5)
' reference: Astronomical Almanac, 1985, page X

'***************************************************************

OPTION BASE 1
DEFDBL A-Z

DIM A1(3),A2(3),UPV(3),UVV(3),R1(3),R2(6),R3(6),V2(3),M(6,6)

COMMON SHARED RAS.HR.1950,RAS.MIN.1950,RAS.SEC.1950
COMMON SHARED DEC.DEG.1950,DEC.MIN.1950,DEC.SEC.1950
COMMON SHARED RAS.PMOTION.1950,DEC.PMOTION.1950
COMMON SHARED PARALLAX.1950,RADIALV.1950

COMMON SHARED RAS.HR.2000,RAS.MIN.2000,RAS.SEC.2000
COMMON SHARED DEC.DEG.2000,DEC.MIN.2000,DEC.SEC.2000
COMMON SHARED RAS.PMOTION.2000,DEC.PMOTION.2000
COMMON SHARED PARALLAX.2000,RADIALV.2000

CONST PI=3.141592653589793D0
CONST PIDIV2=.5D0*PI
CONST DTR=PI/180D0
CONST RTD=180D0/PI
CONST XE=PI/12D0
CONST XER=12D0/PI

A1(1)=-.00000162557D0
A1(2)=-.00000031919D0
A1(3)=-.00000013843D0
A2(1)=.001244D0
A2(2)=-.001579D0
A2(3)=-.00066D0

' define elements of transformation matrix

M(1,1)=.9999256782D0
M(1,2)=-.0111820611D0
M(1,3)=-.0048579477D0
M(1,4)=.00000242395018D0
M(1,5)=-.00000002710663D0
M(1,6)=-.00000001177656D0
M(2,1)=.011182061D0
M(2,2)=.9999374784D0
M(2,3)=-.0000271765D0
M(2,4)=.00000002710663D0
M(2,5)=.00000242397878D0
M(2,6)=-.00000000006587D0
M(3,1)=.0048579479D0
M(3,2)=-.0000271474D0
M(3,3)=.9999881997D0
M(3,4)=.00000001177656D0
M(3,5)=-.00000000006582D0
M(3,6)=.00000242410173D0
M(4,1)=-.000551D0
M(4,2)=-.238565D0
M(4,3)=.435739D0
M(4,4)=.99994704D0
M(4,5)=-.01118251D0
M(4,6)=-.00485767D0
M(5,1)=.238514D0
M(5,2)=-.002667D0
M(5,3)=-.008541D0
M(5,4)=.01118251D0
M(5,5)=.99995883D0
M(5,6)=-.00002718D0
M(6,1)=-.435623D0
M(6,2)=.012254D0
M(6,3)=.002117D0
M(6,4)=.00485767D0
M(6,5)=-.00002714D0
M(6,6)=1.00000956D0

' initialization

CLS
PRINT
PRINT "Program J2000"
PRINT "(C) Copyright 1986 by David Eagle"
PRINT
PRINT "Microsoft QuickBASIC Compiler"
PRINT "(C) Copyright Microsoft Corp. 1982-1987"
PRINT
CALL KEYCHECK

CLS
PRINT
PRINT
PRINT "Program introduction ( y = yes, n = no )"
INPUT INTRO$
IF INSTR("yY",INTRO$) THEN CALL INTRODUCTION

' main program loop

DO
CLS
PRINT
PRINT
PRINT "Right ascension with respect to 1950"
PRINT "( hours [ 0 - 23 ], minutes [ 0 - 59 ], seconds [ 0 - 59 ] )"
INPUT RAS.HR.1950,RAS.MIN.1950,RAS.SEC.1950
PRINT
PRINT "Declination with respect to 1950"
PRINT "( degrees [ -90 to +90 ], minutes [ 0 - 59 ], seconds [ 0 - 59 ] )"
INPUT DEC.DEG.1950,DEC.MIN.1950,DEC.SEC.1950
PRINT
PRINT "Right ascension proper motion with respect to 1950"
PRINT "( arc seconds per tropical century )"
INPUT RAS.PMOTION.1950
PRINT
PRINT "Declination proper motion with respect to 1950"
PRINT "( arc seconds per tropical century )"
INPUT DEC.PMOTION.1950
PRINT
PRINT "Parallax with respect to 1950 ( arc seconds )"
INPUT PARALLAX.1950
PRINT
PRINT "Radial velocity with respect to 1950 ( kilometers per second )"
INPUT RADIALV.1950

' convert 1950 right ascension and declination to radians

RAS.1950=XE*(RAS.HR.1950+RAS.MIN.1950/60D0+RAS.SEC.1950/3600D0)
DEC.1950=DTR*SGN(DEC.DEG.1950)*(ABS(DEC.DEG.1950)+(DEC.MIN.1950*60D0+DEC.SEC.1950)/3600D0)

' calculate unit position vector

UPV(1)=COS(RAS.1950)*COS(DEC.1950)
UPV(2)=SIN(RAS.1950)*COS(DEC.1950)
UPV(3)=SIN(DEC.1950)

K1=21.095D0*RADIALV.1950*PARALLAX.1950

' calculate unit velocity vector

UVV(1)=-RAS.PMOTION.1950*SIN(RAS.1950)*COS(DEC.1950)-DEC.PMOTION.1950*COS(RAS.1950)*SIN(DEC.1950)+K1*UPV(1)
UVV(2)=RAS.PMOTION.1950*COS(RAS.1950)*COS(DEC.1950)-DEC.PMOTION.1950*SIN(RAS.1950)*SIN(DEC.1950)+K1*UPV(2)
UVV(3)=DEC.PMOTION.1950*COS(DEC.1950)+K1*UPV(3)

' E-term constants

K2=A1(1)*UPV(1)+A1(2)*UPV(2)+A1(3)*UPV(3)
K3=A2(1)*UPV(1)+A2(2)*UPV(2)+A2(3)*UPV(3)

FOR I%=1 TO 3
    R1(I%)=UPV(I%)-A1(I%)+K2*UPV(I%)
    R2(I%)=R1(I%)
    V2(I%)=UVV(I%)-A2(I%)+K3*UPV(I%)
    R2(I%+3)=V2(I%)
NEXT I%

' matrix multiplication

FOR I%=1 TO 6
    A=0D0
    FOR J%=1 TO 6
        A=A+M(I%,J%)*R2(J%)
    NEXT J%
    R3(I%)=A
NEXT I%

RM.2000=SQR(R3(1)^2+R3(2)^2+R3(3)^2)

' compute declination wrt J2000

CALL ARCSIN(R3(3)/RM.2000,B)
CALL CONVERT(B*RTD,DEC.DEG.2000,DEC.MIN.2000,DEC.SEC.2000)

' compute right ascension wrt J2000

CALL ATAN3(R3(2),R3(1),C)
CALL CONVERT(C*XER,RAS.HR.2000,RAS.MIN.2000,RAS.SEC.2000)

K4=R3(1)^2+R3(2)^2

' compute proper motions wrt J2000

RAS.PMOTION.2000=(R3(1)*R3(5)-R3(2)*R3(4))/K4
DEC.PMOTION.2000=(R3(6)*K4-R3(3)*(R3(1)*R3(4)+R3(2)*R3(5)))/(RM.2000^2*SQR(K4))

' compute parallax and radial velocity wrt J2000

IF PARALLAX.1950=0D0 THEN
  RADIALV.2000=RADIALV.1950
ELSE
  RADIALV.2000=(R3(1)*R3(4)+R3(2)*R3(5)+R3(3)*R3(6))/(21.095D0*PARALLAX.1950*RM.2000)
END IF

PARALLAX.2000=PARALLAX.1950/RM.2000

CALL DISPLAY.DATA

CLS
PRINT
PRINT
PRINT "Another selection ( y = yes, n = no )"
INPUT SELECTION$
LOOP UNTIL INSTR("nN",SELECTION$)

END


'***************************************************************

SUB CONVERT(DEG,HR,MIN,SEC) STATIC

    ' convert degrees to hms or dms subroutine

    HR=FIX(DEG)
    C=ABS(HR-DEG)*60D0
    MIN=INT(C)
    D=(C-MIN)*60D0
    SEC=INT(D+.5D0)

END SUB

'***************************************************************

SUB DISPLAY.DATA STATIC

    ' display data subroutine

    FORMAT$="########.###"

    CLS
    PRINT
    PRINT TAB(24);"* 1950 < FK4 > *"
    PRINT
    a$=STR$(RAS.HR.1950)+" hours"+STR$(RAS.MIN.1950)+" minutes"+STR$(RAS.SEC.1950)+" seconds"
    PRINT TAB(5);"Right ascension";TAB(60-LEN(a$));a$
    a$=STR$(DEC.DEG.1950)+" degrees"+STR$(DEC.MIN.1950)+" minutes"+STR$(DEC.SEC.1950)+" seconds"
    PRINT TAB(5);"Declination";TAB(60-LEN(a$));a$
    PRINT
    PRINT TAB(5);"Right ascension proper motion";
    PRINT USING FORMAT$;TAB(48);RAS.PMOTION.1950
    PRINT TAB(5);"Declination proper motion";
    PRINT USING FORMAT$;TAB(48);DEC.PMOTION.1950
    PRINT
    PRINT TAB(5);"Parallax        (arc seconds)";
    PRINT USING FORMAT$;TAB(48);PARALLAX.1950
    PRINT TAB(5);"Radial velocity (kilometers per second)";
    PRINT USING FORMAT$;TAB(48);RADIALV.1950
    PRINT
    PRINT TAB(24);"* 2000 < FK5 > *"
    PRINT
    a$=STR$(RAS.HR.2000)+" hour"+STR$(RAS.MIN.2000)+" minutes"+STR$(RAS.SEC.2000)+" seconds"
    PRINT TAB(5);"Right ascension";TAB(60-LEN(a$));a$
    a$=STR$(DEC.DEG.2000)+" degrees"+STR$(DEC.MIN.2000)+" minutes"+STR$(DEC.SEC.2000)+" seconds"
    PRINT TAB(5);"Declination";TAB(60-LEN(a$));a$
    PRINT
    PRINT TAB(5);"Right ascension proper motion";
    PRINT USING FORMAT$;TAB(48);RAS.PMOTION.2000
    PRINT TAB(5);"Declination proper motion";
    PRINT USING FORMAT$;TAB(48);DEC.PMOTION.2000
    PRINT
    PRINT TAB(5);"Parallax        (arc seconds)";
    PRINT USING FORMAT$;TAB(48);PARALLAX.2000
    PRINT TAB(5);"Radial velocity (kilometers per second)";
    PRINT USING FORMAT$;TAB(48);RADIALV.2000
    CALL KEYCHECK

END SUB

'***************************************************************

SUB ATAN3(SINANGLE,COSANGLE,ANGLE) STATIC

    ' four quadrant inverse tangent subroutine

    IF ABS(SINANGLE)<1D-08 THEN
       ANGLE=(1-SGN(COSANGLE))*PIDIV2
       EXIT SUB
    END IF

       ANGLE=(2-SGN(SINANGLE))*PIDIV2

    IF ABS(COSANGLE)<1D-08 THEN
      EXIT SUB
    ELSE
      ANGLE=ANGLE+SGN(SINANGLE)*SGN(COSANGLE)*(ABS(ATN(SINANGLE/COSANGLE))-PIDIV2)
    END IF

END SUB

'***************************************************************

SUB ARCSIN(SINANGLE,ANGLE) STATIC

    ' inverse sine subroutine

    IF ABS(SINANGLE)>=1 THEN
       ANGLE=SGN(SINANGLE)*PIDIV2
    ELSE
       ANGLE=ATN(SINANGLE/SQR(1-SINANGLE^2))
    END IF

END SUB

'***************************************************************

SUB INTRODUCTION STATIC

    ' program introduction subroutine

    CLS
    PRINT
    PRINT TAB(10);"J2000 is an interactive QuickBASIC program which can be"
    PRINT TAB(10);"used to convert stellar positions, proper motions,"
    PRINT TAB(10);"parallax and radial velocity from the standard epoch"
    PRINT TAB(10);"B1950 (FK4) to J2000 (FK5). The method used in this"
    PRINT TAB(10);"program is based on the algorithm published in the 1985"
    PRINT TAB(10);"edition of the Astronomical Almanac, Addendum to Section"
    PRINT TAB(10);"B, page X. This technique is an approximation because"
    PRINT TAB(10);"it does not account for systematic and individual star"
    PRINT TAB(10);"corrections between the FK4 and FK5 epochs."
    PRINT
    PRINT TAB(10);"J2000 will first request the right ascension, declination,"
    PRINT TAB(10);"right ascension proper motion, declination proper motion,"
    PRINT TAB(10);"parallax and radial velocity of a stellar object with"
    PRINT TAB(10);"respect to the 1950 (FK4) epoch. Each program prompt will"
    PRINT TAB(10);"advise you of the proper units to input. If you do not"
    PRINT TAB(10);"have a number for proper motion or parallax or radial"
    PRINT TAB(10);"velocity, then input '0' for any of these values."
    CALL KEYCHECK

END SUB

'***************************************************************

SUB KEYCHECK STATIC

    ' check user response subroutine

    PRINT
    PRINT
    PRINT TAB(20);"< press any key to continue >";

    A$=""
    WHILE A$=""
      A$=INKEY$
    WEND

END SUB

