' Program "SYNCSAT"

' Copyright (C) 1982 by David Eagle

' IBM-PC  << QuickBASIC Compiler Version 2.0 >>

' Public domain for the IBM-PC on October 8, 1986

' computes direction of geosynchronous satellites

' azimuth angle; positive clockwise from north ( degrees )
' elevation angle; positive above the horizon ( degrees )

'**********************************************************

DEFDBL A-Z
OPTION BASE 1

CONST RREQ=1D0/637814D0
CONST FLAT=1D0/298.257D0
CONST PI=3.14159265D0
CONST PIDIV2=.5D0*PI
CONST HGEO=6.6107426D0
CONST DTR=PI/180D0
CONST RTD=180D0/PI

DIM SHARED LV(3),UP(3),MATRIX(3,3)

COMMON SHARED OBSLAT,OBSLONG,OBSALT,XOBS,YOBS,ZOBS
COMMON SHARED AZIMUTH,ELEVATION

CLS
PRINT
PRINT
PRINT "Program SYNCSAT"
PRINT "(C) Copyright 1982 by David Eagle"
PRINT
PRINT "Microsoft QuickBASIC Compiler"
PRINT "(C) Copyright Microsoft Corp. 1982-1987"
PRINT
CALL KEYCHECK

CLS
PRINT
PRINT
PRINT "Program introduction ( y = yes, n = no )"
INPUT intro$
IF INSTR("yY",intro$) THEN CALL INTRODUCTION

MAIN:
CLS
PRINT
PRINT
PRINT TAB(16);"Program SYNCSAT"
LOCATION:
PRINT
PRINT
PRINT "Observer latitude ( degrees [ - 90 to + 90 ] )"
PRINT "< north latitudes are positive, south latitudes are negative >"
INPUT OBSLAT
PRINT
PRINT "Observer west longitude ( degrees [ 0 - 360 ] )"
INPUT OBSLONG
PRINT
PRINT "Observer altitude ( meters )"
PRINT "< positive above sea level, negative below sea level >"
INPUT OBSALT
SATELLITE:
PRINT
PRINT "Satellite west longitude ( degrees [ 0 - 360 ] )"
INPUT SATLONG

' calculate observer's position

CALL OBSVECTOR

' calculate satellite's position

A=-SATLONG*DTR
XSAT=HGEO*COS(A)
YSAT=HGEO*SIN(A)

' calculate pointing angles to satellite

X3=XSAT-XOBS
Y3=YSAT-YOBS
Z3=-ZOBS

R=SQR(X3^2+Y3^2+Z3^2)

UP(1)=X3/R
UP(2)=Y3/R
UP(3)=Z3/R

CALL TOPOCENTRIC

' print results

FORMAT$="####.###"

CLS
PRINT
PRINT
PRINT TAB(28);"Program SYNCSAT"
PRINT
PRINT
PRINT
PRINT TAB(5);"Observer latitude         ( degrees )";
PRINT USING FORMAT$;TAB(50);OBSLAT
PRINT
PRINT TAB(5);"Observer west longitude   ( degrees )";
PRINT USING FORMAT$;TAB(50);OBSLONG
PRINT
PRINT TAB(5);"Observer altitude         ( meters )";
PRINT USING FORMAT$;TAB(50);OBSALT
PRINT
PRINT
PRINT TAB(5);"Azimuth                   ( degrees )";
PRINT USING FORMAT$;TAB(50);AZIMUTH
PRINT
PRINT TAB(5);"Elevation                 ( degrees )";
PRINT USING FORMAT$;TAB(50);ELEVATION
PRINT
PRINT
PRINT TAB(5);"Satellite west longitude  ( degrees )";
PRINT USING FORMAT$;TAB(50);SATLONG
PRINT
CALL KEYCHECK

' request another selection

CLS
PRINT
PRINT
PRINT "Another selection ( y = yes, n = no )"
INPUT REPLY$
IF INSTR("nN",REPLY$) THEN END
PRINT
PRINT "Another location ( y = yes, n = no )"
INPUT REPLY$
IF INSTR("yY",REPLY$) THEN GOTO LOCATION
PRINT
PRINT "Another satellite ( y = yes, n = no )"
INPUT REPLY$
IF INSTR("yY",REPLY$) THEN GOTO SATELLITE
GOTO MAIN

END

'***************************************************************

SUB OBSVECTOR STATIC

  ' observer position vector subroutine

  A=OBSLAT*DTR
  B=SIN(A)
  C=COS(A)
  D=1D0-FLAT
  E=SQR(1D0-(2D0*FLAT-FLAT^2)*B^2)
  F=1D0/E+OBSALT*RREQ
  G=D^2/E+OBSALT*RREQ
  H=-OBSLONG*DTR
  XOBS=F*C*COS(H)
  YOBS=F*C*SIN(H)
  ZOBS=G*B

END SUB

'***************************************************************

SUB TOPOCENTRIC STATIC

  ' eci to topocentric subroutine

  A=SIN(OBSLAT*DTR)
  B=COS(OBSLAT*DTR)
  C=SIN(-OBSLONG*DTR)
  D=COS(-OBSLONG*DTR)
  MATRIX(1,1)=A*D
  MATRIX(1,2)=A*C
  MATRIX(1,3)=-B
  MATRIX(2,1)=-C
  MATRIX(2,2)=D
  MATRIX(2,3)=0D0
  MATRIX(3,1)=B*D
  MATRIX(3,2)=B*C
  MATRIX(3,3)=A

  FOR I%=1 TO 3
    A=0D0
    FOR J%=1 TO 3
      A=A+MATRIX(I%,J%)*UP(J%)
    NEXT J%
    LV(I%)=A
  NEXT I%

  IF ABS(LV(3))>1D0 THEN
    ELEVATION=SGN(LV(3))*90D0
  ELSE
    ELEVATION=(ATN(LV(3)/SQR(1D0-LV(3)^2)))*RTD
  END IF

  A=LV(2)
  B=-LV(1)
  CALL ATAN3(A,B,C)
  AZIMUTH=RTD*C

END SUB

'***************************************************************

SUB ATAN3(A,B,C) STATIC

  ' 4-quadrant arc tangent subroutine

  IF ABS(A)<1D-08 THEN
    C=(1-SGN(B))*PIDIV2
    EXIT SUB
  ELSE
    C=(2-SGN(A))*PIDIV2
  END IF
  IF ABS(B)<1D-08 THEN
    EXIT SUB
  ELSE
    C=C+SGN(A)*SGN(B)*(ABS(ATN(A/B))-PIDIV2)
  END IF

END SUB

'***************************************************************

SUB KEYCHECK STATIC

  ' check user response subroutine

  PRINT
  PRINT
  PRINT TAB(20);"< press any key to continue >";

  A$=""
  WHILE A$=""
    A$=INKEY$
  WEND

END SUB

'***************************************************************

SUB INTRODUCTION STATIC

  ' program introduction subroutine

  CLS
  PRINT TAB(15);"    Program 'SYNCSAT' is an interactive"
  PRINT TAB(15);"BASIC computer program which can be"
  PRINT TAB(15);"used to determine both the azimuth and"
  PRINT TAB(15);"elevation pointing angles from an earth"
  PRINT TAB(15);"observer anywhere in the world to a"
  PRINT TAB(15);"geosynchronous satellite. The software"
  PRINT TAB(15);"in this program takes into account the"
  PRINT TAB(15);"effect of the flattening or 'oblateness'"
  PRINT TAB(15);"of the earth on the observer location"
  PRINT TAB(15);"on the earth. It also compensates for"
  PRINT TAB(15);"'non-sea level' observation and antenna"
  PRINT TAB(15);"sites. These features provide the user"
  PRINT TAB(15);"with very accurate pointing angles."
  PRINT
  PRINT TAB(15);"     USER INPUTS AND SELECTIONS"
  PRINT
  PRINT TAB(15);"   Program SYNCSAT will prompt the user"
  PRINT TAB(15);"for several inputs necessary for the"
  PRINT TAB(15);"software to work properly. This is a"
  PRINT TAB(15);"description of these requests and a"
  PRINT TAB(15);"discussion of the proper user response."
  CALL KEYCHECK

  CLS
  PRINT TAB(15);"    Observer latitude ( degrees )"
  PRINT
  PRINT TAB(15);"The user should respond with his or her"
  PRINT TAB(15);"geographic latitude in decimal degrees"
  PRINT TAB(15);"taking note of the sign convention. For"
  PRINT TAB(15);"example, an observer at 42 degrees, 30"
  PRINT TAB(15);"minutes north latitude would input 42.5."
  PRINT
  PRINT TAB(15);"    Observer west longitude ( degrees )"
  PRINT
  PRINT TAB(15);"The proper response here will be the"
  PRINT TAB(15);"observer's west longitude in decimal"
  PRINT TAB(15);"degrees. West longitude equals 360"
  PRINT TAB(15);"degrees minus east longitude."
  PRINT
  PRINT TAB(15);"    Observer altitude ( meters )"
  PRINT
  PRINT TAB(15);"At this point the user should input the"
  PRINT TAB(15);"altitude at his or her location in the"
  PRINT TAB(15);"units of meters. Sites above sea level"
  PRINT TAB(15);"are input as positive numbers and those"
  PRINT TAB(15);"below sea level are negative numbers."
  CALL KEYCHECK

  CLS
  PRINT TAB(15);"   Satellite west longitude ( degrees )"
  PRINT
  PRINT TAB(15);"The user should respond with the west"
  PRINT TAB(15);"longitude of the satellite of interest."
  PRINT TAB(15);"This number is input in decimal degrees."
  PRINT TAB(15);" After the program has run, it will ask"
  PRINT TAB(15);"the user for another selection. A user"
  PRINT TAB(15);"should respond with 'y' if he or she"
  PRINT TAB(15);"desires the selection or 'n' if not."
  PRINT
  PRINT TAB(15);"    Another selection ( y = yes, n = no ) ?"
  PRINT
  PRINT TAB(15);"A user response of 'n' will exit the"
  PRINT TAB(15);"'SYNCSAT' program."
  PRINT
  PRINT TAB(15);"    Another location ( y = yes, n = no ) ?"
  PRINT
  PRINT TAB(15);"The user should respond with 'y' to"
  PRINT TAB(15);"compute the location of a satellite"
  PRINT TAB(15);"relative to another geographic location."
  CALL KEYCHECK

  CLS
  PRINT TAB(15);"     Another satellite ( y = yes, n = no ) ?"
  PRINT
  PRINT TAB(15);"The user should respond with 'y' to"
  PRINT TAB(15);"compute the pointing angles to another"
  PRINT TAB(15);"geosynchronous satellite."
  PRINT
  PRINT TAB(15);"          PROGRAM OUTPUT"
  PRINT
  PRINT TAB(15);"Program 'SYNCSAT' outputs the observer-"
  PRINT TAB(15);"centered or 'topocentric' azimuth and"
  PRINT TAB(15);"elevation angles from an observer to a"
  PRINT TAB(15);"geosynchronous satellite. Azimuth is"
  PRINT TAB(15);"measured positive clockwise from north"
  PRINT TAB(15);"and elevation is positive above the"
  PRINT TAB(15);"observer's horizon. For example, an"
  PRINT TAB(15);"azimuth angle of 90 degrees is east and"
  PRINT TAB(15);"180 degrees is south, etc. Elevation"
  PRINT TAB(15);"angles which are negative indicate that"
  PRINT TAB(15);"the satellite cannot be seen from an"
  PRINT TAB(15);"observer's location. Both angles are"
  PRINT TAB(15);"printed in decimal degrees."
  CALL KEYCHECK

END SUB
