' Program "SIDEREAL"

' Copyright (C) 1986 by David Eagle

' Determines the relationships between times and dates

' public domain for IBM-PC on March 30, 1986

' IBM-PC  << QuickBASIC Compiler Version 3.0 >>

'********************************************************************

DEFDBL A-Z
OPTION BASE 1

DIM SHARED MONTH$(12)

COMMON SHARED OBSLONG$,LCT$,CDATE$,LST$,CHOICE%
COMMON SHARED OBSLONG.RAD,ZONE%,DST%
COMMON SHARED MONTH%,DAY%,YEAR%,JD0,JDATE
COMMON SHARED LCT.HR,LCT.MIN,LCT.SEC,LST.HR,LST.MIN,LST.SEC

CONST PI=3.141592653589793D0
CONST PI2=2D0*PI
CONST DTR=PI/180D0
CONST WE=.262516145D0
CONST XE=PI/12D0
CONST XER=12D0/PI

MONTH$(1)="January"
MONTH$(2)="February"
MONTH$(3)="March"
MONTH$(4)="April"
MONTH$(5)="May"
MONTH$(6)="June"
MONTH$(7)="July"
MONTH$(8)="August"
MONTH$(9)="September"
MONTH$(10)="October"
MONTH$(11)="November"
MONTH$(12)="December"

DEF FNJDATE0(MONTH%,DAY%,YEAR%)
    'Julian Date function
    F=367D0*YEAR%-INT(7*((YEAR%+INT((MONTH%+9)/12))/4))
    F=F+INT(275*MONTH%/9)+DAY%+1721028.5D0
    FNJDATE0=F-INT(3*(INT((YEAR%+SGN(MONTH%-9)*INT(ABS((MONTH%-9)/7)))/100)+1)/4)
END DEF

DEF FNGMT(H,M,S,ZONE%,DST%)=H+M/60D0+S/3600D0+ZONE%-DST%
DEF FNDEMOD(X)=X-PI2*INT(X/PI2)

'********************************************************************

' initialization

CLS
PRINT
PRINT "Program SIDEREAL"
PRINT "(C) Copyright 1986 by David Eagle"
PRINT
PRINT "Microsoft QuickBASIC Compiler"
PRINT "(C) Copyright Microsoft Corp. 1982-1987"
PRINT
CALL KEYCHECK

CLS
PRINT
PRINT
PRINT "Program introduction ( y = yes, n = no )"
INPUT INTRO$
IF INSTR("yY",INTRO$) THEN CALL INTRODUCTION

DO
   CALL SELECTION.MENU

   SELECT CASE CHOICE%
   CASE 1
        CALL JDATE.FROM.GDATE
   CASE 2
        CALL GDATE.FROM.JDATE
   CASE 3
        CALL LST.FROM.LCT
   CASE 4
        CALL LCT.FROM.LST
   END SELECT

   CALL DISPLAY.DATA

   CLS
   PRINT
   PRINT
   PRINT "Another selection ( y = yes, n = no )"
   INPUT SELECTION$
LOOP UNTIL INSTR("nN",SELECTION$)

END

'********************************************************************

SUB LCT.FROM.LST STATIC

    ' local civil time from local sidereal time subroutine

    CLS
    PRINT
    PRINT
    PRINT "Calendar date ( month [ 1 - 12 ], day [ 1 - 31 ], year [ YYYY ] )"
    PRINT "( NOTE: B.C. dates are negative, A.D. dates are positive )"
    PRINT "( For example, October 21, 1948 is input as 10,21,1948 )"
    INPUT MONTH%,DAY%,YEAR%
    CDATE$=MONTH$(MONTH%)+STR$(DAY%)+","+STR$(YEAR%)
    PRINT
    PRINT "Local sidereal time ( hours [ 0 - 23 ], minutes [ 0 - 59 ], seconds [ 0 - 59 ] )"
    INPUT LST.HR,LST.MIN,LST.SEC
    LST$=STR$(LST.HR)+" hours"+STR$(LST.MIN)+" minutes"+STR$(LST.SEC)+" seconds"
    PRINT
    PRINT "Observer west longitude"
    PRINT "( degrees [ 0 - 359 ], minutes [ 0 - 59 ], seconds [ 0 - 59 ] )"
    INPUT OBSLONG.DEG,OBSLONG.MIN,OBSLONG.SEC
    OBSLONG.RAD=DTR*(OBSLONG.DEG+OBSLONG.MIN/60D0+OBSLONG.SEC/3600D0)
    OBSLONG$=STR$(OBSLONG.DEG)+ " degrees"+STR$(OBSLONG.MIN)+" minutes"+STR$(OBSLONG.SEC)+" seconds"
    PRINT
    PRINT "Time zone ( 0 - 23 )"
    PRINT "( For example, Eastern Standard Time (EST) is time zone 5 )"
    INPUT ZONE%
    PRINT
    PRINT "Daylight Savings Time ( y = yes, n = no )"
    INPUT DST$
    IF INSTR("yY",DST$) THEN
       DST%=1
    ELSE
       DST%=0
    END IF
    JD0=FNJDATE0(MONTH%,DAY%,YEAR%)
    T2=(JD0-2451545D0)/36525D0
    LST=FNDEMOD(1.75336856D0+628.331971D0*T2+6.7707D-06*T2^2)
    T1=XE*(LST.HR+LST.MIN/60D0+LST.SEC/3600D0)

    IF ABS(LST-T1)<.001D0 THEN
       T2=(JD0-2451544D0)/36525D0
       LST=FNDEMOD(1.75336856D0+628.331971D0*T2+6.7707D-06*T2^2)
       T1=XE*(LST.HR+LST.MIN/60D0+LST.SEC/3600D0)
    END IF

    A=(T1-LST+OBSLONG.RAD)/WE-ZONE%+DST%
    A=A-24D0*INT(A/24D0)
    CALL CONVERT(A,LCT.HR,LCT.MIN,LCT.SEC)
    LCT$=STR$(LCT.HR)+" hours"+STR$(LCT.MIN)+" minutes"+STR$(LCT.SEC)+" seconds"
    JDATE=JD0+(LCT.HR+LCT.MIN/60D0+LCT.SEC/3600D0+ZONE%-DST%)/24D0

END SUB

'********************************************************************

SUB JDATE.FROM.GDATE STATIC

    ' Julian date from calendar date subroutine

    CLS
    PRINT
    PRINT
    PRINT "Calendar date ( month [ 1 - 12 ], day [ 1 - 31 ], year [ YYYY ] )"
    PRINT "( NOTE: B.C. dates are negative, A.D. dates are positive )"
    PRINT "( For example, October 21, 1948 is input as 10,21,1948 )"
    INPUT MONTH%,DAY%,YEAR%
    CDATE$=MONTH$(MONTH%)+STR$(DAY%)+","+STR$(YEAR%)
    PRINT
    PRINT "Local civil time ( hours [ 0 - 23 ], minutes [ 0 - 59 ] ), seconds [ 0 - 59 ] )"
    PRINT "( For example, 8:30:45 p.M. is input as 20,30,45 )"
    INPUT LCT.HR,LCT.MIN,LCT.SEC
    LCT$=STR$(LCT.HR)+" hours"+STR$(LCT.MIN)+" minutes"+STR$(LCT.SEC)+" seconds"
    PRINT
    PRINT "Time zone ( 0 - 23 )"
    PRINT "( For example, Eastern Standard Time (EST) is time zone 5 )"
    INPUT ZONE%
    PRINT
    PRINT "Daylight Savings Time ( y = yes, n = no )"
    INPUT DST$
    IF INSTR("yY",DST$) THEN
       DST%=1
    ELSE
       DST%=0
    END IF
    JD0=FNJDATE0(MONTH%,DAY%,YEAR%)
    GMT.TIME=FNGMT(LCT.HR,LCT.MIN,LCT.SEC,ZONE%,DST%)
    JDATE=JD0+GMT.TIME/24D0

END SUB

'********************************************************************

SUB LST.FROM.LCT STATIC

    ' local sidereal time from local civil time subroutine

    CLS
    PRINT
    PRINT
    PRINT "Calendar date ( month [ 1 - 12 ], day [ 1 - 31 ], year [ YYYY ] )"
    PRINT "( NOTE: B.C. dates are negative, A.D. dates are positive )"
    PRINT "( For example, October 21, 1948 is input as 10,21,1948 )"
    INPUT MONTH%,DAY%,YEAR%
    CDATE$=MONTH$(MONTH%)+STR$(DAY%)+","+STR$(YEAR%)
    PRINT
    PRINT "Local civil time ( hours [ 0 - 23 ], minutes [ 0 - 59 ], seconds [ 0 - 59 ] )"
    PRINT "( For example, 8:30:45 p.m. is input as 20,30,45 )"
    INPUT LCT.HR,LCT.MIN,LCT.SEC
    LCT$=STR$(LCT.HR)+" hours"+STR$(LCT.MIN)+" minutes"+STR$(LCT.SEC)+" seconds"
    PRINT
    PRINT "Observer west longitude"
    PRINT "( degrees [ 0 - 359 ], minutes [ 0 - 59 ], seconds [ 0 - 59 ] )"
    INPUT OBSLONG.DEG,OBSLONG.MIN,OBSLONG.SEC
    OBSLONG.RAD=DTR*(OBSLONG.DEG+OBSLONG.MIN/60D0+OBSLONG.SEC/3600D0)
    OBSLONG$=STR$(OBSLONG.DEG)+ " degrees"+STR$(OBSLONG.MIN)+" minutes"+STR$(OBSLONG.SEC)+" seconds"
    PRINT
    PRINT "Time zone ( 0 - 23 )"
    PRINT "( For example, Eastern Standard Time (EST) is time zone 5 )"
    INPUT ZONE%
    PRINT
    PRINT "Daylight Savings Time ( y = yes, n = no )"
    INPUT DST$
    IF INSTR("yY",DST$) THEN
       DST%=1
    ELSE
       DST%=0
    END IF
    JD0=FNJDATE0(MONTH%,DAY%,YEAR%)
    GMT.TIME=FNGMT(LCT.HR,LCT.MIN,LCT.SEC,ZONE%,DST%)
    JDATE=JD0+GMT.TIME/24D0
    T2=(JD0-2451545D0)/36525D0
    LST=FNDEMOD(1.75336856D0+628.331971D0*T2+6.7707D-06*T2^2-OBSLONG.RAD+WE*GMT.TIME)
    CALL CONVERT(LST*XER,LST.HR,LST.MIN,LST.SEC)
    LST$=STR$(LST.HR)+" hours"+STR$(LST.MIN)+" minutes"+STR$(LST.SEC)+" seconds"

END SUB

'********************************************************************

SUB CONVERT(DEG,HR,MIN,SEC) STATIC

    ' convert angular time to hms subroutine

    HR=INT(DEG)
    C=60D0*(DEG-HR)
    MIN=INT(C)
    SEC=INT(60D0*(C-MIN)+.5D0)
    IF SEC>=60D0 THEN
       MIN=MIN+1D0
       SEC=SEC-60D0
    END IF
    IF MIN>=60D0 THEN
       HR=HR+1D0
       MIN=MIN-60D0
    END IF
    IF HR>=24D0 THEN HR=HR-24D0

END SUB

'********************************************************************

SUB GDATE.FROM.JDATE STATIC

    ' Gregorian Date from Julian Date subroutine

    DST%=0
    ZONE%=0

    CLS
    PRINT
    PRINT
    PRINT "Julian Date"
    INPUT JDATE
    Z=INT(JDATE+.5D0)
    F=JDATE+.5D0-Z
    IF Z<2299161D0 THEN
       A=Z
    ELSE
       A=INT((Z-1867216.25D0)/36524.25D0)
       A=Z+A-INT(A/4)+1D0
    END IF
    B=A+1524D0
    C=INT((B-122.1D0)/365.25D0)
    D=INT(365.25D0*C)
    E=INT((B-D)/30.6001D0)
    DAY%=B-D-INT(30.6001D0*E)
    IF E<13.5D0 THEN
       MONTH%=E-1D0
    ELSE
       MONTH%=E-13D0
    END IF
    IF MONTH%>2.5D0 THEN
       YEAR%=C-4716D0
    ELSE
       YEAR%=C-4715D0
    END IF

    CDATE$=MONTH$(MONTH%)+STR$(DAY%)+","+STR$(YEAR%)

    CALL CONVERT(24D0*F,LCT.HR,LCT.MIN,LCT.SEC)
    LCT$=STR$(LCT.HR)+" hours"+STR$(LCT.MIN)+" minutes"+STR$(LCT.SEC)+" seconds"

END SUB

'********************************************************************

SUB DISPLAY.DATA STATIC

    ' display data subroutine

    CLS
    PRINT
    PRINT TAB(30);"Program SIDEREAL"
    PRINT
    PRINT
    PRINT TAB(5);"Calendar date";TAB(62-LEN(CDATE$));CDATE$
    PRINT
    PRINT TAB(5);"Julian Date";
    LOCATE ,47
    PRINT USING "########.####";JDATE
    PRINT
    PRINT TAB(5);"Local civil time";TAB(70-LEN(LCT$));LCT$

    IF CHOICE%=3 OR CHOICE%=4 THEN
       PRINT
       PRINT TAB(5);"Local sidereal time";TAB(70-LEN(LST$));LST$
       PRINT
       PRINT TAB(5);"Observer west longitude";TAB(70-LEN(OBSLONG$));OBSLONG$
    END IF

    PRINT
    PRINT TAB(5);"Time Zone";TAB(50);ZONE%
    PRINT

    IF DST%=1 THEN
       DST$="Yes"
    ELSE
       DST$="No"
    END IF

    PRINT TAB(5);"Daylight Savings Time";TAB(51);DST$
    PRINT
    CALL KEYCHECK

END SUB

'********************************************************************

SUB SELECTION.MENU STATIC

    ' user selection menu subroutine

    CLS
    PRINT
    PRINT
    PRINT TAB(30);"SIDEREAL Menu"
    PRINT
    PRINT
    PRINT TAB(15);"< 1 > Julian Date from calendar date"
    PRINT
    PRINT TAB(15);"< 2 > Calendar date from Julian Date"
    PRINT
    PRINT TAB(15);"< 3 > Local sidereal time from local civil time"
    PRINT
    PRINT TAB(15);"< 4 > Local civil time from local sidereal time"
    PRINT
    PRINT
    PRINT "Selection ( 1, 2, 3 or 4 )"
    INPUT CHOICE%

END SUB

'********************************************************************

SUB INTRODUCTION STATIC

    ' program introduction subroutine

    CLS
    PRINT
    PRINT TAB(10);"SIDEREAL is an interactive QuickBASIC program which can"
    PRINT TAB(10);"help us learn about time. We can explore the relationship"
    PRINT TAB(10);"between solar or civil time and sidereal time as well as"
    PRINT TAB(10);"the 'Julian Date' and calendar dates."
    PRINT
    PRINT TAB(10);"The Julian Date is the number of days that have passed"
    PRINT TAB(10);"since noon on January 1, 4713 B.C. It is an 'elapsed time'"
    PRINT TAB(10);"benchmark which is used in astronomy to predict the move-"
    PRINT TAB(10);"ment of celestial objects. The Julian Date also has a"
    PRINT TAB(10);"direct relationship with our calendar dates. For example,"
    PRINT TAB(10);"the number of days between two calendar dates is simply"
    PRINT TAB(10);"the difference between their Julian Dates."
    PRINT
    PRINT TAB(10);"The two most widely used calendars are the Julian and"
    PRINT TAB(10);"Gregorian calendars. The Julian calendar was used until"
    PRINT TAB(10);"October 4, 1582 and the Gregorian calendar (due to Pope
    PRINT TAB(10);"Gregory) went into effect on October 15, 1582."
    CALL KEYCHECK

    CLS
    PRINT
    PRINT TAB(10);"Solar or civil time is time measured relative to the sun"
    PRINT TAB(10);"while sidereal time is measured with respect to the stars."
    PRINT TAB(10);"Everyone and every star has a sidereal time. The sidereal"
    PRINT TAB(10);"time of a star or planet is called 'right ascension'. When"
    PRINT TAB(10);"your local sidereal time is equal to the right ascension"
    PRINT TAB(10);"of a celestial object, that object is aligned with your"
    PRINT TAB(10);"longitude position on the earth. This event is called a"
    PRINT TAB(10);"'meridian crossing'."
    PRINT
    PRINT TAB(10);"In this program both civil and sidereal time are input and"
    PRINT TAB(10);"output in hours, minutes and seconds. The calendar date is"
    PRINT TAB(10);"also input in numerical format. For example, May 1, 1984"
    PRINT TAB(10);"would be input as '5,1,1984'. Please note that B.C. dates"
    PRINT TAB(10);"are negative and A.D. dates are positive. Also, the first"
    PRINT TAB(10);"B.C. year is 0. When your longitude is requested, you"
    PRINT TAB(10);"should input this in degrees and minutes. This number is"
    PRINT TAB(10);"your west longitude on the earth."
    CALL KEYCHECK

    CLS
    PRINT
    PRINT TAB(10);"West longitude equals 360 - east longitude. For example,"
    PRINT TAB(10);"if you were at 85 degrees and 30 seconds east longitude,"
    PRINT TAB(10);"input '274,30' when prompted. Your time zone is an integer"
    PRINT TAB(10);"number between 0 and 23 and depends upon your location on"
    PRINT TAB(10);"the earth. For example, Eastern Standard Time is time zone"
    PRINT TAB(10);"number 5. You should also indicate if Daylight Savings"
    PRINT TAB(10);"Time is in effect at your location."
    CALL KEYCHECK

END SUB

'********************************************************************

SUB KEYCHECK STATIC

    ' check user response subroutine

    PRINT
    PRINT
    PRINT TAB(25);"< press any key to continue >"

    A$=""
    WHILE A$=""
      A$=INKEY$
    WEND

END SUB

