' PROGRAM "ROCKET1"

' COPYRIGHT (C) 1982 BY DAVID EAGLE

' PUBLIC DOMAIN FOR IBM-PC ON AUGUST 19, 1986

' IBM-PC  << QUICKBASIC COMPILER VERSION 3.0 >>

' DETERMINES FLIGHT PERFORMANCE OF MODEL ROCKETS

' ALTITUDE AT BURNOUT, METERS
' VELOCITY AT BURNOUT, METERS PER SECOND
' COAST TIME AND TOTAL FLIGHT TIME, SECONDS
' MAXIMUM ALTITUDE, METERS

DEFDBL A-Z

DEF FNA(X)=(1D0-2.2556913D-5*X)^4.256116D0

PI=3.14159265D0
GRAVITY=9.80665D0
RHOSL=1.22557D0

CLS
PRINT
PRINT "Program ROCKET1"
PRINT "(C) Copyright 1982 by David Eagle"
PRINT
PRINT "Microsoft QuickBASIC Compiler"
PRINT "(C) Copyright Microsoft Corp. 1982-1987"

PRINT
PRINT TAB(10);"< press any key to continue >"
A$=""
WHILE A$=""
  A$=INKEY$
WEND

CLS
PRINT
PRINT TAB(32);"Program ROCKET1"
SITE:
PRINT
PRINT
PRINT "Launch site altitude ( meters )"
INPUT ALTSITE
PRINT
PRINT "Launch site temperature ( degrees Fahrenheit )"
INPUT TEMPSITE
ENGINE:
PRINT
PRINT
PRINT "Thrust duration ( seconds )"
INPUT TDURATION
PRINT
PRINT "Total impulse ( newton-seconds )"
INPUT IMPULSE
MASS:
PRINT
PRINT
PRINT "Initial mass ( grams )"
INPUT MASSI
PRINT
PRINT "Propellant mass ( grams )"
INPUT MPROP
PRINT
PRINT
PRINT "Frontal diameter ( millimeters )"
INPUT FD
PRINT
PRINT "Drag coefficient"
INPUT CD

' CONVERT MASS TO KILOGRAMS AND DIAMETER TO SQUARE METERS

MASSI=.001D0*MASSI
MPROP=.001D0*MPROP
FD=PI*FD^2/4D6

' COMPENSATE FOR LAUNCH SITE ALTITUDE AND TEMPERATURE

RHO=RHOSL*FNA(ALTSITE)/(1D0+(TEMPSITE-59D0)/518.67D0)

' DETERMINE ALTITUDE PERFORMANCE

THRUST=IMPULSE/TDURATION
MASS=(MASSI-.5D0*MPROP)
K2=.5D0*RHO*FD*CD
WEIGHT=MASS*GRAVITY

B=TDURATION*SQR(K2*(THRUST-WEIGHT))/MASS
C=EXP(B)
D=EXP(-B)
E=.5D0*(C+D)
F=(C-D)/(C+D)

' BURNOUT CONDITIONS

ALTBO=(MASS/K2)*LOG(E)
VELBO=F*SQR((THRUST-WEIGHT)/K2)
MASSBO=MASSI-MPROP
WEIGHTBO=MASSBO*GRAVITY

' COAST CONDITIONS

TCOAST=SQR(MASSBO/(K2*GRAVITY))*ATN(VELBO*SQR(K2/WEIGHTBO))
ALTCOAST=(MASSBO/(2D0*K2))*LOG(K2*VELBO*VELBO/WEIGHTBO+1D0)

' FLIGHT TIME AND APOGEE ALTITUDE

TFLIGHT=TDURATION+TCOAST
ALTMAX=ALTBO+ALTCOAST

' PRINT RESULTS

CLS
PRINT
PRINT TAB(32);"Program ROCKET1"
PRINT
PRINT
PRINT TAB(5);"Burnout altitude   ( meters )";
PRINT USING "######.####";TAB(55);ALTBO
PRINT
PRINT TAB(5);"Burnout velocity   ( meters per second )";
PRINT USING "######.####";TAB(55);VELBO
PRINT
PRINT TAB(5);"Burnout mass       ( grams )";
PRINT USING "######.####";TAB(55);1000D0*MASSBO
PRINT
PRINT
PRINT TAB(5);"Coast time         ( seconds )";
PRINT USING "######.####";TAB(55);TCOAST
PRINT
PRINT TAB(5);"Total flight time  ( seconds )";
PRINT USING "######.####";TAB(55);TFLIGHT
PRINT
PRINT
PRINT TAB(5);"Maximum altitude   ( meters )";
PRINT USING "######.####";TAB(55);ALTMAX
PRINT
PRINT
PRINT TAB(5);"Average thrust     ( newtons )";
PRINT USING "######.####";TAB(55);THRUST

PRINT
PRINT
PRINT TAB(25);"< press any key to continue >"
A$=""
WHILE A$=""
  A$=INKEY$
WEND

' REQUEST ANOTHER SELECTION

CLS
PRINT
PRINT
PRINT "Another selection ( y = yes, n = no )"
INPUT SELECTION$
IF INSTR("nN",SELECTION$) THEN END
PRINT
PRINT "Another launch site ( y = yes, n = no )"
INPUT SELECTION$
IF INSTR("yY",SELECTION$) THEN GOTO SITE
PRINT
PRINT "Another rocket engine ( y = yes, n = no )"
INPUT SELECTION$
IF INSTR("yY",SELECTION$) THEN GOTO ENGINE
PRINT
PRINT "Different mass or drag ( y = yes, n = no )"
INPUT SELECTION$
IF INSTR("yY",SELECTION$) THEN GOTO MASS

END
