' PROGRAM "GLIDER"

' COPYRIGHT (C) 1982 BY DAVID EAGLE

' PUBLIC DOMAIN FOR IBM-PC ON AUGUST 20, 1986

' IBM-PC  << QUICKBASIC COMPILER VERSION 3.0 >>

' DETERMINES MAXIMUM RANGE AND MAXIMUM ENDURANCE
' FLIGHT PERFORMANCE OF GLIDERS, SAILPLANES, ETC.

' GLIDE SPEED, METERS PER SECOND
' GLIDE ANGLE, DEGREES
' HORIZONTAL RANGE, METERS
' RATE-OF-DESCENT, METERS PER MINUTE
' LIFT-TO-DRAG RATIO, NON-DIMENSIONAL

'*********************************************************

DEFDBL A-Z

DEF FNA(X)=(1D0-2.2556913D-5*X)^4.256116D0

CONST PI=3.14159265D0
CONST RHOSL=1.22557D0
CONST GRAVITY=9.80665D0
CONST RTD=180D0/PI

CLS
PRINT
PRINT
PRINT "Program GLIDER"
PRINT "(C) Copyright 1982 by David Eagle"
PRINT
PRINT "Microsoft QuickBASIC Compiler"
PRINT "(C) Copyright Microsoft Corp. 1982-1987"
PRINT
CALL KEYCHECK

CLS
PRINT
PRINT
INPUT "Introduction ( y = yes, n = no ) ";A$
IF INSTR("yY",A$) THEN CALL INTRO

DO
   CLS
   PRINT
   PRINT TAB(33);"Program GLIDER"
   PRINT
   PRINT
   PRINT "Launch site altitude ( meters )"
   INPUT ALTSITE
   PRINT
   PRINT "Launch site temperature ( degrees F )"
   INPUT TEMPSITE

   ' DETERMINE LAUNCH SITE AMBIENT DENSITY

   RHOSITE=RHOSL*FNA(ALTSITE)/(1D0+(TEMPSITE-59D0)/518.67D0)

   ' REQUEST USER INPUTS

   PRINT
   PRINT "Flight altitude ( meters )"
   INPUT ALTITUDE
   PRINT
   PRINT "Wingspan ( centimeters )"
   INPUT WINGSPAN
   WINGSPAN=.01D0*WINGSPAN
   PRINT
   PRINT "Wing area ( square centimeters )"
   INPUT WINGAREA
   WINGAREA=.0001D0*WINGAREA
   PRINT
   PRINT "Mass ( grams )"
   INPUT MASS
   MASS=.001D0*MASS
   PRINT
   PRINT "Zero-lift drag coefficient ( non-dimensional )"
   INPUT CD0
   PRINT
   PRINT "Efficieny factor ( non-dimensional )"
   INPUT EFACTOR

   ' COMPUTE ASPECT RATIO, EFFICIENCY PARAMETER, DENSITY AND WEIGHT

   ASPECT=WINGSPAN*WINGSPAN/WINGAREA
   K1=PI*ASPECT*EFACTOR
   RHO=RHOSITE*FNA(ALTITUDE)
   WEIGHT=GRAVITY*MASS

   ' DETERMINE MAXIMUM RANGE FLIGHT CONDITIONS

   LIFT1=SQR(CD0*K1)
   DRAG1=2D0*CD0
   GANGLE1=ATN(DRAG1/LIFT1)
   GSPEED1=SQR(2D0*WEIGHT*COS(GANGLE1)/(RHO*WINGAREA*LIFT1))
   ROD1=GSPEED1*SIN(GANGLE1)
   RANGE1=ALTITUDE/TAN(GANGLE1)

   ' DETERMINE MAXIMUM ENDURANCE FLIGHT CONDITIONS

   LIFT2=SQR(3D0*K1*CD0)
   DRAG2=4D0*CD0
   GANGLE2=ATN(DRAG2/LIFT2)
   GSPEED2=SQR(2D0*WEIGHT*COS(GANGLE2)/(RHO*WINGAREA*LIFT2))
   ROD2=GSPEED2*SIN(GANGLE2)
   RANGE2=ALTITUDE/TAN(GANGLE2)

   ' PRINT RESULTS

   CLS
   PRINT
   PRINT
   PRINT TAB(25);"MAXIMUM RANGE GLIDE CONDITIONS"
   PRINT
   PRINT
   CALL PDATA(GANGLE1,GSPEED1,ROD1,RANGE1,LIFT1,DRAG1)

   CLS
   PRINT
   PRINT
   PRINT TAB(23);"MAXIMUM ENDURANCE GLIDE CONDITIONS"
   PRINT
   PRINT
   CALL PDATA(GANGLE2,GSPEED2,ROD2,RANGE2,LIFT2,DRAG2)

   CLS
   PRINT
   PRINT
   INPUT "Another selection ( y = yes, n = no ) ";A$
   IF INSTR("nN",A$) THEN EXIT DO
LOOP

END

'*********************************************************

SUB PDATA(GANGLE,GSPEED,ROD,RANGE,LIFT,DRAG) STATIC

    ' PRINT SUBROUTINE

    FORMAT$="#######.####"

    PRINT
    PRINT TAB(5);"Glide speed          ( meters per second )";
    PRINT USING FORMAT$;TAB(55);GSPEED
    PRINT
    PRINT TAB(5);"Glide angle          ( degrees )";
    PRINT USING FORMAT$;TAB(55);GANGLE*RTD
    PRINT
    PRINT
    PRINT TAB(5);"Horizontal range     ( meters )";
    PRINT USING FORMAT$;TAB(55);RANGE
    PRINT
    PRINT TAB(5);"Rate-of-descent      ( meters per minutes )";
    PRINT USING FORMAT$;TAB(55);60D0*ROD
    PRINT
    PRINT
    PRINT TAB(5);"Lift-to-Drag ratio   ( non-dimensional )";
    PRINT USING FORMAT$;TAB(55);LIFT/DRAG
    PRINT
    CALL KEYCHECK

END SUB

'*********************************************************

SUB INTRO STATIC

    ' DOCUMENTATION SUBROUTINE

    CLS
    PRINT
    PRINT
    PRINT "     PROGRAM 'GLIDER' IS AN INTERACTIVE BASIC COMPUTER PROGRAM WHICH CAN BE USED";
    PRINT "TO DETERMINE BOTH THE MAXIMUM RANGE AND MAXIMUM ENDURANCE FLIGHT CONDITIONS FOR";
    PRINT "MODEL ROCKET BOOST GLIDERS. THESE ARE THE FLIGHT CONDITIONS WHEN THE GLIDER";
    PRINT "WILL FLY THE FARTHEST OR STAY IN THE AIR THE LONGEST TIME. THE 'GLIDER' SOFTWARE";
    PRINT "COMPENSATES FOR THE VARIATION IN DENSITY AT THE INITIAL GLIDE ALTITUDE AND 'NON-";
    PRINT "STANDARD' FLYING CONDITIONS SUCH AS HOT OR COLD DAYS OR FLYING SITES WHICH ARE";
    PRINT "NOT AT SEA LEVEL. THESE UNIQUE FEATURES WILL PROVIDE THE USER WITH AN ACCURATE";
    PRINT "PREDICTION OF THE MOTION OF GLIDERS."
    PRINT
    PRINT "     PROGRAM 'GLIDER' WILL PROMPT THE USER FOR SEVERAL INPUTS NECESSARY FOR THE";
    PRINT "SOFTWARE TO WORK PROPERLY. THIS IS A DESCRIPTION OF THESE REQUESTS AND A SHORT";
    PRINT "DISCUSSION OF HOW THE USER SHOULD RESPOND.";
    CALL KEYCHECK
    CLS
    PRINT
    PRINT "     LAUNCH SITE ALTITUDE ( METERS )"
    PRINT
    PRINT "THE USER RESPONSE SHOULD BE THE ALTITUDE AT THE FLYING SITE IN METERS. FLYING";
    PRINT "SITES ABOVE SEA LEVEL ARE POSITIVE AND THOSE BELOW SEA LEVEL ARE NEGATIVE."
    PRINT
    PRINT "     LAUNCH SITE TEMPERATURE ( DEGREES F )"
    PRINT
    PRINT "THE RESPONSE TO THIS REQUEST SHOULD BE THE TEMPERATURE AT THE FLYING SITE IN";
    PRINT "DEGREES FAHRENHEIT."
    PRINT
    PRINT "     FLIGHT ALTITUDE ( METERS )"
    PRINT
    PRINT "AT THIS POINT THE USER SHOULD INPUT THE INITIAL FLIGHT ALTITUDE OF THE GLIDER IN";
    PRINT "METERS. THIS IS THE ALTITUDE ABOVE THE FLYING SITE WHEN THE GLIDE BEGINS."
    PRINT
    PRINT "     WINGSPAN ( CENTIMETERS )"
    PRINT
    PRINT "THE USER SHOULD RESPOND WITH THE WINGSPAN OF THE GLIDER IN CENTIMETERS. THIS";
    PRINT "IS THE DISTANCE FROM WINGTIP TO WINGTIP."
    CALL KEYCHECK
    CLS
    PRINT
    PRINT "     WING AREA ( SQUARE CENTIMETERS )"
    PRINT
    PRINT "THE USER SHOULD INPUT THE WING AREA OF THE GLIDER IN SQUARE CENTIMETERS."
    PRINT
    PRINT "     MASS ( GRAMS )"
    PRINT
    PRINT "THE RESPONSE TO THIS REQUEST SHOULD BE THE MASS OF THE GLIDER IN GRAMS."
    PRINT
    PRINT "     ZERO-LIFT DRAG COEFFICIENT ( NON-DIMENSIONAL )"
    PRINT
    PRINT "THE USER SHOULD INPUT THE 'NO-LIFT' DRAG COEFFICIENT. THIS IS THE PLANFORM DRAG";
    PRINT "COEFFICIENT WHICH IS USUALLY DETERMINED FROM WIND TUNNEL TESTS. TYPICAL VALUES";
    PRINT "RANGE FROM .01 TO .05."
    PRINT
    PRINT "     EFFICIENCY FACTOR ( NON-DIMENSIONAL )"
    PRINT
    PRINT "THIS IS A NON-DIMENSIONAL NUMBER WHICH MUST BE DETERMINED FROM WIND TUNNEL TEST";
    PRINT "OR ESTIMATED NUMERICALLY. TYPICAL VALUES RANGE FROM .6 TO .9."
    PRINT
    CALL KEYCHECK
    CLS
    PRINT
    PRINT
    PRINT "     AFTER THE PROGRAM HAS RUN, IT WILL ASK THE USER FOR ANOTHER SELECTION. THE";
    PRINT "USER SHOULD RESPOND WITH 'Y' IF HE OR SHE DESIRES THE SELECTION OR 'N' IF NOT."
    PRINT
    PRINT "     ANOTHER SELECTION ( Y = YES, N = NO ) ?"
    PRINT
    PRINT "THE USER SHOULD RESPOND WITH 'N' TO EXIT THE PROGRAM."
    PRINT
    CALL KEYCHECK
    CLS
    PRINT
    PRINT "     PROGRAM 'GLIDER' OUTPUTS DATA ABOUT BOTH THE MAXIMUM RANGE AND MAXIMUM";
    PRINT "ENDURANCE FLIGHT CONDITIONS OF THE BOOST GLIDER. THIS INFORMATION INCLUDES THE";
    PRINT "GLIDE SPEED AND ANGLE, THE HORIZONTAL RANGE AND RATE-OF-DESCENT AND THE GLIDER";
    PRINT "LIFT-TO-DRAG RATIO. THE GLIDE SPEED IS PRINTED IN METERS PER SECOND AND THE";
    PRINT "RATE-OF-DESCENT IS IN METERS PER MINUTE. THE HORIZONTAL RANGE IS GIVEN IN METERS";
    PRINT "AND THE GLIDE ANGLE IS IN DEGREES. THE LIFT-TO-DRAG RATIO IS NON-DIMENSIONAL."
    PRINT
    PRINT "     FOR USERS WHO MAY WANT TO SEE OTHER VARIABLES COMPUTED BY THE SOFTWARE,";
    PRINT "'RHOSITE' IS THE AMBIENT DENSITY AT THE FLYING SITE AND 'RHO' IS THE DENSITY";
    PRINT "AT THE INITIAL FLIGHT ALTITUDE. THE ASPECT RATIO OF THE GLIDER IS COMPUTED IN";
    PRINT "THE VARIABLE 'ASPECT'.";
    CALL KEYCHECK

END SUB

'*********************************************************

SUB KEYCHECK STATIC

    ' CHECK USER RESPONSE SUBROUTINE

    PRINT
    PRINT
    PRINT TAB(25);"< press any key to continue >"

    A$=""
    WHILE A$=""
      A$=INKEY$
    WEND

END SUB
