' PROGRAM "ATMOS"

' COPYRIGHT (C) 1982 BY DAVID EAGLE

' PUBLIC DOMAIN FOR IBM-PC ON NOVEMBER 21, 1986

' IBM-PC  << MICROSOFT QUICKBASIC COMPILER VERSION 3.0 >>

' DETERMINES PROPERTIES OF THE STANDARD ATMOSPHERE

' TEMPERATURE, DEGREES FAHRENHEIT AND CELSIUS
' PRESSURE, NEWTONS PER SQUARE METER
' DENSITY, KILOGRAMS PER CUBIC METER

'**********************************************************

DEFDBL A-Z

CONST C0=288.15D0
CONST F0=518.67D0
CONST ALTITUDE0=10999.9272D0
CONST PRESSURE0=101325.016D0
CONST DENSITY0=1.22557D0

DO
   CLS
   PRINT
   PRINT
   PRINT "Program ATMOS"
   PRINT "(C) Copyright 1982 by David Eagle"
   PRINT
   PRINT "Microsoft QuickBASIC Compiler"
   PRINT "(C) Copyright Microsoft Corp. 1982-1987"
   PRINT
   CALL KEYCHECK

   CLS
   PRINT
   PRINT
   PRINT
   PRINT TAB(32);"Program ATMOS"
   PRINT
   PRINT
   PRINT "Initial Altitude ( meters )"
   INPUT IALT
   PRINT
   PRINT
   PRINT "Final Altitude ( meters )"
   INPUT FALT
   PRINT
   PRINT
   PRINT "Altitude increment ( meters )"
   INPUT DALT

   J%=INT(IALT/DALT+.5D0)
   K%=INT(FALT/DALT+.5D0)

   CLS
   PRINT
   PRINT TAB(5);"ALTITUDE";TAB(25);"PRESSURE";TAB(45);"DENSITY";TAB(65);"TEMPERATURE";
   PRINT TAB(4);"( meters )";TAB(24);"( nt/sq m )";TAB(44);"( kg/m^3 )";TAB(64);"( degrees F, C )";
   PRINT
   PRINT

   FOR I%=J% TO K%
       PNUM%=PNUM%+1
       ALTITUDE=I%*DALT

       IF ALTITUDE < ALTITUDE0 THEN
          RHO2=1D0-2.2556913D-5*ALTITUDE
          RHO1=RHO2^5.256116D0
       ELSE
          RHO1=.2233618D0*EXP(1.7345477D0-1.576872D-4*ALTITUDE)
          RHO2=.7519D0
       END IF

       DRATIO=RHO1/RHO2
       PRESSURE=RHO1*PRESSURE0
       DENSITY=DRATIO*DENSITY0

       TEMPF=RHO2*F0-459.67D0
       TEMPC=RHO2*C0-273.15D0

       ' PRINT DATA

       PRINT
       PRINT USING "######.##";TAB(2);ALTITUDE;TAB(25);PRESSURE;
       PRINT USING "###.#######";TAB(42);DENSITY;
       PRINT USING "###.##";TAB(64);TEMPF;TAB(73);TEMPC

       IF PNUM%=7 THEN
          CALL KEYCHECK
          CLS
          PRINT
          PNUM%=0
       END IF

   NEXT I%

   IF PNUM%>0 AND PNUM%<7 THEN CALL KEYCHECK

   CLS
   PRINT
   PRINT
   PRINT "Another selection ( y = yes, n = no )"
   INPUT SELECTION$
LOOP UNTIL INSTR("nN",SELECTION$)

END

'**********************************************************

SUB KEYCHECK STATIC

    ' CHECK USER RESPONSE SUBROUTINE

    PRINT
    PRINT
    PRINT
    PRINT TAB(25);"< press any key to continue >"

    A$=""
    WHILE A$=""
      A$=INKEY$
    WEND

END SUB

