/* Most of these variables are used only in calculations
 * for the outer planets:
 */
double sinV;
double cosV;
double sin2V;
double cos2V;
double sinW;
double sinze;
double sin2ze;
double sin3ze;
double sin4ze;
double cosze;
double cos2ze;
double cos3ze;
double cos4ze;
double sinQ;
double sin2Q;
double sin3Q;
double cosQ;
double cos2Q;
double cos3Q;
double sin5ze;
double cos5ze;
double sin1H;
double sin2H;
double cos1H;
double cos2H;
double sinth;
double sin2th;
double costh;
double cos2th;
double M1;
double M2;
double M4;
double M5;
double M6;
double M7;
double M8;
double nu;
double P;
double Q;
double S;
double V;
double W;
double ze;
double psi;
double H;
double G;
double eta;
double th;
double f;

/* mean anomaly of the earth
 */
double M;
extern double M;

/* reusable time variable,
 * centuries since 1900.0
 */
double T;
extern double T;


#include "planet.h"
#include "kep.h"


/* This subroutine calculates mean anomalies of the planets.
 * The mean anomalies of earth, uranus and neptune are in
 * oearth.c, ouranus.c, and oneptune.c.
 */
int manoms(J)
double J;
{

T = (J - 2415020.0)/36525.0;

#if BandS
/* mean anomaly of the earth (and sun) */
f = (( -0.0000033*T - 0.000150)*T + 35999.04975)*T + 358.47583;
M = mod360(f);
#endif

/* mean anomaly of Mercury */
M1 = (0.000007*T + 149472.51529)*T + 102.27938;
M1 = mod360(M1);
/* Venus */
M2 = (0.001286*T + 58517.80387)*T + 212.60322;
M2 = mod360(M2);
/* Mars */
M4 = (0.000181*T + 19139.85475)*T + 319.51913;
M4 = mod360(M4);
/* Jupiter */
M5 = (-0.000722*T + 3034.69202)*T + 225.32833;
M5 = mod360(M5);
/* Saturn */
M6 = (-0.000502*T + 1221.55147)*T + 175.46622;
M6 = mod360(M6);
return(0);
}

