/*
 *************
 * DISTRIBUTION NOTICE  July 30 1985
 * A Revised Edition of WM, by Matt Lennon and Tom Truscott,
 *		Research Triangle Institute, (919) 541-7005.
 * Based on the original by Robert Jacob (decvax!nrl-css!jacob),
 *		Naval Research Laboratory, (202) 767-3365.
 * No claims or warranties of any sort are made for this distribution.
 * General permission is granted to copy, but not for profit,
 * any of this distribution, provided that this notice
 * is always included in the copies.
 *************
 */
/*
 * Code for rearranging window display order
 */

#include "wm.h"


/*
 * Make window 'w' the new top window.
 * Insert 'w' into window list (keeps track
 * of redraw order).
 * 'topw' (pointer to the top window) is set to 'w'.
 * Recompute obscured window status.
 */
WListAdd(w)

register int w;
{
    register int wt;	/* temporary window pointer */

     /* Add w to empty list.
      */
    if (botw < 0)
	botw=w;

     /* Add w to top of nonempty list.
      */
    else
    {
	for (wt=botw; win[wt].next>=0; wt=win[wt].next)
	    ;
	win[wt].next=w;
    }


    win[w].next = -1;
    topw = w;

    /* Recompute obscured window status */
    WObscure();
}

/*
 * Delete window 'w'.
 * Remove it from window list.
 * Recompute obscured windows.
 */
WListDelete(w)

register int w;
{
    register int wt;	/* temporary window pointer */

    if ( ! iswindow(w))
	return;

     /* Don't read from this window any more.
      */
    DisablePty(w);

     /* Delete w from list.
      */
    if (botw==w)
	botw=win[botw].next;
    else
    {
	for (wt=botw; wt>=0; wt=win[wt].next)
	    if (win[wt].next==w) break;
	if (wt>=0)
	    win[wt].next=win[win[wt].next].next;
    }

     /* Find new topw.
      */
    wt=botw;
    while (wt>=0 && win[wt].next>=0)
	wt=win[wt].next;
    topw=wt;

    /* Recompute obscured window info */
    WObscure();
}

/*
 * Recompute obscured ('blocked') and 'covers' information
 * Enable/Disable ptys appropriately.
 */
WObscure()
{
    register int w, wt, i;

    for (w = botw; w >= 0; w = win[w].next) {
	EnablePty(w);
	win[w].flags &= ~BLOCKED;
	for (i = 0; i < MAXWINDOWS; i++)
	    win[w].covers[i] = FALSE;
	for (wt = botw; wt != w; wt = win[wt].next) {
	    if (!overlap(w, wt))
		continue;
	    win[w].covers[wt] = TRUE;
	    win[wt].flags |= BLOCKED;
	    /* We could disable the obscured window's pty at this point,
	     * but we'll wait and do it in 'readptys()'.
	     */
	    /* (we should probably disable it now if it was previously) */
	}
    }
}

/* Note: the arithmetic 'bottom' is actual the visual 'top'!
 * Also, RIGHT and TOP are the index of the column (row) just past
 * the index of the window's actual right (top).
 */
#define BOTTOM(wp)	(wbegy(wp))
#define	TOP(wp)		(BOTTOM(wp)+wlines(wp))
#define LEFT(wp)	(wbegx(wp))
#define	RIGHT(wp)	(LEFT(wp)+wcols(wp))

/*
 * Determine if two windows overlap.
 * Windows must have at least a row (column) separating them
 * to permit the border lines to be drawn.
 */
overlap(w1, w2)

int w1, w2;
{
    register WINDOW *wp1, *wp2;

    wp1 = win[w1].wptr;
    wp2 = win[w2].wptr;
    return(LEFT(wp1)   <= RIGHT(wp2)
	&& LEFT(wp2)   <= RIGHT(wp1)
	&& BOTTOM(wp1) <= TOP(wp2)
	&& BOTTOM(wp2) <= TOP(wp1));
}

/*
 * Returns 1 if a window (or its border) above w cover point (y,x),
 * otherwise returns 0.
 */
covers(w, y, x)
int w;
register int y, x;
{
    register int wt;
    register WINDOW *wp;

    for (wt = w; (wt = win[wt].next) >= 0;) {
	wp = win[wt].wptr;
	if (LEFT(wp)	<= x+1
	 && x		<= RIGHT(wp)
	 && BOTTOM(wp)	<= y+1
	 && y		<= TOP(wp))
	    return(1);
    }
    return(0);
}
