/*
 *************
 * DISTRIBUTION NOTICE  July 30 1985
 * A Revised Edition of WM, by Matt Lennon and Tom Truscott,
 *		Research Triangle Institute, (919) 541-7005.
 * Based on the original by Robert Jacob (decvax!nrl-css!jacob),
 *		Naval Research Laboratory, (202) 767-3365.
 * No claims or warranties of any sort are made for this distribution.
 * General permission is granted to copy, but not for profit,
 * any of this distribution, provided that this notice
 * is always included in the copies.
 *************
 */
#include "wm.h"


/*
 * print a command summary over the top of the screen, then redraw
 */
helpmsg()
{
printf("Code    Command  Description\r\n");
printf("----    -------  -----------\r\n");
printf("%d..%d    change    Change to the named window\r\n",
	MINWINDOW, MAXWINDOWS-1);
printf("d       dump      dump current window contents to a file\r\n");
printf("h or ?  help      print this help message\r\n");
printf("i       identify  identify windows\r\n");
printf("k       kill      kill a window permanently\r\n");
printf("l       last      change to last-used window\r\n");
printf("m       move      move and/or change size of current window\r\n");
printf("n       new       make a new window\r\n");
printf("p       prefix    change WM prefix character (See EXECUTE below)\r\n");
printf("q       quit      quit WM\r\n");
printf("r       redraw    redraw entire screen\r\n");
printf("s       save      save current window configuration\r\n");
printf("t       termcap   reset $TERM and $TERMCAP of current window\r\n");
printf("z       suspend   suspend WM (or spawn non-window subshell)\r\n");

printf("----------------------------------------------------------\r\n");

printf("To EXECUTE a command, type the WM prefix character (%s) then the command code.\r\n", mkprint(prefix));
printf("To ENTER the prefix character itself, type it twice.\r\n");
printf("To CANCEL a WM command before it executes, type <ESC> or <DEL>.\r\n");
printf("For FUTHER INFORMATION, consult the 'wm' manual entry.\r\n");

printf("------------------------------\r\n");

printf("Now hit any key to return to WM");
(void)fflush(stdout);
}
