*** libcurses42/refresh.c	Thu Nov 17 11:03:06 1983
--- libcurses/refresh.c	Tue Jul 30 23:16:01 1985
***************
*** 5,6
   * 5/12/83 (Berkeley) @(#)refresh.c	1.8
   */

--- 5,14 -----
   * 5/12/83 (Berkeley) @(#)refresh.c	1.8
+  *
+  * 2/28/84 Correction at UCSF:
+  * Take the terminal out of standout mode, before clear to end of line
+  * if it isn't safe to move in standout mode (termcap entry ms)
+  *
+  * 3/14/85 Corrections at RTI
+  *  Fix problems reported on Usenet.  Also, delete apparently
+  *  useless (and harmful) code if _leave has been set.
   */
***************
*** 86,87
  		curscr->_curx = lx;
  		ly -= win->_begy;

--- 94,97 -----
  		curscr->_curx = lx;
+ #ifdef	wantamess
+ 		/* rti-sel!trt: this code is completely bogus, yes? */
  		ly -= win->_begy;
***************
*** 94,95
  			win->_cury = win->_curx = 0;
  	}

--- 104,106 -----
  			win->_cury = win->_curx = 0;
+ #endif
  	}
***************
*** 118,119
  	reg int		nlsp, clsp;	/* last space in lines		*/
  

--- 129,131 -----
  	reg int		nlsp, clsp;	/* last space in lines		*/
+ 	static int glitchXN;
  
***************
*** 128,129
  	if (CE && !curwin) {
  		for (ce = &win->_y[wy][win->_maxx - 1]; *ce == ' '; ce--)

--- 140,142 -----
  	if (CE && !curwin) {
+ #ifdef slowway
  		for (ce = &win->_y[wy][win->_maxx - 1]; *ce == ' '; ce--)
***************
*** 132,133
  		nlsp = ce - win->_y[wy];
  	}

--- 145,149 -----
  		nlsp = ce - win->_y[wy];
+ #else
+ 		nlsp = -1;
+ #endif
  	}
***************
*** 139,140
  		if (*nsp != *csp) {
  			domvcur(ly, lx, y, wx + win->_begx);

--- 155,168 -----
  		if (*nsp != *csp) {
+ #ifndef wantamess
+ 			/* this is no guarantee, but seems to work */
+ 			if (glitchXN && wx && wx+win->_begx==COLS-1) {
+ 				domvcur(ly, lx, y, wx+win->_begx-1);
+ 				ly = y;
+ 				lx = wx+win->_begx-1;
+ 				glitchXN = 0;
+ 				continue;
+ 			}
+ 			glitchXN = 0;
+ #endif
+ #ifdef slowway
  			domvcur(ly, lx, y, wx + win->_begx);
***************
*** 145,147
  			lx = wx + win->_begx;
! 			while (*nsp != *csp && wx <= lch) {
  				if (ce != NULL && wx >= nlsp && *nsp == ' ') {

--- 173,212 -----
  			lx = wx + win->_begx;
! #else
! 			/* speed hacks to avoid domvcur in simple cases */
! 			clsp = wx + win->_begx; /* dirty use of clsp */
! 			if (ly == y) {
! 			    if (lx == clsp)
! 				goto at_target;
! 			    if (lx+1 == clsp && !curwin) {
! 				/* enter/exit standout mode as appropriate */
! 				if (SO && (csp[-1]&_STANDOUT) != (curscr->_flags&_STANDOUT)) {
! 					if (csp[-1] & _STANDOUT) {
! 						_puts(SO);
! 						curscr->_flags |= _STANDOUT;
! 					}
! 					else {
! 						_puts(SE);
! 						curscr->_flags &= ~_STANDOUT;
! 					}
! 				}
! 				putchar(csp[-1]&0177);
! 				lx++;
! 				goto at_target;
! 			    }
! 			    if (clsp == 0 && !(curscr->_flags&_STANDOUT)
! 			     && !NC && (!CR || CR[1] == '\0')) {
! 				if (CR)
! 				    putchar(*CR);
! 				else
! 				    putchar('\r');
! 				lx = 0;
! 				goto at_target;
! 			    }
! 			}
! 			domvcur(ly, lx, y, clsp);
! 			ly = y;
! 			lx = clsp;
! 		at_target:;
! #endif
! 			while (wx <= lch && *nsp != *csp) {
  				if (ce != NULL && wx >= nlsp && *nsp == ' ') {
***************
*** 147,148
  				if (ce != NULL && wx >= nlsp && *nsp == ' ') {
  					/*

--- 212,222 -----
  				if (ce != NULL && wx >= nlsp && *nsp == ' ') {
+ #ifndef slowway
+ 				    if (nlsp < 0) {
+ 					for (nlsp = win->_maxx-1;
+ 					    nlsp > 0 && win->_y[wy][nlsp]==' ';
+ 					    nlsp--)
+ 						;
+ 					continue; /* gotta recheck nlsp */
+ 				    }
+ #endif
  					/*
***************
*** 163,164
  # endif
  						_puts(CE);

--- 237,245 -----
  # endif
+ 						/* if we shouldn't move in standout mode, CE may cause
+ 						   problems too
+ 						*/
+ 						if (curscr->_flags & _STANDOUT && !MS) {
+ 							_puts(SE);
+ 							curscr->_flags &= ~_STANDOUT;
+ 						}
  						_puts(CE);
***************
*** 226,228
  		else if (wx < lch)
! 			while (*nsp == *csp) {
  				nsp++;

--- 307,309 -----
  		else if (wx < lch)
! 			while (wx <= lch && *nsp == *csp) {
  				nsp++;
***************
*** 239,240
  ret:
  	return OK;

--- 320,346 -----
  ret:
+ #ifndef	wantamess
+ 	/* rti-sel!trt: update cursor location on auto-wrap */
+ 	if (lx >= COLS) {
+ 		if (XN) {	/* make this case like the usual one */
+ 			if (curscr->_flags & _STANDOUT && !MS) {
+ 				_puts(SE);
+ 				curscr->_flags &= ~_STANDOUT;
+ 			}
+ 			putchar('\r');
+ 			putchar('\n');
+ 			glitchXN++;	/* next char must not be in col 80 */
+ 		}
+ 		lx = 0;
+ 		if (ly < LINES-1)
+ 			ly++;
+ 		else {
+ 			/* at this point the current screen scrolled up.
+ 			 * scroll() is strange, so we simulate it by hand.
+ 			 * Curses should probably not put anything in lower
+ 			 * right corner of screen, and thus avoid this mess */
+ 			wmove(curscr, 0, 0); wdeleteln(curscr);
+ 			wmove(curscr, ly, lx);
+ 		}
+ 	}
+ #endif
  	return OK;
