/****************************************************************************\
 * Copyright 1985 by George Nelan, Arizona State University.                *
 * All rights reserved.  Permission to use, modify, and copy these programs *
 * and documentation is granted, provided that the copy is not sold and     *
 * that this copyright and permission notice appear on all copies.          *
\****************************************************************************/

/* wty.bind: integrated version wty binder */
/* author: George Nelan */

#include "max.wty.h"

/* from msh */
extern	init_msh();
extern	abort();
extern	slave_driver();

/* from wty */
extern	init_wty();
extern	keyboard_driver();
extern	screen_driver();

typedef	struct {
	char	buf[AMAXQBUF];
	char 	*fp,*rp,*beg,*end;
}	queue;	

#define initq(q) {\
	q.fp = q.rp = q.buf;\
	q.beg = q.buf + 1;\
	q.end = q.buf + MAXQBUF - 1;\
}

#define nullq(q) (q.fp == q.buf)

#define fullq(q) (q.fp == q.rp)

int qresult;

#define insertq(q,e) {\
	qresult = 1;\
	q.rp = (q.rp == q.end ? q.beg : q.rp + 1);\
	if (fullq(q)) qresult = 0;\
	else {\
		*(q.rp) = (e);\
		if (q.fp == q.buf) q.fp = q.beg;\
	}\
} 

#define deleteq(q,ep) {\
	qresult = 1;\
	if (nullq(q)) qresult = 0;\
	else {\
		*(ep) = *q.fp;\
		if (q.fp == q.rp) q.fp = q.rp = q.buf;\
		else q.fp = (q.fp == q.end ? q.beg : q.fp + 1);\
	}\
}


static	queue	pq,mq; /* wty port, msh master queues */

/****************************************************************************/
main (argc,argv) 
int argc;
char *argv[];
{
	initq(pq);
	initq(mq);
	init_msh();
	init_wty(argc,argv);
	for (;;)
		screen_driver();
} /* main */


/****************************************************************************/
int get_master(chp)
register char *chp;
/* return > 0 if wty character ready, 
 * else return <= 0 if not ready or error.
 */
 {
	if (nullq(mq)) keyboard_driver();
	if (!nullq(mq)) {
		deleteq(mq,chp);
		return (1);
	}
	return (0);
 } /* get_master */


/****************************************************************************/
put_port(chp,len)
register char *chp;
register int len;
{
	register int i;

	for (i = 0; i < len; i++) {
		insertq(mq,*(chp + i));
		if (!qresult) abort("wty: put_port q o/v");
	}
} /* put_port */


/****************************************************************************/
int get_port(chp)
register char *chp;
/* return > 0 if msh character ready, 
 * else return <= 0 if not ready or error.
 */
 {
	if (nullq(pq)) slave_driver();
	if (!nullq(pq)) {
		deleteq(pq,chp);
		*chp &= 0177; /* make sure 7-bits */
		return (1);
	}
	return (0);
 } /* get_port */


/****************************************************************************/
put_master(chp,len)
register char *chp;
register int len;
{
	register int i;

	for (i = 0; i < len; i++) {
		insertq(pq,*(chp + i));
		if (!qresult) abort("msh: put_master q o/v");
	}
} /* put_master */


