.TH wty \*M "1 July 1985"
.SH NAME
wty \- window manager (version \*V)
.SH SYNOPSIS
.B "\*P/wty"
[ n ]
.SH DESCRIPTION
.ad b
.PP
.I Wty
provides window management capabilities allowing
interaction with multiple concurrent shells
in a simple and efficient way.
The
.B TERMCAP
database is utilized so that a windowing terminal may be emulated on
a number of different terminals.
.PP
When started, the program creates
.I n 
windows and shells (the default is 2).
Up to four windows (in this version) may be specified.
.I Wty 
divides the screen into
.I n
equally sized, individually scrollable, horizontal regions (windows). 
Each window is assigned to an individual c-shell (csh), and is known to that
shell by means of the 
.B TERM
environment variable.
Thus, most programs which use TERMCAP (including vi) may be run under
.I "wty."
.PP
Output from all shells is made immediately available to their corresponding
windows.
However, at any one time, there is only one window which receives input
from the user.
This window is the
.I "current input window,"
and may be changed at any time by the user.
Except for 
.I wty
operation  commands,
.B all
inputs are presented to the current input window's shell as if the shell were
communicating directly with the user.
.PP
Windows may have a buffer allocated for them allowing for recording of all 
input/output for the window.
Buffers are implemented as named files so that they may be edited.
Such a buffer may then be read as input to another window.
.SH OPERATION
.PP
.I Wty
accepts these commands for operation, each preceeded by <ctrl-A>
(<n> is a numeric character window label):
.nf

    <n>         - change current input window
    c<n>        - create new current input window
    cn<n>       - create (nicely)
    d<n>        - delete current input window
    dn<n>       - delete (nicely)
    f<n>        - fold current input window
    fn<n>       - fold (nicely)
    o<n>        - open another current input window
    on<n>       - open (nicely)
    bc          - create new buffer for current input window
    bd          - delete buffer for current input window
    bf          - fold buffer for current input window
    bo          - open buffer for current input window
    br<n>       - read buffer <n> into current input window
    brl<n>      - read buffer <n> literally
    r           - resize current input window
    l           - label all windows
    h           - help
    =<c>        - set command character
    <ctrl-Z>    - stop
    qy          - quit
.fi
.PP
Windows are labeled numerically from top to bottom starting at '1'.
An input of <ctrl-A> <ctrl-A> results in one <ctrl-A> being passed
to the input window's shell.
An input of an invalid command rings the terminal's bell.
.PP
The change window command causes the current input window to become 
that labeled by <n>.
.PP
The create window command creates a new window labeled by <n> and
attaches a shell to it.
The new window becomes the current input window.
All windows are cleared and resized equally \- a new "setenv TERM"
command is sent to the attached shell.
The nice form does not automatically resize other windows.
.PP
The delete window command deletes the current input window and 
detaches its shell.
The current input window becomes that labeled by <n>.
All windows are cleared and resized equally.
The nice form does not automatically resize windows.
.PP
The fold window command temporarily removes the current input window from
the display (until an open command).
The current input window becomes that labeled by <n>.
All windows are cleared and resized equally.
The nice form does not automatically resize windows.
.PP
The open window command causes a previously folded window <n> to become visible
again.
This window becomes the new current input window.
All windows are cleared and resized equally.
The nice form does not automatically resize windows.
Note: all output from a shell attached to a folded window is lost 
until it becomes open again (unless a buffer is recording).
.PP
The create buffer command allocates a named file to the current input window
so that all suceeding input/output for the window may be recorded.
The name of the file is "wty.buf.<n>" (where <n> is the label of the current
input window), unless the environment variable
.B WTYB
has been defined; in this case, the WTYB variable defines the file name prefix
and a suffix string of the form ".<n>" is generated by
.I "wty."
If the buffer file already exists, a new buffer is 
.B not
created.
.PP
The delete buffer command closes the buffer file associated with the current
input window and deletes it from the file space.
.PP
The fold buffer command temporarily inhibits the recording of input/output
data for the current input window if it has a buffer attached to it.
.PP
The open buffer command causes a previously folded buffer (for the current 
input window) to become available for recording again.
.PP
The read buffer command reads the buffer associated with window <n> (if it
exists) and transfers its contents to the current input window as input data.
Any keyboard input during the transfer will terminate the transfer.
All character strings of the form "\\r\\n" in the buffer file are transformed
to the string "\\n" (this is a nominal transformation due to implementation
considerations \- sub-shells normally echo inputted \\r's as "\\r\\n").
The read literal form of the command inhibits this transformation.
.PP
The resize command causes the current input window's 
.B TERM
value to be sent again to its shell.
It is assumed that the shell is in a state where a new
.I setenv
command can be accepted.
Indeed, this command is useful in cases where a particular shell doesn't
receive previous resizing data.
.PP
The label command causes the label of each window to appear in its upper
right corner.
This can be useful as a reminder since windows are not re-labeled after
creation or deletion.
For each window, if a buffer is allocated for it, a 'B' is displayed
immediately following the label if the buffer is open; a 'b' is displayed
if it is folded.
.PP
The help command clears the current input window then displays a summary
of commands.
.PP
The set command character command changes the current command prefix character 
to the character <c>.
The default character is <ctrl-A>.
The new character may not be the same as the start/stop flow control 
characters.
.PP
The stop command temporarily suspends
.I "wty"
and returns control to UNIX.
An 'fg' command can be given later to resume operation.
.PP
The quit (yes, do it!) command terminates execution of
.I "wty."
.SH ENVIRONMENT VARIABLES
.PP
.I Wty
assumes that the TERMCAP file you use contains definitions for a master
prototype entry.
This prototype entry, named by the environment variable
.B WTYP,
defines the capabilities of a psuedo-device which
.I wty
requires for emulation.
Thus these environment variables must be defined before you execute
.I "wty:"
.B "TERM,"
which names the actual terminal you are using;
.B "TERMCAP,"
which should define the pathname of the file containing your TERMCAP
descriptions;
and
.B "WTYP,"
which names the prototype entry within TERMCAP.
(The
.B WTYB
buffer name variable is optional).
.PP
For those who use vt100 compatible terminals,
.B TERM
should be "vt100",
.B TERMCAP
should be "\*P/termcap" (or "/etc/termcap"), and
.B WTYP
should be "vwty_".
The file "\*P/termcap" provides sufficient definitions for vt100 users.
It may also be used as a guide in developing other definitions.
If you 
.nf
        setenv TERMCAP /etc/termcap
.fi
it is assumed that "/etc/termcap" has been edited
to contain a new vt100 definition and WTYP entry as 
given in the file "\*P/termcap".
If this is not the case, or if you use a local TERMCAP file (which is
faster anyway for programs that search for TERM entrys), then you need to
edit your own local TERMCAP file.
.PP
A new 
.B TERM
type entry is included in "\*P/termcap" for those who have access to ANSI
compatible terminals (these are vt100 functional supersets which allow local
editing functions).
The entry name is "ansi": 
.nf
        setenv  TERM ansi
.fi
and 
.B WTYP
should be: 
.nf 
        setenv  WTYP wty_
.fi
.br
.SH TERMCAP INTERFACE
.PP
This section provides additional details about the
.B WTYP
prototype entry and how it relates to actual devices.
This section is necessary reading if you do not
have a vt100 or ANSI compatible terminal, or if you are writing a new
TERMCAP entry.
It is assumed that you are familiar with the material covered in
.I "termcap(5)."
.PP
The primary capability required by
.I wty
for any terminal is a controllable scrolling region defined by
.B "cs."
The multiple scrolling regions of
.I wty
are controlled by multiplexing the scrolling region of
.B "TERM."
The 
.B cs
cap requires a top and bottom row parameter defining the
scrolling region.
These parameters are encoded in the same way as the parameters are for
.B "cm."
.PP
The specific caps required by
.I wty
for a given
.B TERM
definition depend, with two exceptions, upon the
.B WTYP
prototype definition.
The exceptions are
.B cs
and
.B "cm;"
controllable scrolling region and cursor motion are the only two caps
which 
.I must
be provided in your
.B TERM
definition.
.PP
For most other caps, if the
.B WTYP
entry defines a particular cap, then the corresponding cap in the
.B TERM
entry must also be defined.
Some caps which have reasonable defaults do not need an explicit definition
at all.
The caps: (bc, co, cr, do, is, ke, ks, li, nl, sg, ug, ve, vs, we, ws)
have defaults (respectively) 
of: (^H, 80, ^M, ^J, ?, ?, ?, 24, ^J, 0, 0, ?, ?, ?, ?);
where '?' means the empty string.
.PP
The
.B WTYP
prototype defines the specific caps required for all windows by
.I "wty."
Each differently sized window also requires a set of capabilities which
define the size of the window.
The caps
.B co
and
.B li
describe window size variables.
.B Co
should always be constant since windows are defined as scrolling regions
which extend across the entire display.
Thus the
.B li
cap is the only parameter determining window size.
.PP
Since each window's shell requires knowledge of its own window's size,
via the
.B TERM
environment variable,
this may be accomplished by extending the basic
.B WTYP
definition by defining a new entry for each different size window.
The entry must be named according to this rule:
The name of the
.B WTYP 
entry is the prefix of the new name, and the row/column size of the window
determines the postfix of the new name in the format: RxC, where R is the
same as
.B "li,"
and C is the same as
.B "co."
Thus, for a window of size 12x80, and (say)
.B WTYP
= "vwty_", then the name of the new entry would be "vwty_12x80".
Note that there must be an entry for
.B every
window size.
Window (row) sizes are computed by dividing the maximum number of rows by
the number of windows.
So, for example, if we have a 24-row host terminal, then we would need 
definitions for 24 rows (24/1), 12 rows (24/2), 8 rows (24/3), 
and 6 rows (24/4).
.PP
At this point, it may seem that the use of the
.B TERM
environment variable has been inconsistent \- this is not so.
Recall that
.I wty
creates new 
.I shells
for each window.
It is these shells which require that their
.I own
version of the
.B TERM
variable identify the size of their attached window.
The propagation of this information to each window's shell is handled
automatically by
.I wty.
This is the purpose of forming a new TERMCAP entry by concatenating the
.B WTYP
prototype prefix and the RxC format postfix as described above.
Since
.I wty
requires knowledge of the terminal it is controlling, the definition of
.B TERM
at the time of program initialization provides that knowledge.
.SH TTY INTERFACE
.PP
This section is presented for informational purposes only \- understanding
the details of the tty interface is not necessary in order to use
.I wty.
.PP
When
.I wty
begins, with one exception, the initial tty state is passed on to the 
sub-shells which are created for all of the windows.
In general, the actual setting of this state is more or less irrelevant 
to the correct operation of
.I "wty."
The exception is that "stty -tabs" is explicitly set for the sub-shells;
this is because
.I wty
ignores incoming tabs (^I) from sub-shells.
However, after this initial state is picked up,
.I wty
resets several tty modes ala "stty new cbreak -echo -tabs nl".
Also, all special characters are un-defined (i.e. stty <c> u) except for
the flow control characters (^S ^Q usually).
This is essentially equivalent to "stty raw" but allows automatic
flow-control and delay-processing (whew!).
.SH SEE ALSO
.B "msh(\*M)"
.br
.B "wms(\*M)"
.SH BUGS
.PP
Not all programs which use TERMCAP can run under
.I "wty."
In particular, those programs which attempt to control
.B cs
themselves will have little luck.
Fortunately, the number of such programs appears to be small.
.PP
It is possible that sub\-processes may still exist after
.I wty
is terminated.
Usually this occurs if backround jobs are left running in a sub\-shell
after quiting
.I "wty."
One should then do a ps command to check on stray processes.
.PP
The <break> key does not work.
It is best to rely upon your <kill> character if you regularly use <break> 
as a <kill> alias.
.PP
The <start> and <stop> characters affect flow-control globally \- there is
no way to get local (per window) flow control.
.PP
Due to the lack of internal buffering, when one resumes a stopped
.I "wty,"
the individual windows are not automatically redrawn.
For the same reason, creating or deleting windows automatically
clears and homes all windows (likewise for folding and opening).
.PP
If
.I wty
is executed for too long at a time, the operating system will renice it.
As this will slow things down quite a bit, it is advisable to quit
.I wty
then restart it again.
Another alternative is to stop (<ctrl-A><ctrl-Z>)
.I wty
and use the original shell as often as feasible.
This may delay the renice.
.SH NOTES
.PP
The TERMCAP definitions as given in "\*P/termcap" make a reasonable 
basis for your own local TERMCAP file.
Note two new capabilities:
.B we
and
.B "ws."
These (string) caps should be given to end and start a
.I wty
session (or when stopping and resuming).
Typically, they would include the same information as 
.I is
does but should explicitly set/reset the scrolling region.
Note that
.I is
should
.B not
explicilty set/reset the scrolling region.
.PP
The 
.B cl 
and 
.B cd
prototype caps are implemented by means of
.B ce 
only (in the host TERMCAP definition).
This means that cl and cd are not needed in the host definition.
.PP
The justification for pad counts in the TERMCAP prototypes is a little fuzzy.
Generally, depending on your own terminal, no pad delays need be given.
If
.I wty
seems to generate strange screen commands, a little delay time in things
like 
.B cm
in the prototype entry should fix things.
The reason this seems to occur is that programs which use the padding
information of TERMCAP (like vi) assume that they are talking directly to a 
terminal.
Injecting a program like
.I wty
between vi and a terminal can introduce delay timing discontinuities into
the output stream, not to mention the fact that 
.I wty
itself is sending control codes to the screen (thus adding to the general
chaos of control codes flocking to the terminal).
.SH AUTHOR
George Nelan
