.TH wms \*M "1 July 1985"
.SH NAME
wms \- guide to the window management system (version \*V)
.SH SYNOPSIS
.B "\*P/wms/*"
.SH DESCRIPTION
.ad b
.PP
.I Wms
consists of two executable programs,
.I msh
and
.I "wty;"
plus several code fragments which, when tied together in the correct manner,
can provide the basis for "do-it-yourself" window managers.
.PP
.I Msh
is a meta-shell manager that coordinates communication activities between
sub-shells on the host and a window manager by means of a bi-directional
communication-stream.
The window manager may either reside on the host itself, acting as a virtual
windowing terminal emulator, or it may reside on a remote machine (such as a
PC).
The code supplied with the system enables either configuration in a relatively 
simple and efficient way.
.PP
.I Wty
is a host-resident window manager which has been integrated with
.I msh
in a virtual windowing terminal configuration.
.I Wty
utilizes the
.B TERMCAP
database so that many different kinds of terminals can potentially support
the windowing emulation.
Both
.I msh
and
.I wty
are documented as separate
.I man
entrys.
.SH CODE FRAGMENTS
.PP
The following files are provided in \*P/wms/ as system code fragments:
.nf
    max.msh.c
    max.msh.h
    max.msh.o
    max.wty.c
    max.wty.h
    max.wty.o
    msh.bind.o
    msh.h
    msh.o
    wty.bind.o
    wty.o
.fi
.PP
The files "max.xxx.x" provide a mechanism for tuning variable parameters for
.I msh
and
.I "wty."
The ".h" files supply the absolute maximum values for the parameters,
the ".c" files supply the corresponding variable definitions, and 
the ".o" files are the compiler outputs for the ".c" files.
.PP
The "msh.h" file provides the 'defines' required for command input/output
by
.I "msh."
The file "msh.bind.o" is the object code binder for 
.I "msh."
.I Msh
is the result of linking "msh.o", "max.msh.o" and "msh.bind.o".
.PP
The file "wty.bind.o" is the object code binder for
.I "wty."
.I Wty
is the result of linking "msh.o", "wty.o", "max.wty.o" and "wty.bind.o".
.PP
The following sections describe how to utilize the code fragments for the
purposes of tuning or for the construction of customized window managers.
.SH TUNING MSH
.PP
The following parameters, found in "max.msh.c", can be adjusted as desired:
.nf
    MAXSLAVES
    MAXNOPOLLS	
    MAXSHELL
    MAXTCODE
    MAXCBUF
.fi
.PP
MAXSLAVES indicates the maximum number of sub-shells allowed to co-exist.
.PP
MAXNOPOLLS determines the maximum number of sub-shell output polls bypassed.
Larger values will cause sub-shells which have been recently quiescent to
have their first output burst delayed longer.
After this initial delay, however, succeeding outputs will not be delayed.
This effect serves to minimize excessive polls on sub-shells, thus providing
a measure of echo response time optimization.
This parameter does not apply to the current input shell when an echo is
pending.
.PP
MAXSHELL defines an upper limit on the size of shell name strings which may
be passed to
.I msh
via a <create_usr> command (q.v.).
.PP
MAXTCODE limits the size of terminal code strings which may be passed to
.I msh
via a <create_csh>, <create_usr>, or <resize> command (q.v.). 
.PP
MAXCBUF is the maximum size of I/O character buffers in
.I "msh."
.PP
Note: the default values for all parameters have been carefully chosen 
to provide near optimal performance.
Also, recall that "max.msh.h" indicates the absolute maximum values for
these parameters.
.PP
The procedure for retuning
.I msh
then consists of the following steps:
.nf
    edit:       max.msh.c
    compile:    cc -c max.msh.c
    link:       cc msh.o max.msh.o msh.bind.o -o msh
.fi
.SH TUNING WTY
.PP
The following parameters, found in "max.wty.c", can be adjusted as desired:
.nf
    MAXWINDOWS
    MAXLABEL
    MAXQBUF
.fi
.PP
MAXWINDOWS must be equal to MAXSLAVES in "max.msh.c".
Thus, to increase the number of windows in
.I "wty,"
MAXSLAVES and MAXWINDOWS must both be modified.
.PP
MAXLABEL must be the character equivalent of MAXWINDOWS.
.PP
MAXQBUF defines the size of I/O queues in
.I "wty."
Because of implementation considerations, this value should be set
to about MAXCBUF << 2.
Failure to adhere to this restriction may cause a run-time queue
overflow in
.I "wty"
resulting in execution termination.
.PP
Note: the default values for all parameters have been carefully chosen 
to provide near optimal performance.
Also, recall that "max.wty.h" indicates the absolute maximum values for
these parameters.
.PP
The procedure for retuning
.I wty
then consists of the following steps:
.nf
    edit:       max.wty.c
    edit:       max.msh.c             (if necessary)
    compile:    cc -c max.wty.c
    link:       cc msh.o wty.o max.wty.o wty.bind.o \\
                   -ltermcap -o wty
.fi
.SH CONSTRUCTING A CUSTOM DISCREET WINDOW MANAGER
.PP
A remote window manager residing on (say) a PC may be interfaced quite
simply with the host system.
.I "Msh"
provides all of the necessary work to coordinate and multiplex shell
activity.
Since
.I msh
communicates over standard input/output with the window manager,
all that is necessary on the remote end is to initiate contact with
The host, run
.I msh
on the host; then run the remote window manager.
.PP
This method of total window management is probably the most efficent and
powerful way to implement the system.
Advantages include significantly reduced host loading, not to mention the
generally higher quality graphics capabilities of many PCs relative to
standard terminals as described by TERMCAP.
See the manual entry for
.I msh
for more information.
.SH CONSTRUCTING A CUSTOM INTEGRATED WINDOW MANAGER
.PP
The procedure for implementing an integrated window manager with
.I msh
is somewhat more involved than the implementation of a discreet remote
window manager.
.I Wty
is the result of such an implementation.
.PP
The primary consideration in the window manager /
.I msh
interface is how to convert the standard input/output calls of
.I msh
into a procedural interface with the window manager.
This may be accomplished by substituting demand-driven procedure evaluation
for IO calls.
.PP
The basic IO call flow of
.I msh
may be described as:
.nf
    put(current_input_shell,get(stdin))
    for_each_shell,put(stdout,get(shell))
.fi
where necessary input command processing and output packet fragmentation
is implicit.
.PP
The basic IO call flow of a window manager can be described as:
.nf
    put(stdout,get(keyboard))
    put(screen,get(stdin))
.fi
where necessary input packet fragmentation and output command processing
is implicit.
.PP
Thus the put(stdout) of
.I msh
is linked to the get(stdin) of the window manager, and the
get(stdin) of
.I msh
is linked to the put(stdout) of the window manager.
In other words, a bi-directional pipeline exists between
.I msh
and the window manager.
.PP
This relationship can be exploited so that the IO link between
.I msh
and the window manager is eliminated; being replaced by
direct procedural evaluation.
.PP
Thus we have the following externally visible procedures in
.I "msh:"
.nf
    init_msh();
    abort();
    slave_driver();
.fi
.PP
.I Msh 
also requires that these procedures be linked with it:
.nf
    get_master(string);
    put_master(string,length);
.fi
where string is (char *), and length is (int).
Note: these are the procedures (along with main) which "msh.bind.o" 
supplys for "msh.o".
.PP
Thus, the window manager must provide a main program which essentially does the
following:
.nf
    ...
    init_msh();
    ...
    for (;;)
        screen_driver();
    ...
.fi
where screen_driver is part of the window manager and calls the
slave_driver procedure of
.I "msh."
The slave_driver procedure, in turn, calls get_master which must be supplied
by the window manager.
This call can be directed to get input from the user and process any
local commands.
.PP
When
.I msh
is ready to send an output packet, it calls put_master.
This call may be used to satisfy the original demand from screen_driver.
Thus one entire demand driven evaluation cycle can be completed upon a
return to screen_driver.
.PP
Note: each call to "slave_driver" of
.I msh
results in a poll of the next slave in the polling sequence.
.PP
The entire demand evaluation cycle can be visualized as:
.nf

main:
    ...
    init_msh
    ...
    for (;;)
        screen_driver
            get msh
                slave_driver
                    master_driver
                        get_master
                            get stdin (keyboard)
                        put shell
                    get shell
		    put_master
            put stdout (screen)
    |____
.fi
.PP
The procedure for compiling and linking the integrated window manager
is similiar to that for retuning 
.I "wty."
.SH FILES
.B "\*P/wms/*"
.br
.SH SEE ALSO
.B "wty(\*M)"
.br
.B "msh(\*M)"
.SH AUTHOR
George Nelan
