.TH msh \*M "1 July 1985"
.SH NAME
msh \- meta-shell manager (version \*V)
.SH SYNOPSIS
.B "\*P/msh"
.SH DESCRIPTION
.ad b
.PP
.I Msh 
is a stand-alone meta-shell manager intended for use with a remote 
window manager (such as a PC-resident program).
It coordinates activities between independent host sub-shells 
and a remote windowing terminal.
.PP
.I Msh
communicates with an external window manager over standard input and output.
Input to
.I msh
(output from the window manager) includes normal user-input text along
with commands generated by the window manager (in response to user actions).
These commands may cause
.I msh
to create a new shell (for a window), 
delete a shell, select another shell for input,
or terminate execution.
All user-input text is directed towards the shell currently selected for input.
.PP
Output from
.I msh
(input to the window manager) consists of multiplexed outputs from sub-shells.
The only command in this direction is a "change output window"
sequence which preceeds and identifies each sub-shell's output buffer packet.
.SH INTERFACE PROTOCOL
The
.I msh
interface protocol is defined by the (extended BNF) syntax:
.nf
<msh_input>     -> { <input_cmd> | TEXT }
<input_cmd>     -> <csi> <quit> 
                |  <csi> <set_input> 
                |  <csi> <create_csh> 
                |  <csi> <create_usr> 
                |  <csi> <resize> 
                |  <csi> <delete>
                |  <csi> <stop>          
<csi>           -> "\\0@"
<quit>          -> "A"
<set_input>     -> "B" <n>
<create_csh>    -> "C" <n> <tc>
<create_usr>    -> "D" <n> <tc> <sh>
<resize>        -> "E" <tc>
<delete>        -> "F" <n>
<stop>          -> "G" <f>
<n>             -> "1" | "2" | ... | "9"
<tc>            -> { ANY } ";" 
<sh>            -> { ANY } "\\n"
<f>             -> "0" | "1"
.fi
.nf
<msh_output>    -> { <output_cmd> | TEXT }
<output_cmd>    -> "\\027" <n>
.fi
.PP
Where TEXT is a non-ambiguous sequence of arbitrary characters,
ANY is any non-ambiguous character, and "" delimits literal strings 
("\\0" => null, "\\n" => newline, "\\027" => <CTRL-W>).
The (input) command sequence introducer is <csi>.
Shell (window) labels are given by <n>, and
terminal identification code strings are given by <tc>.
.PP
The <quit> command terminates execution of 
.I "msh."
.PP
The <set_input> command changes the current input shell to that labeled
by <n>.
All succeeding input is directed towards that shell, until another <set_input>
command.
.PP
The <create_csh> command creates a new c-shell (labeled by <n>) and sends
a <resize> string of the form 
.nf
        setenv TERM <tc>
.fi
to the shell.
.PP
The <create_usr> command creates a new user-defined shell given by <sh>.
.PP
The <resize> command sends a string of the form 
.nf
       setenv TERM <tc>
.fi
to  the current input shell.
This command is useful for cases where a shell could not previously receive
a <tc> string due to being in an improper state (e.g. in an editor).
.PP
The <delete> command deletes the current input shell and causes the shell
labeled by <n> to become the new current input shell.
.PP
The <stop> command suspends execution and returns control to the parent shell of
.I "msh."
The <f> flag defines the tty state after suspension.
With <f> = "0", the tty is reset to the state of the parent of
.I "msh;"
with <f> = "1", the state is left as is.
This flag is useful as a debugging aid.
.PP
The single <output_cmd> is the packet header for each shell's output buffer.
This command is indivisible (always two characters), but no such assumption can
be made concerning indivisibility of buffer packets (the TEXT).
This has ramifications for window managers which interpret virtual
terminal command sequences.
Shell output buffers are multiplexed on a prioritized polling basis so that 
echo response time is minimized while maintaining a high degree of output
concurrency.
.SH TTY INTERFACE
.PP
When 
.I msh 
begins, with one exception, the initial tty state is passed on to all 
sub-shells which are created.
The exception is that "stty -tabs" is explicitly set for the sub-shells;
this is because
.I msh
assumes that the remote window manager ignores incoming tabs from sub-shells.
After the initial state is picked up,
.I msh
resets several tty modes ala "stty new cbreak -echo -tabs nl".
All special characters are un-defined (i.e. stty <c> u) except for
the flow control characters (^S ^Q usually).
This is more-or-less equivalent to "stty raw" but allows automatic
flow-control and delay-processing (heh-heh).
.SH NOTES
.PP
.I Msh
assumes that all input commands are syntactically and semantically
correct \- it is the responsibililty of the remote window manager to assure
this is so.
Also, explicit initialization commands are required.
For each initial shell,
.I msh
expects to receive a <create_csh> (or <create_usr>) command for each shell.
.SH FILES
.B "\*P/wms/*"
.SH SEE ALSO
.B "wty(\*M)"
.br
.B "wms(\*M)"
.SH BUGS
.PP
It is possible that sub\-processes may still exist after
.I msh
is terminated.
Usually this occurs if backround jobs are left running in a sub\-shell
after quiting
.I "msh."
One should then do a ps command to check on stray processes.
.PP
The <break> key does not work.
It is best to rely upon your <kill> character if you regularly use <break> 
as a <kill> alias.
.PP
The <start> and <stop> characters affect flow-control globally \- there is
no way to get local (per shell) flow control.
.PP
If
.I msh
is executed for too long at a time, the operating system will renice it.
As this will slow things down quite a bit, it is advisable to quit
.I msh
then restart it again.
.SH AUTHOR
George Nelan
