/* picture.c - reads a compact bitmap and converts it into the Unix-pc
**             format.
**
** Copyright (C) 1988 by Muhammad S. Benten.
**                       benten@boulder.colorado.edu
**
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
*/

#include <stdio.h>

/* default icon */

short deflt[]={
-1, -1, 1, -32768, -63, -30721, 1729, -27136, 193, -27136, 193,
-27136, 193, -27136, 193, -27136, 193, -27136, 193, -27136, 193,
-27136, 193, -29184, -159, -29185, -127, -30721, 16385, -32760,
32705, -24592, -31, -24577, -31, -28673, -31, -28673, 1, -32768, 1,
-32768, 1, -32768, 1, -32768, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
-1, -1, -1, -1
};

extern char * filenam;

extern int transpose;

icon_exec(comm,rows,cols,ifd)
char **comm;
FILE *ifd;
int rows, cols;
    {
    char engl[256];
    char *bits;
    char tst,cbm;
    int i,index1, row, col,byte1,cols1,rows1;

    /*
      Was there an icon file specified?
    */

    if (ifd != ((FILE *) -1) ) {

    /*
      Oh, yeh!  Is it a Compact BitMap?
    */


    if ( (tst = getc( ifd ) ) == 42 ){
      if ( getc( ifd ) == 23 )
	{
          cbm = 1;
          cols1 = getc( ifd ) << 8;
          cols1 += getc( ifd );
          rows1 = getc( ifd ) << 8;
          rows1 += getc( ifd );
          if (cols == 0)
             cols = cols1;
          if (rows == 0)
             rows = rows1;
          cols = cols /8;
        }}  
        else

    /*
      Or is it Unix-pc  raw BitMap?
    */

        {
          cbm = 0;
          if ( ( rows == 0) || (cols == 0)){
             printf("3b1tools: You must specify width and height. This is a raw icon!");
             exit(1);}
          cols = cols/8;
        }
        rows = (rows/8)*8;

        bits = (char *) malloc(cols*rows) ;

        for (col = 0; col <= cols ; col++)
          for(row = 0; row < rows ; row += 2)

	    /* handle CBM format ===> Unix-pc */

            if  (cbm == 1)  {
	    byte1 = 0;
	    tst = getc( ifd );

	    /* flip the high byte */

	    if (tst & 0x1)
	       byte1 |=  0x80;
	    if (tst & 0x2)
	       byte1 |=  0x40;
	    if (tst & 0x4)
	       byte1 |=  0x20;
	    if (tst & 0x8)
	       byte1 |=  0x10;
	    if (tst & 0x10)
	       byte1 |=  0x8;
	    if (tst & 0x20)
	       byte1 |=  0x4;
	    if (tst & 0x40)
	       byte1 |=  0x2;
	    if (tst & 0x80)
	       byte1 |=  0x1;
	     bits[col*rows + (row+1)] =  byte1;
	    byte1 = 0;
	    tst = getc( ifd );

	    /* flip the the low byte */

	    if (tst & 0x1)
	    	byte1 |=  0x80;
	    if (tst & 0x2)
	       	byte1 |=  0x40;
	    if (tst & 0x4)
	       	byte1 |=  0x20;
	    if (tst & 0x8)
	       	byte1 |=  0x10;
	    if (tst & 0x10)
	       byte1 |=  0x8;
	    if (tst & 0x20)
	       byte1 |=  0x4;
	    if (tst & 0x40)
	       byte1 |=  0x2;
	    if (tst & 0x80)
	       byte1 |=  0x1;

	    bits[col*rows + row] =  byte1;}
        else 

	   /*  It is already in Unix-pc format */

            if ( col == 0 && row == 0) {
	       bits[1] =  tst;
	       bits[0] =  getc(ifd);
            } 
            else {
	       bits[col*rows + (row+1)] =  getc(ifd);
	       bits[col*rows + row] =  getc(ifd);
            }
       fclose(ifd);
        }
     else

      /*  use the built in (default) icon */

     {  
        cols = 4;
        rows = 32;
        bits = (char *) deflt;
        }

     /*
       transpose the bitmap
     */

     if ( transpose ) {

        /* Not implemented. 

	   A1:Why? 		
	   A2:very slooow.
	   A1:But only for big pictures, isn't it?
	   A2:Any way, who wants to transpose a small icon?
	   A1:I do. 
	   A2:Go ahead and do it then.

	transpose_bits ( bits , rows , cols);
        i = rows/8;
        rows = cols*8;
        cols = i;

	*/
     }
    
    /* invoke the window manager in tools.c */

        windowinit( comm,bits, cols , cols*8 ,rows);

    exit( 0 );
    }


