/* 3b1tools.c - This file parses the command argument and performs
**              all "windy" related processing. It will then call
**              the icon handler.
**
** Copyright (C) 1988 by Muhammad S. Benten.
**                       benten@boulder.colorado.edu
**
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
**
**    A major portion of this file is extracted from the program windy
**    which is available from "The STORE" with its sources.
**    It will preserve most of windy's arguments.
*/
#include "3b1tools.h"
#define        NA      0xffff

struct uwdata xuw = {
       NA, NA, NA, NA, NA};
struct utdata xut[WTXTNUM];
int bflag = 0;
int Kflag = 0;
char blot[81];
char *ttyname();
char * filenam;
extern struct termio argg;
extern char *optarg;
extern int optind;

main(ac,av)
int ac;
char **av;
{
       int nflag = 0;
       char avname[256];
       char *env,cavname[256];
       int i, c,rows,cols,pid;
       FILE * ifd;
       ioctl(Wn,TCGETA,&argg);
       cols = 0;
       rows = 0;
       maxw = 672;
       maxh = 288;
       invert = 0;
       iconopen = 0;
       transpose = 0;

       if ( ac == 1 ) { /* no argument, get commands */
          strcat(avname,".3b1tool");
          if ( (ifd = fopen( avname, "r" )) != NULL) {
                  startup(ifd,av);
                  exit(0);} else {
          strcpy(avname,getenv("HOME"));
          strcat(avname,"/.3b1tool");
          if ( (ifd = fopen( avname, "r" )) != NULL) {
                  startup(ifd,av);
                  exit(0);}
        else {
           printf("3b1tools: File .3b1tool doesn't exist\n3b1tools: Use 3b1tools -S for full screen shell\n");
           exit(1);
       }}}

       else {
       ifd = (FILE *) -1;
       while((c = getopt(ac, av, "robSRTp:c:l:u:1:2:n:f:h:w:x:y:K:X:Y:I:W:H:")) != EOF) {
               switch(c) {
               case 'b':{
                       bflag++;
                       break;}
               case 'h':{
                       xuw.uw_height = atoi(optarg);
                    break;}
               case 'w':{
                       xuw.uw_width = atoi(optarg);
                       break;}
               case 'x':{
                       xuw.uw_x = atoi(optarg);
                       break;}
               case 'y':{
                       xuw.uw_y = atoi(optarg);
                       break;}
               case 'f':{
                       xuw.uw_uflags = htoi(optarg);
                       xuw.uw_uflags &= ~NOSETUFLAGS;
                       break;}
               case 'p':
                       utset(WTXTPROMPT, optarg);{
                       break;}
               case 'c':{
                       utset(WTXTCMD, optarg);
                       break;}
               case 'l':{
                       utset(WTXTLABEL, optarg);
                       break;}
               case 'n':
               case 'u':{
                       nflag = 1;
                       utset(WTXTUSER, optarg);
                       break;}
               case '1':{
                       utset(WTXTSLK1, optarg);
                       break;}
               case '2':{
                       utset(WTXTSLK2, optarg);
                       break;}
               case '?':{
                       fprintf(stderr, "usage: 3b1tools [args] [command-args]\n");
                       exit(2);}
               case 'K':{
                       strncpy(blot, optarg, 80);
                       Kflag ++;
                       break;}

               case 'I': {  /*  image file name */
                         if ( optarg[0] == '-' ) {
                            ifd = stdin;}
                         else {
                         ifd = fopen( optarg, "r" );
                         if ( ifd == NULL )
	                 {
	                     fprintf( stderr, "Image %s: can't open.\n", optarg);
	                     exit( 1 ); }
                             filenam = optarg;}
                             break;}
                case 'W': { /* overwrite image height */
                          cols = atoi(optarg);
                          break;}
                case 'H': { /* overwrite image width */
                          rows = atoi(optarg);
                          break;}
                case 'X': { /* icon width */
                          maxw = atoi(optarg);
                          if (maxw > 672 )
                             maxw = 672;
                          break;}
                 case 'Y': { /* icon height */
                           maxh = atoi(optarg);
                           if (maxh > 288 )
                              maxh = 288;
                           break;}
                 case 'R': { /* reverse image */
                           invert++;
                           break;}
                 case 'o': { /* start with an open window */
                           iconopen++;
                           break;}
                 case 'r': { /* start with an open window */
                           normal++;
                           break;}
                  case 'S':{
                           xuw.uw_x = 0;
                           xuw.uw_y = 12;
                           xuw.uw_width = 720;
                           xuw.uw_height = 288;
                           xuw.uw_uflags = 0x1;
                           break;}
                 case 'T': { /* transpoe icon */
                           transpose++;
                           break;}}

       }}
       /*
        * if gave command args, put it in a new window
        * if gave window args, or no args at all, change window params
        */
       if(optind < ac) {
               if( bflag)
                  newwind();
               avname[0] = 0;
               for(i=optind; i<ac; i++) {
                       strcat(avname, av[i]);
                       strcat(avname, " ");
               }
               if( bflag)
                 if(!nflag)
                       utset(WTXTUSER, avname);
       }
       fixwind();
               
               if(bflag) {
                       pid = fork();
                       if(pid > 0)
                               exit(1);
                       else if(pid == 0) {
                               setpgrp();
                               ioctl(0, WIOCPGRP);
                       }
               }
               icon_exec(av,rows,cols,ifd);
       exit(0);
}
utset(n, s)
char *s;
{
       xut[n].ut_num = 1;
       strncpy(xut[n].ut_text, s, WTXTLEN);
}
newwind() {
       char name[10];
       struct termio t;
       int bad = 0, i, fd;

       if (!isatty(0)) return;
       if(strncmp("/dev/w", ttyname(0), 6)!=0 ) return;

       if (ioctl(0, TCGETA, &t) < 0) {
               perror("getting tty chars");
               bad = 1;
       }
       fd = open("/dev/window",2);
       if (fd < 0) {
               perror("opening window");
               return;
       }
       if(bflag) {
               ioctl(fd, WIOCSELECT);
               sprintf(name, "[w%d]\n", ioctl(fd, WIOCGCURR));
               write(0, name, strlen(name));
       }

       close(0);
       dup(fd);
       close(1);
       dup(fd);
       close(2);
       dup(fd);
       close(fd);
       /* Set in the previous edit characters to the new window */
       if (!bad && ioctl(0, TCSETAF, &t) < 0)
               perror("setting tty chars");
       for (i=0; environ[i]; ++i) {
               if (!strncmp(environ[i],"TERMCAP=",8)) {
                       environ[i] = "TERMCAP=/etc/termcap";
               }
               if (!strncmp(environ[i],"TERM=",5)) {
                       environ[i] = "TERM=s4";
               }
       }
}
fixwind() {
       struct uwdata uw;
       int i;

       if(Kflag) {
               xut[WTXTSLK1].ut_num = WTXTSLK1;
               xut[WTXTSLK2].ut_num = WTXTSLK2;
               keyfix(xut[WTXTSLK1].ut_text);
               keyfix(xut[WTXTSLK2].ut_text);
       }
       for(i=0; i<WTXTNUM; i++) {
               if(xut[i].ut_num) {
                       xut[i].ut_num = i;
                       ioctl(0, WIOCSETTEXT, &xut[i]);
               }
       }
       ioctl(0, WIOCGETD, &uw);
       if(xuw.uw_x != NA) {uw.uw_x = xuw.uw_x;new_wind++;}
       if(xuw.uw_y != NA) {uw.uw_y = xuw.uw_y;new_wind++;}
       if(xuw.uw_width != NA) {uw.uw_width = xuw.uw_width;new_wind++;}
       if(xuw.uw_height != NA) {uw.uw_height = xuw.uw_height;new_wind++;}
       if(xuw.uw_uflags != NA) {uw.uw_uflags = xuw.uw_uflags;new_wind++;}
       ioctl(0, WIOCSETD, &uw);
}
keyfix(s)
char *s;
{
       int c, i;

       for(i=0; i<80; i++) {
               c = s[i] & 0177;
               if(c == 0) c = ' ';
               switch(blot[i]) {
               case ' ':
               case 0:
                       c = ' ';
                       break;
               case 'r':
               case 'R':
                       c |= 0200;
                       break;
               }
               s[i] = c;
       }
}
char *utname[] = {
       "Prompt line",
       "Command line",
       "Label",
       "User",
       "SLK1",
       "SLK2",
};
report(s)
char *s;
{
       struct uwdata uw;
       struct utdata ut;
       int i;

       printf("%s:  ", s);
       ioctl(0, WIOCGETD, &uw);
       uwshow(&uw, (char *)0);

       for(i=0; i<WTXTNUM; i++) {
               ut.ut_num = i;
               ioctl(0, WIOCGETTEXT, &ut);
               if(ut.ut_text[0]) {
                       printf("%s=<%.81s>\n", utname[i], ut.ut_text);
               }
       }
}
uwshow(p, s)
struct uwdata *p;
char *s;
{
       printf("(x,y)=(%d,%d)  ", p->uw_x, p->uw_y);
       printf("(width,height)=(%d,%d)  ", p->uw_width, p->uw_height);
       printf("flags=%x\n  ", p->uw_uflags);
       printf("(hs,vs)=(%d, %d)[RO]  ", p->uw_hs, p->uw_vs);
       printf("baseline=%d[RO]  ", p->uw_baseline);
       printf("(cx,cy)=(%d, %d)[RO]\n", p->uw_cx, p->uw_cy);
}
htoi(s)
char *s;
{
       int x = NA;

       sscanf(s, "%x", &x);
       return x;
}


startup(ifi,argv)
int ifi;
char *argv;
{
   char cavname[256],avname[256],*sy;

   while ( fgets(avname,256,ifi) != 0 ) {
      cavname[0] =0;
      strcat(cavname,avname);
      sy = (char *) strtok(avname," ");
      if ( sy[0] != 0 )
      if ( strncmp(sy,"3b1tools",5)  !=0 ) {
      avname[0] =0;
      strcat(avname,cavname);
      strcpy(cavname , "3b1tools -b "); 
      strcat(cavname,avname);
      system(cavname);} else{
      printf("3b1tools: error in .3b1tool file\n");
      printf("3b1tools: in %s\n",avname);
      printf("3b1tools: only arguments to 3b1tools are specified\n");}}
   close(ifi);
}
