/* tools.c -   Displays, opens, closes and resumes an icon.
**
**
** Copyright (C) 1988 by Muhammad S. Benten.
**                       benten@boulder.colorado.edu
**
**
** Permission to use, copy, modify, and distribute this software and its
** documentation for any purpose and without fee is hereby granted, provided
** that the above copyright notice appear in all copies and that both that
** copyright notice and this permission notice appear in supporting
** documentation.  This software is provided "as is" without express or
** implied warranty.
**
**   
*/
# include 	<sys/ioctl.h>
# include 	<signal.h>
# include       <sys/mouse.h>
# include       <kcodes.h>
# include 	<message.h>
# include       "3b1tools.h"

#define up		196
#define down		197
#define left		190
#define right		204
#define xdelta		40
#define ydelta		20
#define XMAX1    	uwidth
#define YMAX1  	 	uheight

/* inside the window */

#define XMAX    uw.uw_width                     /* in pixels            */
#define YMAX    uw.uw_height                    /* in pixels            */
#define BPERBY  8                               /* bits per byte        */
#define XMAXB   ((XMAX+(BPERBY-1))/BPERBY)      /* in bytes             */
#define YMAXB   YMAX                            /* same as pixels       */
extern unsigned short patwhite[];

int Wn=1; 
int new_wind1;
int new_wind;
int maxw;
int maxh;
int transpose;
int invert;
int bord_flag;
int iconopen=0;
int normal=0;
unsigned isig=0;
short done=0;
int statch;

struct uwdata   uw;             /* current window data */
struct uwdata   Suw;            /* Saved window data */
struct uwdata   Puw;            /* Saved window data */
struct uwdata   suw;            /* Saved window data */
struct urdata urt;
unsigned short Bitmap[ 15660 ];             /* Saved screen */
unsigned short Bitmap1[ 15660 ];            /* Saved screen */
struct umdata mouse;
struct umdata mouse1;
struct termio argg;
struct termio argg1;
struct termio argg2;
struct termcb argcb;
int xstart,ystart,width,height,uwidth,uheight;
struct 	utdata sut[6];
struct 	utdata suti[6];
int  	(*intsig)(),(*quitsig)();
int 	closeit();
int 	sendit();
int 	frk=1;
int 	pid=-9;
int 	pppid,ppid;
extern 	char *optarg;
extern 	int optind;


/*
**   save the window state and close window
**   then go and wait for user response
*/

windowinit(comm,ico,wid,wid1,hit1)
char * ico, **comm;
int wid,wid1,hit1;
{
    int i;
    /* save original parameters */
    if ( ioctl( Wn, WIOCGETD, &uw) != 0 )
    {
        fprintf(stderr, "Can't close a non-window.\n");
        exit(1);
    }
    
    winit();
    keypad(0,1);


    /* save the bitmap */

    new_wind = wrastop(Wn, 0,0, Bitmap, XMAXB, 0,0, 0,0, XMAX, YMAX,
        SRCSRC, DSTSRC, 0 );
    new_wind1 = wrastop(Wn, 0,0, Bitmap1, XMAXB, 0,0, 0,0, XMAX, YMAX,
        SRCSRC, DSTSRC, 0 );

    /* save the window state */
    Suw = uw;
    Puw = uw;
    suw = uw;


    /*  save USER  texts */
    for ( i=0; i<6 ; i++) {
        sut[i].ut_num=i;
        suti[i].ut_num=i;
        ioctl(Wn,WIOCGETTEXT,&sut[i]);
        ioctl(Wn,WIOCGETTEXT,&suti[i]);
    }

    sprintf(suti[WTXTCMD].ut_text,"Press CTRL-Z to close window");

    /* Turn cursor off */
    fprintf(stderr, "\033[=1C" );

    /* set up function keys */
	wslk(Wn, 0, "   OPEN    TOGGLE   EXIT                             B1 TO    B2 TO    ",
		    "           BORDER                                    OPEN     TOGGLE   EXIT");

    /* set icon limits */

    xstart=0;
    ystart=0;
    width = wid1;
    height = hit1;
    if (wid1 > maxw )
       wid1 = maxw;
    if (hit1 > maxh )
       hit1 = maxh;
    uwidth = wid1;
    uheight = hit1;
    bord_flag = 1;

    /* close window */

    iconify(ico,wid,wid1,hit1);

    ioctl(Wn, WIOCGETMOUSE, &mouse);
    ioctl(Wn, WIOCGETMOUSE, &mouse1);
    mouse.um_flags = MSDOWN;
    ioctl(Wn, WIOCSETMOUSE, &mouse);
           
    manage_window(ico,wid,comm); 
}




/*
** Turn the window into an "icon".
*/

iconify(ico,wid,wid1,hit1)
char * ico;
int wid,wid1,hit1;
{
 int i;
 
    
    uw = suw;
    if (done != 1) {
    if ( bord_flag ) { 
       uw.uw_uflags |= NBORDER ;
    } 
    else {
          uw.uw_uflags &= ~(NBORDER);
          uw.uw_uflags |=  BORDHSCROLL ;
          uw.uw_uflags |=  BORDVSCROLL ;
    }
    uw.uw_height = hit1;
    uw.uw_width = wid1;
    ioctl( Wn, WIOCSETD, &uw );
    done=1;}

    urt.ur_srcbase = (unsigned short *) ico;
    urt.ur_srcwidth = wid;
    urt.ur_height = 1;
    urt.ur_width = wid1;
    urt.ur_srcx = xstart;
    if (invert)  {
       urt.ur_srcop = SRCXOR;
       urt.ur_pattern = patwhite;
    }

    for (i =0 ; i < hit1 ; i++) {
        urt.ur_srcy = ystart+i;
        urt.ur_dsty = i;
        ioctl( Wn, WIOCRASTOP, &urt ) ;}

}



/*
** Restore the window to the saved size and state.
*/

restore_window(restore)
int restore;
{
    int i;
    if (restore) {
      uw = Suw;
      ioctl( Wn, WIOCSETD, &uw );
        
      if (new_wind >= 0)
      wrastop(Wn, Bitmap, XMAXB, 0,0, 0,0, 0,0, XMAX, YMAX,
            SRCSRC, DSTSRC, 0 );

      /* position cursor and turn it on */

      fprintf(stderr, "\033[10;8H\033[=0C");
    }

    /*  restore USER  texts */
    for (i=0; i<6;i++) {
        sut[i].ut_num=i;
        ioctl(Wn,WIOCSETTEXT,&sut[i]);
    }

    if (restore) {
       if ( pid > 0 )
          kill(pid,9);
       kill(pppid,9);
       wexit( 0 );
    }
}



manage_window(ico, wid,com1)
unsigned short *ico;
int wid;
char **com1;
{
    int c,cc;
    int x,y,b,r,io,i;
    ppid = getpid();
    ioctl(Wn,TCGETA,&argg1);
    intsig =  signal ( SIGINT , sendit );
    quitsig=  signal ( SIGQUIT , sendit );
    (void) signal ( SIGTRAP , SIG_IGN );
    (void) signal ( SIGUSR2 , sendit );


    /* spawn a daemon process that would tell us
       if a CTRL-Z is caught
    */

    if ( (pppid =fork()) == 0 ) {
         (void) signal ( SIGUSR2 , closeit );

         /* It should have no control over the window */

         setpgrp();
loop:
         /* sleep until the window is opened */

         pause();

         /* take short naps until a suspend key is pressed */

         ioctl(0,TCGETA,&argg);
         while ( argg.c_cc[7] != 254 )  {
               sleep(1);
               ioctl(0,TCGETA,&argg);
         }
 
         /* tell the parent about it 
            and go back to sleep
         */
         argg.c_cc[7] = 0;
         ioctl(0,TCSETA,&argg);
         kill ( ppid , SIGUSR2 );
         goto loop;
    }

    /* the paraent should loop forever
    */

    for (;;)
    {
        if ( iconopen  ) {
          iconopen=0;
          c = F1;
        } else
           c = wgetc(Wn);

        ioctl( Wn, WIOCGETD, &suw );
        
        /* is it an exit command */

        if ( c == Exit || c == Cancl || c == s_Cancl || 
             c == F3 || c == F8 || c == EOF ) {
             if ( frk == 1 ) {
                confirm();
                iconify(ico,wid,XMAX1,YMAX1);
             }
        }
        else
        
        /* is it a scroll left command */

        if ( c == left ) {
            if ( xstart != 0 ) 
                 if ( (xstart - xdelta ) > 0 ) 
                      {xstart = xstart - xdelta; } else
                 xstart =0;
        iconify(ico,wid,XMAX1,YMAX1);
        } else

        
        /* is it a scroll right command */

        if ( c == right )  {
           if ((xstart + xdelta + XMAX1) < width ) {
               xstart = xstart + xdelta; }
           else
               xstart = width - XMAX1;
        iconify(ico,wid,XMAX1,YMAX1);
        } else
                
        
        /* is it a scroll down command */

        if ( c == down ){
            if ( ystart != 0 ) 
                 if ( (ystart - ydelta ) > 0 )
                      {ystart = ystart - ydelta; } else
                  ystart =0;
        iconify(ico,wid,XMAX1,YMAX1);
        } else
               
        
        /* is it a scroll up command */

        if ( c == up ){
           if ((ystart + ydelta + YMAX1) < height ) 
              { ystart = ystart + ydelta; }
           else
               ystart = height - YMAX1;
        iconify(ico,wid,XMAX1,YMAX1);
        } else


        if ( c == Mouse || c == F1 || c == F2 || c == F6 || c == F7) {
          b=0;
          if ( c == Mouse )
             wreadmouse(Wn,&x,&y,&b,&r);
        
          /* is it open or resume command */

          if ( b == 4 || c == F1 || c == F6) {
             uw = Puw;
             ioctl( Wn, WIOCSETD, &uw );
             ioctl(Wn, WIOCSETMOUSE, &mouse1);
             if ( (new_wind >= 0) || (new_wind1 >= 0))
                wrastop(Wn, Bitmap1, XMAXB, 0,0, 0,0, 0,0, XMAX
                               , YMAX, SRCSRC, DSTSRC, 0 );
             for ( i=0; i<6 ; i++) {
                 suti[i].ut_num=i;
                 ioctl(Wn,WIOCSETTEXT,&suti[i]);
             }
             fprintf(stderr, "\033[24;1H\033[=0C");
             /*fprintf(stderr, "\033[=0C");
             ioctl(0,LDSETT,argcb);*/
             if ( frk  == 1 ) {

                /* execute the user command */
                /* the suspend key sould be in effect */

                argg.c_cc[7] = 253;
                ioctl(0,TCSETA,&argg);
                frk = 0;
                if ( (pid=fork()) == 0 ) {

                   /* I should have no control over the window */
                   /* my parent should, Hmmmm  */

                   setpgrp();
                   
                   (void) signal ( SIGINT , intsig );
                   (void) signal ( SIGQUIT , quitsig );
                   (void) signal ( SIGUSR2 , SIG_IGN );
                   ptrace(0,0,0,0);
                   com1 +=optind;
                   execvp(com1[0],com1);
                   perror(com1[0]);
                   exit(2);
                 }
             } else {
                   argg2.c_cc[7] = 253;
                   ioctl(0,TCSETA,&argg2);
             }

             /* wakeup the daemon child */

             kill (pppid , SIGUSR2 );

             /* wakeup the executing child */

             if ( isig != 0 )
                ptrace(7, pid ,1,0);
wait_it:
             /* uuuuh, it is my turn to sleep */

             if ((wait(&statch)) == -1 ) {

             /* uuuuh, what is this noise? */

                  goto wait_it;
             } else {
             if  ( (statch & 0xff) != 0x7f ) {
                 isig = 0;
                 pid = -1;
                 frk = 1; } 
              else {
                 isig = statch >> 8;  
                 if ( isig != SIGUSR2 ) {

                    /* wakeup son, it is no time to sleep */

                    ptrace(7,pid,1,isig);
                    goto wait_it;
                  }
              }
              }

             /* Oh, I'm late..
                I should be working by now
             */

             ioctl(0,TCGETA,&argg2);
             ioctl( Wn, WIOCGETD, &Puw );
             for ( i=0; i<6 ; i++) {
                 suti[i].ut_num=i;
                 ioctl(Wn,WIOCGETTEXT,&suti[i]);
             }
             wcmd(Wn,0);
              
             /* set up function keys */
             if ( frk == 0 ) {
	     wslk(Wn, 0, "  RESUME   TOGGLE                                    B1 TO    B2 TO",
		    "           BORDER                                   RESUME    TOGGLE       "); } else
	     wslk(Wn, 0, "   OPEN    TOGGLE   EXIT                             B1 TO    B2 TO    B3 TO",
		    "           BORDER                                    OPEN     TOGGLE   EXIT");
             new_wind1 = wrastop(Wn, 0,0, Bitmap1, XMAXB, 0,0, 0,0, XMAX
                               , YMAX, SRCSRC, DSTSRC, 0 );
             ioctl(Wn,TCSETA,&argg1);
             keypad(0,1);
             ioctl(Wn, WIOCGETMOUSE, &mouse1);
             ioctl(Wn, WIOCSETMOUSE, &mouse);
             done = 0;
             bord_flag = 1;
             fprintf(stderr, "\033[=1C" );
             /*ioctl(0,LDGETT,argcb);*/

             iconify(ico,wid,XMAX1,YMAX1);
         
        } else
        
        /* is it toggle border command */

        if ( b == 2 || c == F2 || c == F7) {
            done = 0;
            if ( bord_flag )
               {bord_flag = 0;}
            else
               bord_flag = 1;
            iconify(ico,wid,XMAX1,YMAX1);
        } else

        if ( b == 1 )
        if ( frk == 1 ) {
             confirm();
             iconify(ico,wid,XMAX1,YMAX1);
       }
      }

           
    }
}


confirm()
{
int c,i,j,k,l;

   done=0;
   uw.uw_uflags = 0;
   uw.uw_height = 64;
   uw.uw_width = 140;
   ioctl( Wn, WIOCSETD, &uw );
   wlabel(Wn,"CONFIRM EXIT");
   wprompt(Wn,"Do you want to exit?             (Y/N  or  Enter/Cancel)");
   wcmd(Wn,"Touch Enter to continue          Cancel to STOP\n");
   c= wgetc(Wn);
   if( (c == Return) || (c == Enter) || 
       (c == 'y') || (c == 'Y') ) {
         wlabel(Wn,0);
         wprompt(Wn,0);
         wcmd(Wn,0);
         restore_window(1);
   }
   if (c == Mouse)
      wreadmouse(Wn,&i,&j,&k,&l);
      if ( k == 4 ) {
         wlabel(Wn,0);
         wprompt(Wn,0);
         wcmd(Wn,0);
         restore_window(1);
   }
   wlabel(Wn,0);
   wprompt(Wn,0);
   wcmd(Wn,0);
}


sendit(sig)
int sig;
{
    (void) signal ( sig , sendit );
    kill ( (0 - pid ) , sig );
}

closeit()
{
   (void) signal ( SIGUSR2 , closeit );
}
