/* xdump.c - make hex dumps */			char usage[]=

"Usage: %s [-f file] [-m shmid] [-M shmkey] [-b list] [-cxo]\n";  /*


-f file		: Dump file
-m shmid	: Dump shared memory segment, given id
-M shmkey	: Dump shared memory segment, given key
-b list		: Dump only bytes within list
-c		: Don't show char part
-x		: Don't show hex part
-o		: Copy input (file or sh. mem. segment)
		  to stdout. Dump goes to stderr.
<stdin>		  is taken as input if no -f, -m or -M option is present.

xdump -oxcM shmkey > file	: These copies a sh. mem. segment
xdump -oxcm shmid  > file	: to a file without any printed output

list could be -b0x10-0x30,0x50
	   or -b0-256
	   or -b0100-0200
and is used to constraint the dump to a range of the file or shmem.

xdump [options] file is equivalent to xdump [options] -f file.

The algorith used to dump ranges of the input is not very smart.

This program is copyrighted by Bjorn Engsig.  Permission is hereby granted
to copy, redistribute and use the program, provided only handling fees
are charged, and provided this copyright notice is included.

Bjorn Engsig, 15.11.88
*/
#define ONLY7BIT /* remove this for (simple) 8 bit support,
		    see also Isprint below */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <signal.h>
#include <ctype.h>
#include <fcntl.h>

#ifdef ONLY7BIT
#define Isprint(c) isprint(c)
#else
#define Isprint(c) (isprint(c&0x7f))
#endif ONLY7BIT

char optstring[] = "b:f:M:m:cxo";
char input, *name, *list;
unsigned char *line;
int nochar, nohex, swchar, swhex, pipeit;
int infile,byteno,bflag;
unsigned char  *address;
extern char *optarg;
extern int optind, opterr;

exithandle()
{ 
  exit(0);
}

openinput()
{
int shmid;
  switch (input) {
    case 'f':
      if ((infile=open(name,O_RDONLY))== -1) {
	perror("xdump: Cannot open file");
	exit(2);
      }
      break;
    case 'M':
      if ((shmid = shmget( strtol(name, (char **)0, 0), 0)) == -1) {
	perror("xdump: Cannot get shmid");
	exit(2);
      }
      goto Doshm;
      break;
    case 'm':
      shmid = strtol(name, (char **)0, 0);
    Doshm:
      if ((address = (unsigned char *)shmat(shmid,0,SHM_RDONLY))== (unsigned char *) -1) {
	perror("xdump: Cannot attach to shared memory");
	exit(2);
      }
      signal(SIGBUS,exithandle);
      signal(SIGSEGV,exithandle);
      break;
    case 0: /* stdin */
      input='f';
      infile=0;
      break;
    }
}

getline()
{
  static unsigned char buf[18];
  switch(input) {
    case 'f':
      line=buf;
      return read(infile,buf,16);
    break;
    case 'm':
    case 'M':
      line=(address+=16);
      return 16;
    break;
  }
}

inrange(bn)
  int bn;
{
  char *end;
  static int lower= -1,upper= -1;
  if (bn<lower)
    return 0;
  if (bn>=lower && bn<=upper)
    return 1;
  if (*list) {
    lower=strtol(list,&end,0);
    list=end+1;
    if (*end==',' || *end==(char) 0) {
      upper=lower;
    } else
    if (*end=='-') {
      upper=strtol(list,&end,0);
      list=end+(!! *end);
    }
    lower &= 0xfffffff0;
    upper &= 0xfffffff0;
    if (bn>=lower && bn<=upper)
      return 1;
  } else
    if (bflag) exit(0); /* ugly exit on end of list */
  return 0;
}

showline(out,count)
  FILE *out;
{
  unsigned char outline[74];
  int i,pc;
  if (nochar && nohex) {
    pc = line[0]; /* to provoke buserror */
    return;
  }
  if (list && ! inrange(byteno)) {
    byteno+=count;
    return;
  }
  sprintf(outline,"%6x  ",byteno);
  if (!nohex) {
    for (i=0; i<count; i++)
      sprintf(strchr(outline,0),"%.2x ",line[i]);
    for (   ; i<16   ; i++)
      strcat(outline,"   ");
    }
  strcat(outline,"  ");
  if (!nochar) {
    for (i=0; i<count; i++) {
      pc = line[i];
      if (!Isprint(pc))
	pc = '.';
      sprintf(strchr(outline,0),"%c",pc);
    }
    for (   ; i<16   ; i++)
      strcat(outline," ");
    }
  fprintf(out,"%s\n",outline);
  byteno+=count;
}

main(ac,av)
  int ac;
  char *av[];
{
  int opt,error,count;
  error=0;
  while ((opt=getopt(ac,av,optstring))!=EOF)
    switch (opt) {
    case 'f':
    case 'm':
    case 'M':
      if (input) error=2;
      input=opt;
      name=optarg;
    break;
    case 'b':
      if (list) error=2;
      list=optarg;
      bflag++;
    break;
    case 'o':
      pipeit=1;
    break;
    case 'c':
      nochar=1;
    break;
    case 'x':
      nohex=1;
    break;
    default:
      error=1;
  }
  if (optind<ac) {
    if (input) error=2;
    input='f';
    name=av[optind];
  }
  switch (error) {
    case 2:
      fprintf(stderr,"%s: illegal option use\n",av[0]);
    case 1:
      fprintf(stderr,usage,av[0]);
      exit(1);
  }
  openinput();
  signal(SIGQUIT,exithandle);
  while (count=getline()) {
    if (pipeit) {
      showline(stderr,count);
      write(1,line,count);
    } else
      showline(stdout,count);
  }
}

  
