/*********************************************************/
/*                                                       */
/* setrowandcol: sets up the row and column field of the */
/* pin list entry based on the pin orientation, width,   */
/* pincount and (row1,col1).                             */
/*                                                       */
/*********************************************************/

#include "wirewrap.h"

setrowandcol(thispin)
struct pin *thispin;
{
int width,row1,col1,pinsrow,pincount;
/*
** Pick up width, (row1,col1), and pincount for this chip.
*/
width = (thispin -> mychip) -> width;
row1 = (thispin -> mychip) -> row1;
col1 = (thispin -> mychip) -> col1;
pincount = (thispin -> mychip) -> pincount;
/*
** Process SIPs (single inline packages).  These are entered as 
** having a width of zero.  All other chips are assumed to be
** DIPs (dual inline packages).
** An n pin SIP has n pins per row.  An n pin DIP has n/2 pins per row.
*/
if(width == 0)
  pinsrow = pincount;
else
  pinsrow = pincount/2;
/*
** Following is the calculation of row and column numbers for each
** of the four orientations.
*/
switch ((thispin -> mychip) -> orientation)
  {
  case 1: if(thispin -> pinnum > pinsrow)
             {
             thispin -> row = row1 + width;
             thispin -> col = col1 + pincount - thispin -> pinnum;
             }
           else
             {
             thispin -> row = row1;
             thispin -> col = col1 + thispin -> pinnum - 1;
             }
           break;
  case 2 : if(thispin -> pinnum > pinsrow)
             {
             thispin -> row = row1 + pincount - thispin -> pinnum;
             thispin -> col = col1 - width;
             }
           else
             {
             thispin -> row = row1 + thispin -> pinnum - 1;
             thispin -> col = col1;
             }
           break;
  case 3 : if(thispin -> pinnum > pinsrow)
             {
             thispin -> row = row1 - width;
             thispin -> col = col1 - pincount + thispin -> pinnum;
             }
           else
             {
             thispin -> row = row1;
             thispin -> col = col1 - thispin -> pinnum + 1;
             }
           break;
  case 4 : if(thispin -> pinnum > pinsrow)
             {
             thispin -> row = row1 - pincount + thispin -> pinnum;
             thispin -> col = col1 + width;
             }
           else
             {
             thispin -> row = row1 - thispin -> pinnum + 1;
             thispin -> col = col1;
             }
  }
}
