/**********************************************
*  getwired - do the wire routing.            *
*					      *
*    When getwired is called, the signal list *
*  is sorted in order by signalname.  This    *
*  routine connects adjacent pins with the    *
*  same signal name together.  Pins are conn- *
*  nected together with either top to top     *
*  wraps or bottom to bottom wraps everywhere.*
*  The last wrap may really be wrapped as a   *
*  top to bottom wrap if there is an odd num- *
*  ber of pins in the string.  But it is still*
*  represented as a top to top wrap.	      *
**********************************************/

#include "wirewrap.h"

getwired()
{
int indexlo,indexhi,count,i;
char currentsignal[NAMELENGTH];
indexhi = 0;
while(indexhi < nextfree)
  {
  indexlo = indexhi;
  indexhi = indexhi + 1;
  for(i=0;i<NAMELENGTH;i++)
    currentsignal[i] = pinarray[indexlo].signalname->signalname[i];
  while((indexhi < nextfree) && 
         !namecmp(pinarray[indexhi].signalname->signalname,currentsignal)
        )indexhi++;
  if(namecmp(currentsignal,NULLSIGNAL))
    { 
    count = indexlo;
    while(count < indexhi-1)
      {
      pinarray[count].inner = count+1;
      pinarray[count+1].inner = count;
      count = count + 2;
      }
    count = indexlo + 1;
    while(count < indexhi-1)
      {
      pinarray[count].outer = count+1;
      pinarray[count+1].outer = count;
      count = count + 2;
      }
    }
  }
}
