/*******************************************************
*  Batcher's method sort by signalname.		       *
*  Reference: Knuth Sorting & Searching, Section 5.2.2 *
*******************************************************/

#include "wirewrap.h"

sort1()
{
struct pin tempin;
int p,q,r,d,n,i,j,m;

/*Find the 'middle' of the array.*/
n = nextfree;
i = 1;
j = 2;
while(j < n)
  {
  i = j;
  j = j+j;
  }
m = i;  /*m is the middle of the array*/
        
/* Batcher's method*/
p = m;
while(p > 0)
  {
  q = m;
  r = 0;
  d =p;
  for(;;)
    {
    for(i= 0;i < n-d;i++)
      {
      if ( (i&p) == r)
        if(namecmp(pinarray[i].signalname->signalname,
           pinarray[i+d].signalname->signalname)>0)
          {
          tempin = pinarray[i+d];
          pinarray[i+d] = pinarray[i];
          pinarray[i] = tempin;
          }
      }
      if(p != q)
        {
        d = q - p;
        q = q/2;
        r = p;
        }
      else 
        break;
    }
  p = p/2;
  }
}
