#include "wirewrap.h"

output3()
{
double wirelength,getwirelength();
int longctr, i, len, total, ctr[21];

/* Zero out counters */

        longctr = 0;
        for(i=2;i<=20;i++)ctr[i]=0;
        
/* Print heading. */

        printf("\014");
        printf(" WIRE LENGTH SUMMARY\n");
        printf(" -------------------\n");
        printf("\n");
        printf(" Wire   Number\n");
        printf("Length   Used\n");
        
/* Wire counting loop. */
        
        for(i=0; i<nextfree;i++)
        {
        
        /* Count inner wire length*/
        
                if( (pinarray[i].inner != -1) &&
                (!pinarray[i].signalname->special) )
                  {
                  wirelength=getwirelength(pinarray[i].row,pinarray[i].col,
                                pinarray[pinarray[i].inner].row,
                                pinarray[pinarray[i].inner].col);
                  len=wirelength / 0.5 + 0.1;
                  if(len > 20)
                    longctr++;
                  else
                    ctr[len]++;
                  }
        
        /* Count outer wire length*/
                
                if( (pinarray[i].outer != -1 ) &&
                (!pinarray[i].signalname->special) )
                  {
                  wirelength=getwirelength(pinarray[i].row,pinarray[i].col,
                                pinarray[pinarray[i].outer].row,
                                pinarray[pinarray[i].outer].col);
                  len=wirelength / 0.5 + 0.1;
                  if(len > 20)
                    longctr++;
                  else
                    ctr[len]++;
                  }
        }

        /* Only count each wire once. */
                for(i=2;i<=20;i++)ctr[i]=ctr[i]/2;
                longctr=longctr/2;
        
        /* Make listing. */
        
                for(i=2;i<=20;i++)
                  {
                  if(ctr[i] > 0)
                     {
		     printf("%-9.1f %d\n",(.5*i),ctr[i]);
                     }
                  }
        if(longctr > 0)
          {
          printf("> 10.0 %d\n",longctr);
          }
        
        /* Total up how many wires used. */
        
        total=0;
        for(i=2;i<=20;i++)total+=ctr[i];
        total += longctr;
        printf("Total number of wires used: %d\n",total);
}
