#include <ctype.h>
#include <stdio.h>
#include "wirewrap.h"
/*
** gettoken - return a whitespace delimited token.
**            Tokens are truncated at 79 characters.
**	      Return code is zero if a token is
**	      returned, otherwise an end of file
**	      was reached and -1 is returned.
*/
gettoken(token)
char *token;
{
char chr;
int tokenptr;
static int firsttime=1;
static int nextchr;
int comment;
tokenptr=0;
token[tokenptr]=0;
comment=0;

/* If first time through, get a look-ahead character. */

if(firsttime == 1)
  {
  nextchr=getchar();
  firsttime=0;
  }

for(;;)
  {
  /* Get a character from the input. */

  if(nextchr == EOF)
    chr=EOF;
  else
    {
    chr=nextchr;
    nextchr=getchar();
    }

  /* Test if start of a comment. */

  if(chr == '/' && nextchr == '*')
    {
    nextchr = getchar();
    comment = 1;
    continue;
    }

  /* Test if end of a comment. */

  if(chr == '*' && nextchr == '/' && comment == 1)
    {
    nextchr=getchar();
    comment=0;
    continue;
    }

  /* Test if EOF within a comment. */

  if(chr == EOF && comment == 1)break;

  /* Test if a newline char within a comment. */

  if(chr == '\n' && comment == 1)
    {
    inputline++;
    continue;
    }

  /* Test if any other character within a comment. */

  if(comment == 1)continue;
    
  /* Process end of file. */

  if(chr == EOF)break;

  /* Process white space character. */

  if(isspace(chr))
    {

    /* Process new line character. */
    if(chr == '\n')
      {
      if(tokenptr != 0)

        /* Process new line character which terminates a token */

        ungetc(chr,stdin);
      else

        /* Process a new line character which does not terminate a token */

        inputline++;
      }

  /* Process any white space character that terminates a token */

    if(tokenptr != 0) return(0);

  /* Process a white space character that doesn't terminate a token */

    else continue;
    }
  else

  /* Process a non white space charater */

    if(tokenptr<79)
      {

      /* Process a non white space charater before the 79'th char of a token */

      token[tokenptr]=chr;
      tokenptr++;
      token[tokenptr]=0;
      }
    else

      /* Process a non white space character after the 79'th char of a token */

      continue;
  }

/* Process end of file */

if(tokenptr==0)return(-1);else return(0);
}
