/***********************************************************/
/*                                                         */
/*  wirewrap: Wirewrap PC board Routing and documentation  */
/*            generation system                            */
/*                                                         */
/***********************************************************/

#include <stdio.h>
#define minlength 1.5
#define pinpart 0.626
#define lengthfactor 1.01674
#define numpins 1500     /* Maximum number of pins program can handle */
#define NAMELENGTH 12    /* Number of chars in a signal name, chip name,
                            or a chip position. */
/* Following token definitions must be at least NAMELENGTH bytes long */
#define NULLSIGNAL    ".            "
#define CHIPTOKEN     ":CHIP        "
#define SPECIALTOKEN  ":SPECIAL     "

/* Important structures used throughout the program */

struct signallist           /* One entry for every signal */
  {
  char signalname[NAMELENGTH];
  struct signallist *succ;
  char special;
  }*siglistleader;

struct chip                /* One entry for every chip */
  {
  char name[NAMELENGTH];
  char position[NAMELENGTH];
  unsigned int pincount, width, row1, col1, orientation;
  struct chip *succ;
  }*chipleader;

struct pin                  /* One entry for every pin */
  {
  struct signallist *signalname;
  struct chip *mychip;
  unsigned int pinnum;
  unsigned int row,col;
  int inner,outer;
  }*pinptr;

/* Global variables */

struct pin pinarray[numpins];  /* Used pin list */
int nextfree;                  /* Index of next free entry in the pin list */
int linenum;                   /* Line number within the page that the output
                                  listing is at */
int inputline;		       /* Line number in the input file. */
/* #define DEBUG  /* Turns on extra debugging output. */
