#include "wirewrap.h"
#include <ctype.h>
#define GETLINE(A) { scanf("%79[^\n]%*[^\n]%*c",A); inputline++;}
#define PAD(A) {for(j=strlen(A);j<NAMELENGTH;j++)A[j]=' '; A[NAMELENGTH]=0; }
extern char *cnvtnump; /* Defined in cmvtnump.c */
extern int *cnvtnumv; /* Defined in cmvtnump.c */
int errorlevel=0;
/*
** readin - read in the chip description file.
**
** Sorry about all the gotos.  This is a finite
** state machine.
*/

/* getcmd - try to get a command from the input stream.
** Branches to: 
**   endinput     if eof occurs.
**   dochip       if a :chip command occurs.
**   dospecial    if a :special command occurs.
**   getcmd       if anything else occurs.
*/
readin()
{
struct chip *newchip;
struct signallist *setptr(),*localptr;
char token[80],errorline[132];
int count,i,j,stat,found;

getcmd:
  stat=gettoken(token);
  if(stat == -1) goto endinput;
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      PAD(token);
      if(!namecmp2(token,CHIPTOKEN))
        goto dochip;
      if(!namecmp2(token,SPECIALTOKEN))
        goto dospecial;
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  sprintf(errorline,"Invalid item: %15.15s",token);
  error(errorline);
  goto getcmd;

/* dochip - Processes a :chip command.
** Branches to:
**   endinput     if eof occurs.
**   dochip       if a :chip command occurs.
**   dospecial    if a :special command occurs.
*/
dochip:
  stat=gettoken(token); /* Trying to get a chip name. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      PAD(token);
      if(!namecmp2(token,CHIPTOKEN))
        {
        sprintf(errorline,"Duplicate :chip command");
        error(errorline);
	goto dochip;
        }
      if(!namecmp2(token,SPECIALTOKEN))
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        goto dospecial;
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  if(strlen(token) > NAMELENGTH)
    {
    sprintf(errorline,"Chip name is too long: %15.15s",token);
    error(errorline);
    }
  PAD(token);
  /* Allocate a new chip. */
  newchip = (struct chip *) malloc( sizeof(struct chip));
  if(!newchip)
    {
    sprintf(errorline,"No space for chip: %15.15s",token);
    fatal(errorline);  /* No return */
    }
  /* Fill in the chipname field. */
  PAD(token);
  for(i=0;i<NAMELENGTH;i++)newchip->name[i]=token[i];

  stat=gettoken(token); /* Trying to get a chip position. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      PAD(token);
      if( !namecmp2(token,CHIPTOKEN) )
        {
        error("The rest of the preceeding :chip command is missing");
        goto dochip;
        }
      if( (!namecmp2(token,SPECIALTOKEN)) || (!namecmp2(token,CHIPTOKEN)) )
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  if(strlen(token) >= NAMELENGTH)
    {
    sprintf(errorline,"Chip position name is too long: %15.15s",token);
    error(errorline);
    }
  PAD(token);
  for(i=0;i<NAMELENGTH;i++)newchip->position[i]=token[i];

  stat=gettoken(token); /* Trying to get a pincount. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      if( !namecmp2(token,CHIPTOKEN) )
        {
        error("The rest of the preceeding :chip command is missing");
        goto dochip;
        }
      if( (!namecmp2(token,SPECIALTOKEN)) || (!namecmp2(token,CHIPTOKEN)) )
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        goto dospecial;
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  i=cnvtnum(token);
  newchip->pincount=i;
  if(!cnvtnumv)
    {
    sprintf(errorline,"Invalid pin count specified: %15.15s",token);
    error(errorline);
    }
  else if(*cnvtnump != 0)
    {
    sprintf(errorline,"Pin count field is badly formatted: %15.15s",token);
    error(errorline);
    }
  else if(i < 0)
    {
    sprintf(errorline,"Pin count field is negative: %15.15s",token);
    error(errorline);
    }
  else if(i < 0)
    {
    sprintf(errorline,"Pin count field is zero.");
    error(errorline);
    }

  stat=gettoken(token); /* Trying to get a chip width. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      if( !namecmp2(token,CHIPTOKEN) )
        {
        error("The rest of the preceeding :chip command is missing");
        goto dochip;
        }
      if( (!namecmp2(token,SPECIALTOKEN)) || (!namecmp2(token,CHIPTOKEN)) )
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        goto dospecial;
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  i=cnvtnum(token);
  newchip->width=i;
  if(!cnvtnumv)
    {
    sprintf(errorline,"Invalid width specified: %15.15s",token);
    error(errorline);
    }
  else if(*cnvtnump != 0)
    {
    sprintf(errorline,"Width field is badly formatted: %15.15s",token);
    error(errorline);
    }
  else if(i < 0)
    {
    sprintf(errorline,"Width field is negative: %15.15s",token);
    error(errorline);
    }

  stat=gettoken(token); /* Trying to get pin 1's row number. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      if( !namecmp2(token,CHIPTOKEN) )
        {
        error("The rest of the preceeding :chip command is missing");
        goto dochip;
        }
      if( (!namecmp2(token,SPECIALTOKEN)) || (!namecmp2(token,CHIPTOKEN)) )
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        goto dospecial;
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  i=cnvtnum(token);
  newchip->row1=i;
  if(!cnvtnumv)
    {
    sprintf(errorline,"Invalid row specified: %15.15s",token);
    error(errorline);
    }
  else if(*cnvtnump != 0)
    {
    sprintf(errorline,"Row field is badly formatted: %15.15s",token);
    error(errorline);
    }

  stat=gettoken(token); /* Trying to get pin 1's column number. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      if( !namecmp2(token,CHIPTOKEN) )
        {
        error("The rest of the preceeding :chip command is missing");
        goto dochip;
        }
      if( (!namecmp2(token,SPECIALTOKEN)) || (!namecmp2(token,CHIPTOKEN)) )
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        goto dospecial;
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  i=cnvtnum(token);
  newchip->col1=i;
  if(!cnvtnumv)
    {
    sprintf(errorline,"Invalid col specified: %15.15s",token);
    error(errorline);
    }
  else if(*cnvtnump != 0)
    {
    sprintf(errorline,"Col field is badly formatted: %15.15s",token);
    error(errorline);
    }

  stat=gettoken(token); /* Trying to get pin 1's orientation number. */
  if(stat == -1)
    {
    error("End of file reached too soon.");
    goto endinput;
    }
  if(token[0] == ':')
    {
    if(strlen(token) <= NAMELENGTH)
      {
      if( !namecmp2(token,CHIPTOKEN) )
        {
        error("The rest of the preceeding :chip command is missing");
        goto dochip;
        }
      if( (!namecmp2(token,SPECIALTOKEN)) || (!namecmp2(token,CHIPTOKEN)) )
        {
        sprintf(errorline,
           "The rest of the preceeding :chip command is missing:",
           token);
        error(errorline);
        goto dospecial;
        }
      }
    sprintf(errorline,"Invalid command: %15.15s",token);
    error(errorline);
    goto getcmd;
    }
  i=cnvtnum(token);
  newchip->orientation=i;
  if(!cnvtnumv)
    {
    sprintf(errorline,"Invalid orientation specified: %15.15s",token);
    error(errorline);
    }
  else if(*cnvtnump != 0)
    {
    sprintf(errorline,"Orientation field is badly formatted: %15.15s",token);
    error(errorline);
    }
  else if(i < 1 || i > 4)
    {
    sprintf(errorline,
            "Orientation must be either 1, 2, 3, or 4:  %15.15s",token);
    error(errorline);
    }

  for(count=0; count < newchip->pincount; count++)
    {
    stat=gettoken(token); /* Trying to get a chip name. */
    if(stat == -1)
      {
      sprintf(errorline,"Not enough signal names read in for chip %12.12s.",
              newchip->name);
      goto endinput;
      }
    if(token[0] == ':')
      {
      if(strlen(token) <= NAMELENGTH)
        {
        if(!namecmp2(token,CHIPTOKEN))
          {
          sprintf(errorline,
                  ":chip command occured before all signals were read in.");
          error(errorline);
          }
        if(!namecmp2(token,SPECIALTOKEN))
          {
          sprintf(errorline,":special command occured before all signals were read in.");
          goto dospecial;
          }
        }
      sprintf(errorline,"Invalid command: %15.15s",token);
      error(errorline);
      goto getcmd;
      }
    PAD(token);
    if(strlen(token) != NAMELENGTH)
      {
      sprintf(errorline,"Signal name is too long: %5.15s",token);
      error(errorline);
      }
    PAD(token);
    if(nextfree >= numpins)
      {
      sprintf(errorline,"Too many pins, maximum is %d : %15.15s",numpins,token);
      error(errorline);
      }
    pinarray[nextfree].signalname = setptr(token);
    pinarray[nextfree].mychip=newchip;
    pinarray[nextfree].pinnum=count+1;
    pinarray[nextfree].inner = -1;
    pinarray[nextfree].outer = -1;
    setrowandcol(&pinarray[nextfree]);
    nextfree = nextfree + 1;
    }

  for(;;)
    {
    stat=gettoken(token); /* Trying to get any excess signal names. */
    if(stat == -1) goto endinput;
    if(token[0] == ':')
      {
      if(strlen(token) <= NAMELENGTH)
        {
        PAD(token);
        if(!namecmp2(token,CHIPTOKEN))
          goto dochip;
        if(!namecmp2(token,SPECIALTOKEN))
          goto dospecial;
        }
      sprintf(errorline,"Invalid command: %15.15s",token);
      error(errorline);
      goto getcmd;
      }
    sprintf(errorline,"More signals than pins on chip %12.12s : %15.15s"
          ,newchip->name,token);
    error(errorline);
    }

dospecial:
/* 
** dospecial - Processes a :special command.
** Branches to:
**   getcmd
**   dospecial
**   endinput
**   dochip
*/
stat=gettoken(token);
if(stat == -1) goto endinput;
if(token[0] == ':')
  {
  if(strlen(token) <= NAMELENGTH)
    {
    if(!namecmp2(token,CHIPTOKEN))
      {
      error(":CHIP statements must not follow :special statements");
      goto dochip;
      }
    if(!namecmp2(token,SPECIALTOKEN))
      {
      error("Duplicate :SPECIAL command.");
      goto dospecial;
      }
    }
  sprintf(errorline,"Invalid command: %15.15s",token);
  error(errorline);
  goto getcmd;
  }
if(strlen(token) > NAMELENGTH)
  {
  sprintf(errorline,"Special name is too long: %15.15s",token);
  error(errorline);
  goto dospecial;
  }
found=0;
localptr=siglistleader;
PAD(token);
while((localptr != 0) && (!found))
  {
  if(namecmp2(localptr->signalname,token))
    localptr = localptr->succ;
  else
    {
    localptr->special=1;
    found=1;
    }
  }
if(!found)
  {
  sprintf(errorline,"Special signal is never used: %12.12s",token);
  error(errorline);
  }
goto dospecial;

/*
** endinput - end of input processor.
*/
endinput: ;
  if(errorlevel != 0)
    {
    printf("Errors were detected.  Program terminated.\n");
    exit(9);
    }
  return;
}
error(s)
char *s;
{
errorlevel=1;
printf("Error, Line %d, %s\n",inputline,s);
linenum++;
}
fatal(s)
char *s;
{
errorlevel=1;
printf("Fatal, Line %d, %s\n",inputline,s);
printf("Error was fatal, Program terminated\n");
exit(10);
}
