/* unit_table.h - Copyright 1987 - Gregory R. Simpson */
/* subject to the same conditions outlined in u.c's copyright */

/* ************ a table of the form: ************** 

    struct of_units {
           char  *name;        Name of Unit 
           float value;        Value - Initially set to 0 
           float conversion;   Conversion factor to Primary Unit 
           int   counter;      Number of units in this group 
    } 

The primary unit is the first unit listed in the unit group.
Always include an even number of entries in the group even
if this means that the last entry is blank. Then, set the
number of entries to the correct odd number...this is to
handle displays correctly... For example, see the mass
entry below.

There are currently: 196 unit conversion in 21 catagories.

20 Length, 15 Mass, 6 Speed, 18 Volume, 14 Area, 5 Density, 12 Time,
5 Force, 20 Energy, 12 Pressure, 6 Plane Angles, 10 Power, 6 Electric Charge
6 Magnetic Induction, 12 Light, 4 Thermal Conductivity, 4 Coeff. of Heat
Transfer, 6 Viscosity, 8 Cooking volumes, 8 Computer Media.

************************************************** */

#define MAXGROUP 23       /* Maximum Number of Unit Groups - 1 */

static char *unitype[MAXGROUP+2] = {
	              "Length"                , "Mass"               
              ,  "Speed"                 , "Volume"    
	           ,  "Area"                  , "Density"   
              ,  "Time"                  , "Force"     
              ,  "Energy/Heat/Work"      , "Pressure"  
              , "Angle"                  , "Power"               
              , "Electric Charge"        , "Magnetic Induction"
              , "Light"                  , "Thermal Conductivity"
              , "Coeff of Heat Transfer" , "Heat Flux"           
              , "Viscosity"              , "Cooking Volumes"
              , "Computer Media"

/* Temperature, Prefix, and Constants are always the last 3 
   Add New Unit Types above this point. */
		      
	           , "Temperature"          , "Prefix List"  
              , "Constants"            , " "         
	      };

struct of_units {
       char  *name;         /* Name of Unit */
       double value;        /* Value - Initially set to 0 */
       double conversion;   /* Conversion factor to Primary Unit */
       int   counter;       /* Number of units in this group */
}
unit[30][20] = {
       {
              {"feet",0,1,20},                      /* length */
              {"inches",0,12,20},
              {"yards",0,.33333333,20},
              {"centimeters",0,30.48,20},
              {"meters",0,.3048,20}, 
              {"kilometers",0,3.048e-04,20},
              {"statute miles",0,1.894e-04,20},
              {"nautical miles",0,1.6457925e-04,20},
              {"par-secs",0,9.8827862e-18,20},
              {"light-years",0,3.2218301e-17,20},
              {"mils",0,12000.,20},
              {"microns",0,304800.,20},
              {"millimicrons",0,3.048e08,20},
              {"angstroms",0,3.048e09,20},
              {"x-units",0,3.048e12,20},
              {"rods",0,.060606,20},
              {"fathoms",0,.16666667,20},
              {"chains",0,.00151515,20},
              {"ropes (Brit.)",0,.05,20},
              {"furlongs",0,1.51515e-03,20}
       },
       {
              {"pounds (avdp.)",0,1,15},                    /* mass */
              {"grams",0,453.59237,15},
              {"kilograms",0,.45359237,15},
              {"tons (short)",0,5.0e-04,15},
              {"tons (long)",0,.00044642857,15},
              {"tons (metric)",0,.00045359237,15},
              {"pennyweights",0,291.6666,15},
              {"scruples (apoth)",0,350,15},
              {"drams (apoth/troy)",0,116.6666,15},
              {"drams (avdp.)",0,256.0,15},
              {"amus",0,2.732e26,15},
              {"ounces (avdp.)",0,16,15},
              {"stones",0,.0714285,15},
              {"grains",0,7000.0,15},
              {"slugs",0,.0310810,15},
              {"",0,0,15}
       },
       {
              {"m/sec",0,1,6},                     /* speed */
              {"ft/sec",0,3.2808399,6},
              {"ft/min",0,196.85039,6},
              {"km/hr",0,3.6,6},
              {"km/min",0,.06,6},
              {"cm/sec",0,100,6},
              {"knots",0,1.944,6},
              {"miles/hr",0,2.2369363,6}
       },
       {
              {"cubic meters",0,1,18},                          /* Volume */
              {"cubic cms",0,1e06,18},
              {"liters",0,1000,18},
              {"gallons (U.S. Liq)",0,264.17205,18},
              {"gallons (Brit.)",0,219.9694,18},
              {"quarts (U.S. Liq)",0,1056.6882,18},
              {"quarts (Brit.)",0,879.87753,18},
              {"pints (U.S. Liq)",0,2113.3764,18},
              {"cubic feet",0,35.314667,18},
              {"cubic inches",0,6.102374e04,18},
              {"barrels (U.S. liq)",0,8.3864145,18},
              {"barrels (U.S. dry)",0,8.648490,18},
              {"barrels (Brit.)",0,6.110261,18},
              {"hogsheads",0,4.1932072,18},
              {"boardfeet",0,8786880.,18},
              {"acre-feet",0,.00081071319,18},
              {"cords",0,4519.68,18},
              {"steres",0,1.0,18}
       },
       {
              {"square meters",0,1,14},                          /* Area */
              {"square kilometers",0,1.0e-6,14},      
              {"square cms",0,1e04,14},
              {"square miles",0,3.8610216e-07,14},
              {"square feet",0,10.76,14},
              {"square inches",0,1550,14},
              {"sq. links (Gunter)",0,24.710538,14},
              {"sq. links (Ramden)",0,10.763910,14},
              {"square mm",0,1e06,14},
              {"square rods",0,.039536861,14},
              {"sq. perches (Brit)",0,.039536861,14},
              {"hectares",0,.0001,14},
              {"circular mills",0,1.974e09,14},
              {"acres",0,2.4710538e-04,14}
       },
       {
              {"kg/m3",0,1,5},                          /* Density */
              {"slug/ft3",0,1.940e-03,5},
              {"gm/cm3",0,.001,5},
              {"lb/ft3",0,6.243e-02,5},
              {"lb/in3",0,3.613e-05,5},
              {"",0,0,5}
       },
       {
              {"days",0,1,12},                          /* Time */
              {"years",0,2.738e-03,12},
              {"month",0,.0328767,12},
              {"week",0,.1428571,12},
              {"hours",0,24,12},
              {"minutes",0,1440,12},
              {"seconds",0,8.640e04,12},
              {"decades",0,2.738e-04,12},
              {"score",0,1.369e-04,12},
              {"centuries",0,2.738e-05,12},
              {"millenia",0,2.738e-06,12},
              {"fortnights",0,.0714285,12}
       },
       {
              {"newtons",0,1,5},                          /* Force */
              {"dynes",0,1e05,5},
              {"pounds",0,.2248,5},
              {"gram-force",0,102.0,5},
              {"kilogram-force",0,.1020,5},
              {"",0,0,5}
       },
       {
              {"btus",0,1,20},                          /* Energy */
              {"btus (Int.Stm.Tab.)",0,.999346,20},
              {"btus (mean)",0,.998563,20},
              {"ergs",0,1.05435e10,20},
              {"ft-lbs",0,777.649,20},
              {"hp-hr",0,3.92752e-04,20},
              {"Joules",0,1054.35,20},
              {"Joules (int.)",0,1054.18,20},
              {"Watt-sec",0,1054.35,20},
              {"Watt-sec (int.)",0,1054.18,20},
              {"calories",0,251.99576,20},
              {"calories (I.S.T)",0,251.831,20},
              {"calories (mean)",0,251.634,20},
              {"kilowatt-hours",0,2.92875e-04,20},
              {"kilowatt-hours int",0,2.92827e-04,20},
              {"electron volts",0,6.585e21,20},
              {"MeV",0,6.585e15,20},
              {"liter-atm",0,10.4053,20},
	           {"tons of refrig",0,3.46995e-06,20},
              {"kg-m",0,107.514,20}
       },
       {
              {"atmospheres",0,1,12},                  /* Pressure */
              {"dynes/cm2",0,1.01325e06,12},
              {"inches of water",0,406.8,12},
              {"cms Hg",0,76.,12},
              {"torr",0,760.,12},
              {"mms Hg",0,760.,12},
              {"inches Hg",0,29.92126,12},
              {"lbs/in2",0,14.6960,12},
              {"lbs/ft2",0,2116,12},
              {"newtons/m2",0,1.01325e05,12},
              {"bars",0,1.01325,12},
              {"pascals",0,1.01325e05,12}
       },
       {
              {"degrees",0,1,6},                          /* Plane Angles */
              {"minutes",0,60,6},
              {"seconds",0,3600,6},
              {"radians",0,1.745e-02,6},
              {"revolutions",0,2.77777778e-03,6},
              {"quadrants",0,.0111111,6}
       },
       {
              {"btus/hour",0,1,10},                          /* Power */
              {"ft-lbs/min",0,12.97,10},
              {"ft-lbs/sec",0,.2161,10},
              {"horsepower",0,3.929e-04,10},
              {"kilowatts",0,2.930e-04,10},
              {"watts",0,.292875,10},
              {"calories/sec",0,7.000,10},
              {"ergs/sec",0,2.928751e06,10},
              {"lb. ice melted/hr",0,.0069714,10},
              {"tons of refrig.",0,8.32789e-05,10}
       },
       {
              {"coulombs",0,1,6},                        /* Electric Charge */
              {"abcoulombs",0,.1,6},
              {"amp-hrs",0,2.778e-04,6},
              {"faradays",0,1.036e-05,6},
              {"statcoulombs",0,2.998e9,6},
              {"electron charges",0,6.2414181e18,6}
       },
       {
              {"Gauss",0,1,6},                      /* Magnetic Induction */
              {"kilolines/in2",0,6.452e-03,6},
              {"Webers/m2",0,1e-04,6},
              {"Tesla",0,1e-04,6},
              {"gamma",0,1e05,6},
              {"Maxwells/sq.cm",0,1,6}
       },
       {
              {"Footlamberts",0,1,12},                          /* Light */
              {"Nit",0,.2919,12},
              {"Millilamberts",0,.929,12},
              {"Candelas/in2",0,452,12},
              {"Candelas/ft2",0,3.142,12},
              {"Candelas/m2",0,.2919,12},
              {"Stilb",0,2919,12},
              {"lumens/ft2",0,1,12},
              {"foot-candles",0,1,12},
              {"lux",0,10.763190,12},
              {"lumens/m2",0,10.763190,12},
              {"Milliphots",0,1.0763190,12}
       },
       {
              {"Btu/(hr-ft2-F/ft)",0,1,4},          /* thermal conductivity */
              {"gm-cal/(sec-cm2-C/cm)",0,.004134,4},
              {"watts/(cm2-C/cm)",0,.01731,4},
              {"kg-cal/(hr-m2-C/m)",0,1.488,4}
       },
       {
              {"Btu/hr-ft2-F",0,1,4},     /* coeff. of heat trans. */
              {"gm-cal/sec-cm2-C",0,.0001355,4},
              {"watts/cm2-C",0,.0005678,4},
              {"kg-cal/hr-m2-C",0,4.882,4}
       },
       {
              {"Btu/hr-ft2",0,1,4},                          /* heat Flux */
              {"gm-cal/sec-cm2",0,.00007535,4},
              {"watts/cm2",0,.0003154,4},
              {"kg-cal/hr-m2",0,2.712,4}
       },
       {
              {"Centipoises",0,1,6},             /* viscosity */
              {"lb/sec-ft",0,.000672,6}, 
              {"lb force-sec/ft2",0,.0000209,6},
              {"lb/hr-ft",0,2.42,6},
              {"kg/hr-m",0,3.60,6},
              {"grams/cm-sec",0,.01,6}
       },       
       {
              {"teaspoons",0,1,8},             /* cooking volumes */
              {"tablespoons",0,.33333333,8}, 
              {"cups",0,.0208333,8},
              {"pints",0,.0104166,8},
              {"quarts",0,5.2083333e-03,8},
              {"gallons",0,1.3020833e-03,8},
              {"fluid ounce",0,.1666666,8},
              {"jigger",0,.11111111,8}
       },
       {
              {"bytes",0,1,8},             /* computer media */
              {"kilobytes",0,9.765625e-04,8}, 
              {"megabytes",0,9.765625e-07,8},
              {"blocks",0,1.953125e-03,8},
              {"360K Floppies",0,2.7126736e-06,8},
              {"1.2 Meg Floppies",0,8.1380208e-07,8},
              {"1.44 Meg Floppies",0,6.781684e-07,8},
              {"20 Meg Hard Disk",0,4.8828125e-08,8}
       },
};

