/* un.c -  A Units Conversion Program

   Written 1/17/87 
   Updated 1/09/89,1/23/89 

*/

/*
        Copyright 1987,1988,1989 Gregory R. Simpson

UUCP:  uunet!steinmetz!ltd2.decnet!simpsong
ARPA:  simpsong%ltd2.decnet@crd.ge.com
AT&T:  (216)-381-6789

	This notice and any statement of authorship must be reproduced
	on all copies.  The author does not make any warranty expressed
	or implied, or assumes any liability or responsiblity for the
	use of this software.

	Any distributor of copies of this software shall grant the
	recipient permission for further redistribution as permitted
	by this notice.	 Any distributor must distribute this software
	without any fee or other monetary gains, unless expressed written
	permission is granted by the author.

	This software or its use shall not be: sold, rented, leased,
	traded, or otherwise marketed without the expressed written
	permission of the author.

	If the software is modified in a manner creating derivative
	copyrights, appropriate legends may be placed on derivative
	work in addition to that set forth above.

	Permission is hereby granted to copy, reproduce, redistribute or
	otherwise use this software as long as the conditions above
	are meet.

	All rights not granted by this notice are reserved.

 (This copyright notice was written by, Kurt Zeilenga (zeilenga@hc.dspo.gov)
  thanks Kurt... -greg)

*/
/* This program is for Unit Conversion... */

#include "un.h"

/*
struct of_units {
       char  *name;         Name of Unit 
       double value;        Value - Initially set to 0 
       double conversion;   Conversion factor to Primary Unit 
       int   counter;       Number of units in this group 
} 
*/

#include "unit_table.h"

/* ------------ main program ------------ */

main(argc, argv)
int argc;
char *argv[];
{
       int   group, user_unit, counter, unit_counter, sameunit;
       int   comp_unit, ref_unit, chart, screen;
       double user_value, from_value, to_value, temp_value, value, increment;
       double primary;
       char c[10], *cfile, chartfile[100];
       FILE *fpchart;

       /* default values */

       group      = 1;
       user_unit  = 1;
       user_value = 1; 

       sameunit   = 0;  /* New Unit Group */
       chart      = 0;  /* Default is standard conversion */

       /* check for chart option */

       if (argc > 2)   /* usage message if extra command line arguments */
       {
          usage();
       } else if (argc > 1) {
          if ( argv[1][0] == '-' ) {
             if ( argv[1][1] == 'C' || argv[1][1] == 'c' ) {
                chart = 1;
             } else {
                usage();
             }
          } else {
            usage();
          }
       }
       while(True)        /* loop forever... */
       {
           if ( sameunit == 0 ) 
           {
              Clear;
              printf("                Unit Group Selection\n");
              printf("-------------------------------------------------------------\n");

	      for (counter = 0; counter <= MAXGROUP; counter = counter+2)
              {
                     printf("%2d. %-22s                   %2d. %-22s\n",
                     (counter + 1), unitype[counter], 
                     (counter + 2), unitype[counter + 1]);
              }

              printf("              Enter 'q' at anytime to (Q)uit\n");
              printf("---------------------------------------------------(C)grs----\n");


              printf("Which Type of Unit? ");
              getinteger(&group, MAXGROUP);
              group = group - 1;   /* since array starts at 0 */
              
              unit_counter = unit[group][1].counter - 1;
        
           } /* end of sameunit if */

              switch (group)
              {
                 case MAXGROUP-2:
                          temperature();
                          sameunit = 0;
                          break;
		 case MAXGROUP-1:
                          prefix();
                          sameunit = 0;
                          break;
                 case MAXGROUP:
                          constants();
                          sameunit = 0;
                          break;
                 default:

              Clear;
              printf("                     Unit Selection\n");
              printf("-------------------------------------------------------------\n");
              for (counter = 0; counter <= unit_counter; counter = counter+2)
              {
                     printf("%2d. %-18s                       %2d. %-18s\n",
                     (counter + 1), unit[group][counter].name, 
                     (counter + 2), unit[group][counter + 1].name);
              }
              printf("              Enter 'q' at anytime to (Q)uit\n");
              printf("-------------------------------------------------------------\n");

/* --------------------   Standard Unit Conversion   ----------------  */

              if (chart == 0) {

                     printf("Your Unit? ");
                     getinteger(&user_unit, unit_counter);
                     user_unit = user_unit - 1;

                     printf("\nHow many %s ? ", unit[group][user_unit].name );
                     getnumber(&user_value, unit_counter);

                     Clear;
                     printf("\n     ============================================================\n");

                     primary=user_value*(1/unit[group][user_unit].conversion);

                     printf("     %16.8g %s is equivalent to:\n",
                     user_value, unit[group][user_unit].name);
                     printf("     ------------------------------------------------------------\n");
                     for (counter = unit_counter; counter >= 0; counter--) 
                     {
                            if (counter != user_unit) 
                            {
                                   unit[group][counter].value = 
                                   primary * unit[group][counter].conversion;
                                   printf("                  %16.8g %-18s\n",
                                   unit[group][counter].value,
                                   unit[group][counter].name);
                            }
	             }
                     printf("     ============================================================\n");
                     action(&sameunit, &chart);
              } 

/* ---------------------  Chart Option   --------------------- */

              else {    

                     printf("\nYour Reference Unit?  ");
                     getinteger(&ref_unit, unit_counter);
                     ref_unit = ref_unit - 1;
                     printf("Your Comparison Unit? ");
                     getinteger(&comp_unit, unit_counter);
                     comp_unit = comp_unit - 1;

                     printf("\nFrom How Many %s?  ", unit[group][ref_unit].name);
                     getnumber(&from_value);
                     printf("To How Many %s?    ", unit[group][ref_unit].name);
                     getnumber(&to_value);
                     printf("By what increment? ");
                     getnumber(&increment);

                     screen = 0;
                     printf("\nFilename for chart? (<CR> for screen): ");
                     cfile = gets(chartfile);
                     if (cfile[0] == '\0') {
                        fpchart = stdout;
                        screen  = 1;
                     } 
                     else if ( ( fpchart = fopen(cfile,"a") ) == NULL ) {
                        fprintf(stderr, "Can't open Chartfile.");
                        exit(1);
                     }                      

                     Clear;
 
                     /* ----- Error Checking and Correction... ----- */

                     if ( from_value > to_value )
                     {
                        fprintf(fpchart,
                        "Your From value is Greater than your To value.\n");
                        fprintf(fpchart,"Therefore, I swapped them.\n");
                        temp_value = from_value;
                        from_value = to_value;
                        to_value   = temp_value;
                     }
                     if ( increment < 0 )
                     {
                       fprintf(fpchart,
                       "Since your From value is Less than your To value,\n");
                       fprintf(fpchart,
                       "I will make your increment positive.\n");
                       increment = -increment;
                     }

                     fprintf(fpchart,
"------------------------------------------------------------------------------\n");

                     for (value = from_value; value <= to_value; 
                          value = value + increment) 
                         {
                           primary=value*(1/unit[group][ref_unit].conversion);
                            unit[group][comp_unit].value = 
                             primary * unit[group][comp_unit].conversion;
                             fprintf(fpchart,
                             "| %16.8g %-18s | %16.8g %-18s |\n",
                             value,unit[group][ref_unit].name,
                             unit[group][comp_unit].value,
                             unit[group][comp_unit].name);
                             fprintf(fpchart,
"------------------------------------------------------------------------------\n");
                     }
                     if (screen == 0) {
                         fclose(fpchart);
                     }
                     action(&sameunit, &chart);
              } /* end of chart if else */
          } /* end of switch */
       } /* end of while */
} /* ---- end of main program ---- */
