/* tklex.h - defines for tklex package
 *
 * 27.Jul.87  jimmc  Initial definition
 * 18.Jan.88  jimmc  Move definition of TkInfo into this file from tklex.c
 */

/* Token types */
#define TkEOF (-1)
#define TkOParen '('
#define TkCParen ')'
#define TkString '"'
#define TkNumber '9'
#define TkSymbol 'S'

typedef int (*INTFUNCPTR)();

typedef struct _TkInfo {
/* All values in this structure are private to the Tk routines;
 * the definition is included in this file only to allow the structure
 * pointer to be used in the TkHandle typedef.
 */
	char *filename;	/* name of input file */
	FILE *f;	/* input file pointer */
	int lineno;	/* input line number (for error messages) */
	int pushedtoken;	/* allow one token pushback */
	char *pbchars;	/* pushed back characters */
	int pballoc;	/* number of bytes allocated in pbchars */
	int pbindex;	/* index into pbchars */
/* If there are no chars pushed back, pbindex==pballoc; each time a char
 * is pushed back, pbindex is decremented; each time one is read, it is
 * incremented.  Thus, the pushback characters in pbchars are stored
 * at the end of the pbchars array; printing pbchars[pbindex] will
 * print the current push-back string.
 * An extra null character is always left on the end (not counted in
 * pballoc) so that this can be done (for debugging).
 */
	int stringalloc;	/* size of stringvalue buffer */
	int stringcount;	/* number of chars used (not including null) */
	char *stringvalue;	/* where we store the string values */
/* The stringvalue buffer is used to collect strings which will later
 * be returned to the caller.
 */
} TkInfo;

typedef TkInfo *TkHandle;

/* Routines */
extern TkHandle TkInit();
extern int  TkDone();
extern int  TkGet();		/* get next token */
extern int  TkNumberValue();	/* get value of token when TkNumber */
extern char *TkStringValue();	/* get value of token when TkString */
extern INTFUNCPTR TkSetFatalHandler();	/* set handler for errors */
extern INTFUNCPTR TkSetFatalHandler();	/* set handler for errors */

/* end */
