/* plotX.c - plot routines specific to X
 *
 * 30.Jul.87  jimmc  Initial definition
 *  1.Aug.87  jimmc  Add PXText, remove PXBox (use default), change PXInit
 * 12.Aug.87  jimmc  Add XCear in Init
 * 17.Aug.87  jimmc  Add dummy textsize function
 * 19.Aug.87  jimmc  Simplify text function
 * 26.Jan.88  jimmc  Change path to X include files
 *  1.Mar.88  jimmc  Add ifdef X10
 */

#ifdef X10

#include <X/Xlib.h>
#include <X/Xproto.h>
#include "plot.h"

#define NULL 0

#define FIXY(y) (y) = (PXwinfo.height-(y));

extern char *index();

extern char *Progname;

static int PXcolor;
static int PXop;
static int PXplanes;
static Window PXw;
static WindowInfo PXwinfo;
static char *PXFontname = "6x10";
static FontInfo *PXFontInfo;

#define PXdefwidth 100
#define PXdefheight 100

static OpaqueFrame PXframe = {
	0,		/* window ID */
	0,0,		/* origin */
	0,0,		/* size */
	1,		/* border width */
	0,0		/* border and background pixmaps */
};

static PXOpenWindow()
{
	PXcolor = 1;
	PXop = GXcopy;
	PXplanes = AllPlanes;
	if (!XOpenDisplay(NULL)) {
		printf("Can't open X display\n");
		return 0;
	}
	PXframe.border = WhitePixmap;
	PXframe.background = BlackPixmap;
	PXw = XCreate(Progname,Progname,"","=840x600+20+20",
		&PXframe,PXdefwidth,PXdefheight);
	if (!PXw) {
		printf("Can't open window\n");
		return 0;
	}
	XStoreName(PXw,Progname);
	XMapWindow(PXw);

	PXFontInfo = XOpenFont(PXFontname);
	if (PXFontInfo==0) {
		printf("Can't open font %s",PXFontname);
		return 0;
	}

	return 1;
}

/* ARGSUSED */
int		/* 1 if OK */
PXInit(filename,lxp,lyp,hxp,hyp)
char *filename;		/* we ignore this arg */
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	if (!PXw) {	/* need a window */
		if (!PXOpenWindow()) {
			return 0;
		}
	}
	XClear(PXw);
	XQueryWindow(PXw,&PXwinfo);
	*lxp = 0;
	*lyp = 0;
	*hxp = PXwinfo.width-1;
	*hyp = PXwinfo.height-1;
	XFlush();
	return 1;
}

PXDone()
{
	XFlush();
}

/* ARGSUSED */
PXTextSize(x,y)
int x,y;
{
	return;		/*** We are ignoring text size at the moment */
}

PXLine(lx,ly,hx,hy)
int lx,ly,hx,hy;
{
	FIXY(ly)
	FIXY(hy)
	XLine(PXw,lx,ly,hx,hy,1,1,PXcolor,PXop,PXplanes);
}

PXText(x,y,text)
int x,y;	/* lower left corner of text */
char *text;
{
	FIXY(y)
	y -= PXFontInfo->height;
	XTextMaskPad(PXw,x,y,text,strlen(text),PXFontInfo->id,
		0,0,PXcolor,PXop,PXplanes);
}

PXSetup()
{
PDevInfo *p;

	p = Pnew();
	p->name = "X";
	p->init = PXInit;
	p->done = PXDone;
	p->line = PXLine;
	p->text = PXText;
	p->textsize = PXTextSize;
}

#else
static char dummy;	/* avoid "empty symbol table" message */
#endif X10

/* end */
