/* network.h - definition of the network (typically a tree) structure.
 *
 * 28.Jul.87  jimmc  Initial definition
 *  1.Aug.87  jimmc  Add text stuff in Nbox
 *  2.Aug.87  jimmc  Add path stuff
 * 12.Aug.87  jimmc  Add boxname and netname to conn
 * 14.Aug.87  jimmc  Add stuff to rows, nets; add tracks
 * 19.Aug.87  jimmc  Add label
 *  3.Nov.87  jimmc  Add rowdir, modify Npoint
 * 27.Jan.88  jimmc  Add FEEDTHROUGH flag
 */

/* parflag bits */
#define ROWSET  (1<<0)	/* this bit set if the row has been set */
#define ORDERSET (1<<1)	/* this bit set if the order in row has been set */
#define BOXROW  (1<<2)	/* for rows, this bit set if a row of boxes */
#define SPANSET (1<<3)	/* for tracks, indicates a span has been set */
#define POSITIONSET (1<<4) /* for boxes, when position within row is set */
#define FEEDTHROUGH (1<<5) /* for boxes, indicates a feedthrough net */

typedef struct _Npoint {	/* a point or vector value */
	int cc[2];	/* x and y */
#define X cc[0]		/* normal coords */
#define Y cc[1]
} Npoint;

typedef struct _Ngroup { /* for dynamically allocated arrays of thingies */
	int count;	/* number of entries used */
	int alloc;	/* number of entries allocated */
	union {
		struct _Nnet  **net;
		struct _Nbox  **box;
		struct _Nconn **conn;
		struct _Nrow  **row;
		struct _Ntrack **track;
		struct _Ngroup **path;
		struct _Npoint *pt;	/* this one is a bit different */
		int *n;
		char * *x;	/* untyped version of data */
	} d;
} Ngroup;

typedef struct _Nconn {	/* one connector (terminal) */
	char *name;		/* name of the connector */
	char *boxname;		/* name of the box (used before linking) */
	struct _Nbox *box;	/* pointer to box owning this connector */
	Npoint pos;		/* position of this connector wrt box */
	Npoint apos;		/* absolute position of this connector */
	int side;		/* which side of the box (N,S,E,W)*/
#define N 0
#define S 1
#define E 2
#define W 3
	char *netname;		/* name of net (used before linking) */
	struct _Nnet *net;	/* the net attached to this connector */
} Nconn;

typedef struct _Nbox {	/* a box */
	char *name;	/* name of this box */
	Npoint size;	/* size of the box */
	Npoint origin;	/* origin (lower left corner) */
	char *text;	/* text within the box */
	Npoint text_origin;	/* origin of text relative to origin of box */
	int text_opos;	/* where the text origin is wrt the text (see plot.h) */
	int rownum;	/* number of the row this box is in */
	struct _Nrow *row;	/* row containing this box */
	int rowpos;	/* relative position of this block in that row */
	Ngroup connlist;	/* associated connectors */
	int parflags;		/* flags used during place/route */
} Nbox;

typedef struct _Nnet {	/* one net (wire, polyline) */
	char *name;	/* name of the net */
	Ngroup connlist;	/* associated connectors */
	struct _Ngroup pathlist;	/* a set of paths */
	int rownum;	/* number of the row this net is in */
	struct _Nrow *row;	/* row containing this net */
	int rowpos;	/* position within that row */
	int minpos,maxpos;	/* span of the net within the row */
	struct _Ntrack *track;
	int parflags;		/* flags used during place/route */
	int angle;
} Nnet;

typedef struct _Ntrack {	/* one track within a channel */
	int parflags;
	Ngroup netlist;		/* list of nets in this track (from which
				 * we can determine the used ranges) */
	int n;			/* track index number in channel */
	int pos;		/* track position */
} Ntrack;

typedef struct _Nrow {	/* one placement row */
	int rownum;	/* the number for this row */
	int size;	/* size of this row (typically the small dimension) */
	int length;	/* length (typically the larger dimension) */
	int pos;	/* position of the row */
	Ngroup boxlist;	/* boxes which are in this row */
	Ngroup netlist;	/* nets which are in this row */
	int rowposmin, rowposmax;	/* for relative position of boxes */
	Ngroup tracklist;	/* set of tracks within a channel */
	int parflags;
} Nrow;

typedef struct _Nlabel {
	char *s;		/* the label string */
	Npoint tsize;		/* size of the label in chars */
	Npoint origin;		/* lower left corner of the label */
} Nlabel;

typedef struct _Nbase {	/* the handle for everything */
	Ngroup netlist;
	Ngroup boxlist;
	Ngroup connlist;
	Ngroup rowlist;
	int maxrowlength;	/* length of the longest row */
/* global parms */
	Npoint textsize;
	int interrowspace;	/* default space between rows */
	int rowposspace;	/* mon space between boxes in a row */
	int trackspace;		/* space between routing tracks */
	Nlabel label;		/* label for the whole thing */
	int rowdir;		/* 'V'ertical or 'H'orizontal */
} Nbase;

/* end */
