/* main program for treepar
 *
 * 28.Jul.87  jimmc  Initial definition
 * 14.Aug.87  jimmc  Add place and route stuff
 * 22.Sep.87  jimmc  Define F macro in this file
 * 17.Oct.87  jimmc  Convert to use spin interface
 * 27.Jan.88  jimmc  Add RFeed command
 *  5.Feb.88  jimmc  Moved some routines into misc.c
 */

#include <stdio.h>
#include "xalloc.h"

extern char *rindex();

char *treeparVersion = "treepar v1.1 1.Mar.88";

char *Progname;

main(argc,argv)
int argc;
char *argv[];
{
int i,j;
char *execval=0;

	Progname = rindex(argv[0],'/');
	if (Progname) Progname++; else Progname=argv[0];

	PSetup();	/* init the plot drivers */
	applinit();

	SPinitsubs();

	for (i=1; i<argc; i++) {
		if (argv[i][0]=='-') for (j=1; j>0 && argv[i][j]; j++) {
			switch (argv[i][j]) {
			case 'e':	/* execute */
				if (argv[i][++j]) execval = argv[i]+j;
				else if (++i<argc) execval = argv[i];
				else fatalerr("not enough args for -e");
				j = -1;
				break;
			default:
				fatalerr("unknown switch %c", argv[i][j]);
			}
		}
		else {	/* not a switch */
			fatalerr("unknown argument %s", argv[i]);
		}
	}

	if (execval) { SPmainstring(execval); }
	SPmainfile(stdin);
	exit(0);
}

/*
 * arg types are:
 * i - integer
 * s - string
 * f - float (double)
 * L - list
 * 
 * define function as F(funcname,"argstr")
 * The first char of argstr is the return type
 */

#define F(fnamez,argsz) {\
	extern fnamez();\
	SPdeffunc("fnamez",argsz,fnamez);\
}

#define FS(fnamez,argsz) {\
	extern char *fnamez();\
	SPdeffunc("fnamez",argsz,fnamez);\
}

applinit()
{
/* routines to read and write the tree text files */
F(NRead,"is");
F(NWrite,"is");
F(NPlot,"iS\"X\"S\"stdout\"");
F(NPlot4,"iS\"X\"S\"stdout\"");
F(NPlotXY,"iS\"X\"S\"stdout\"I2I2");
F(PSetWindow,"vdddd");

/* place and route routines */
F(RSelect,"iSN"); /* select rows for boxes and nets */
F(RUnFeed,"i");	/* undo any feedthroughs */
F(RFeed,"i");	/* generate feedthroughs for nets which span rows */
F(RReFeed,"i");	/* UnFeed and Feed */
F(RSpace,"i");	/* generate row datastructs and size them */
F(ROrder,"iSN");	/* order the boxes within each row */
F(RPosition,"i");	/* position boxes within the rows */
F(RRoute,"i");	/* do the channel route */
F(Rpar,"iSN"); /* do all of the place and route stuff */
F(RReFeedpar,"iSN"); /* do RReFeed and the rest */
F(RSpacepar,"iSN"); /* do RSpace and the rest */

/* misc routines */
FS(TFlags,"ss");	/* set and get random flags */
FS(TVersion,"s");	/* returns the current version string */

/* routines for debugging the lexical analyzer */
F(TkDebugFile,"is");
}

/* end */
