.\" treepar.1
.TH TREEPAR 1 " 1 March 1988"
.SH NAME
treepar \- A place and route (and plot) program for tree-structure data

.SH SYNOPSIS
.br
treepar [-e <commands>]

.SH DESCRIPTION
.I Treepar
is a program which does automatic placement and routing of tree-structured
data.
It reads and writes files in a textual format
and knows how to plot to a few different kinds of devices.
The place, route, and plot steps are split out into a number of
small steps, which makes it possible to tweak the results of one
step before proceeding to the next.
This is done by writing out a text file, modifying it, reading it
back in and continuing the place and route steps where they were left off.
.LP
Treepar is intended for tree-structure data where each node in the
tree has an arbitrary number of ancestors and descendants, and each
node has associated with it a block of text.
It was originally written specifically to produce family trees of various
kinds, but can be used for anything else which shares those characteristics.
The
.I geneal
genealogy program can produce output in treepar format for plotting
family trees.
.LP
Treepar will handle arbitrary network-structure data, but may not
make a very nice looking plot.
It will insert feedthroughs where necessary, but is not particularly
intelligent about where in the row a feedthrough should go.
.LP
Treepar uses the
.I spin
interpreter as a front end.
Control of treepar is accomplished by entering simple or complex commands
to the spin interpreter, which parses and executes them.
Whenever a treepar command is encountered, it is executed.
Given an understanding of the the spin interpreter and a list of the
treepar functions, the full capabilities of treepar are available.
The list of treepar functions is described below.

.SH SWITCHES
.LP
There is only one command line switch, which is the
.I -e
switch.
The argument to this switch is a fragment of spin code to be executed.
This code fragment can contain any valid commands.
When the execution is done, commands are then read from standard input.
Typically the argument to the -e switch is a compound command which
executes the desired function and then exits.
Here's an example of how the -e switch might be used:
.LP
.nf
.DS
% treepar -e '(NRead "foo.tf")(Rpar)(NPlot HPA "foo.hpa")(quit)'
.DE

.SH ENVIRONMENT
.LP
Treepar uses the following environment variables:
.TP
.B HPPENNUM
When creating an HP plot file, this environment variable controls the
number of the pen used in the SP (select pen) command.
By default, it is 1.
.TP
.B DISPLAY
Used by the X plot driver to determine what screen to display on.

.SH KEY CONCEPTS
.LP
Treepar reads data from a text file.
The data describes a set of boxes, connectors, and nets.
Each box has a size, some text inside it, and some connectors.
Each connector is associated with a net and a box.
Each net is associated with a set of connectors.
.LP
Treepar uses a channel assignment and routing approach.
The place and route algorithms are optimized for
appearance, not for size.
Optimizing for appearance is rather subjective, so treepar has been
designed to make it easy to modify the layout of the boxes at any
point during the place and route process.
How to do this is discussed below in the function grouping describing
the place and route functions.
.LP
Treepar examines the connectivity of the boxes and assigns a
"generation" number to each box.
The intent is that boxes with the same generation number will all come
out in the same row (or column, as determined by the row direction setting).
This is appropriate for things like family trees.
.LP
The generation number is calculated by counting hops from the root.
The number is either incremented or decremented depending on the
direction that a connector leaves a box,
and which direction it enters another box.
The direction of a connector is determined
by the side of the box which the connector is on.
Connectors must all be on the north and south edges of a box if
rows are horizontal, or on the east and west edges if rows are vertical.
Thus
if a hop moves out of box A on a south connector and into box B
on a north connector, the generation number of B is one more than
the generation number of A.
If a hop moves out of box A on a north connector and into box B
on a south connector, the generation number of B is one less than A.
If a hop moves out of box A on a north connector and into box B
on a north connector, box B will have the same generation number as A.
.LP
When routing, the primary goal is to minimize the number
of crossed lines.
In a strict tree, it is always possible to generate a placement and
routing which contains no line crossings;
however, treepar is not guaranteed to find the appropriate placement
unless the root of the tree is specified to the placement routine.
.LP
The placement and routing
algorithms in treepar will work for arbitrary networks,
but since they are based on the concept of generation numbers, they
are strongly affected by which node is selected as the root.
The routing algorithm will insert feedthroughs into rows as required
in order to route from one channel to another, but may not put the
feedthroughs in the best location.
You may want to write out a text file and make some modifications
to the placement.

.SH FUNCTIONS
.LP
All of the treepar functions take as operands either integers, strings, or
floats;
all functions return either an integer, a string, or a float.
In the descriptions below, these three types of data are indicated by
the letters i, s, and d (double) appended to the operand name.
A type of I means an optional integer argument.
A type of S means an optional string argument.

.LP
File input and output routines:
.TP
.B NRead filename.s
Reads in a file in treepar format (see the section FILE FORMAT).
Returns 0 if no errors reading the file.
.TP
.B NWrite filename.s
Writes out a file in treepar format (see the section FILE FORMAT).
Returns 0 if no errors writing the file.

.LP
Place and route routines:
.LP
The place and route routines are normally executed in the order they
are documented here.
This is done by the Rpar command (given near the end of this list),
so normally only that command needs to be executed.
The commands are split up to allow tweaking to be done.
If you don't like the way one of the algorithms is working, you
can modify its output before proceeding.
For example, if you run Rpar and decide you want more space between
the boxes in a row, you can rerun RSelect and RSpace, then write out a file
with NWrite, edit it, read it back with NRead, and finish by executing
ROrder, RPosition, and RRoute.
.TP
.B RSelect boxname.S
Determines (selects) which row each box and net belongs to
(calculates the generation numbers).
The argument is used to determine which box to start the ordering
from.
For any singly-connected network (or tree)
data, this argument should not affect
the row selection.
.TP
.B RUnFeed
Removes any existing feedthroughs.
.TP
.B RFeed
Inserts feedthroughs as necessary.
Does not remove old feedthroughs first.
.TP
.B RReFeed
Calls RUnFeed then RFeed.
.TP
.B RSpace
Generates the row datastructures and sizes them.
.TP
.B ROrder boxname.S
Orders the boxes within each row.
The argument is used to determine which box to start the ordering
from.
For simple trees, the boxname is normally given as the root of the tree.
.TP
.B RPosition
Positions the boxes within the rows.
.TP
.B RRoute
Does the channel route.
.TP
.B Rpar boxname.S
Does all of the place and route steps:
RSelect, RReFeed, RSpace, ROrder, RPosition, and RRoute.
The boxname is passed through to the called functions which take a boxname
argument.
For simple trees, the boxname is normally given as the root of the tree.
.TP
.B RReFeedpar boxname.S
Does all of the place and route steps from ReFeed on.
The boxname is passed through to the called functions which take a boxname
argument.
For simple trees, the boxname is normally given as the root of the tree.
.TP
.B RSpacePar boxname.S
Does all of the place and route steps from RSpace on.
The boxname is passed through to the called functions which take a boxname
argument.
For simple trees, the boxname is normally given as the root of the tree.

.LP
Plotting routines:
.TP
.B NPlot dev.S file.S
Generates a plot of the data.
The default device is "X", which plots to the X server.
For devices which output to files, such as HPA, the file argument
is the name of the file to output to.
The special names "stdout" and "stderr" refer to the streams of those names.
The default is stdout.
The file argument is ignored if the device is X.
Available devices are listed below.
.TP
.B NPlotXY dev.S file.S xcount.I ycount.I
Generates a multi-page plot of the data.
The dev and file arguments are treated the same as in Nplot.
The xcount and ycount arguments specify the number of slices in
that dimension.
Thus using 3 for both will produce 9 pages of output.
The pages are each put into separate files, where the string _%d_%d is
appended to the specified filename, with the %d's replaced by the x
and y values (0 based) of that piece.
The default values of xcount and ycount are 2.
.TP
.B PSetWindow lx.d ly.d hx.d hy.d
Sets the window coordinates.
This can be used to pick out a particular region to be plotted by the
NPlot command.

.LP
Miscellaneous:
.TP
.B TFlags newflags.s
Sets or clears flags, according to the first character in the string.
The return value is a string which is a list of the flags which are
set after the execution of the command.
If the first character is a "+", each remaining character in the string
is considered a flag character and is set.
If the first character is a "-", each remaining character in the string
is considered a flag character and is cleared.
If the first character is a "=",
all flags are cleared, then each remaining character in the string
is considered a flag character and is set.
If the first character is a "?", no operation is performed, but
the current list of flags which are set is returned as a string.
If the first character is a "h", a help message is printed.
A list of the flags and what they control is given below.
.TP
.B TVersion
Returns a string which is the current version string for treepar.

.SH PLOT DEVICES
.LP
The following plot devices are supported:
.TP
.B X
The X Window system, Version 10.4.
The normal DISPLAY environment variable mechanism can be used to
display on remote screens.
The filename argument to Nplot is ignored.
.TP
.B HP?
Where ? is one of [ABCDE], such as "HPA" or "HPD".
Generates a file with HP plot commands.
The letter [ABCDE] is the paper size to generate commands for.
.TP
.B HP?R
Where ? is one of [ABCDE], such as "HPAR".
Like HP?, but generates commands for a rotated plot.
This device should be used when the picture is taller than it is wide.
.TP
.B TEST
Outputs a short text string for each plotting command.
This is used for debugging.
.TP
.B SIZE
Outputs a message about the scaled size of the picture.
This is used to determine the aspect ratio of the picture.
It can be used to determine whether HP? or HP?R should be used,
without having to plot the picture anywhere first.

.SH FLAGS
.LP
There are a number of flags which control various output options.
These flags are set by the function TFlags, described above.
The current state of the flags can be examined with the command
(TFlags "?").
A help message describing what the flags do is printed by the command
(TFlags h).
The flags and their function are:
.TP
.B c
Enables plotting of connectors on boxes (i.e. they will be specifically
marked on the plot).
Each connector is marked by an X.
Also output absolute connector positions in text files.
This is normally used for debugging.
.TP
.B f
Enables plotting of feedthrough box positions.
Each feedthrough is marked by an X.
This is normally used for debugging.
.TP
.B l
Enables plotting of box names.
This flag is normally only set when the T flag is also set.
.TP
.B m
Memory debugging.
When set, calls to free memory don't do anything.
.TP
.B T
Disables the printing of the text associated with each box.
Using +Tl is useful for seeing the names of boxes so that one
can be picked as an argument for the Rpar command.

.SH FILE FORMAT
.LP
At the lowest level, a treepar file consists of a series of text records.
Each text record consists of from zero to two keywords followed by
a set of values in parentheses.
The values can be either integers or strings.
String values are enclosed in double quotes, with C style escapes
for special characters.
.LP
At the next level up, there are two kinds of records: schema definitions
and data records.
.LP
A schema definition record has two keywords, where the first is the
name of the type of record being defined, and the second is the word
"schema".
Enclosed in the parentheses are an arbitrary number of strings, each of
which defines the name and type of one of the fields in that schema.
This is represented as the string "name.t", where name is the field
name and t is either an i for integer values or an s for string values.
.LP
A data record normally has one keyword, which is the name of the record
type, followed by the data in parentheses.
Each item of data in the parentheses must match the corresponding item
in the schema definition as to type.
The number of data items in the data record must be the same as in the
schema definition for that data type.
.LP
If a data record has no keyword, then it is assumed to be a data record
of the same type as the previous data record or schema definition.
This is a simple shorthand to reduce the number of keywords required
in the file.
.LP
The data types used in treepar are
globals, box, conn (connector), row, net,
path, and endpath.
Each one has a set of fields associated with it which are used by
treepar.
The order of the fields does not matter.
Extra fields are ignored.
Not all record types are required, and not all fields in any given
record type are required.
Many of the values are computed during the place and route process.
An example text file below shows a minimal text file.
.LP
There is only one globals data record, which has the following fields:
.TP
.B textsizex.i
The width of each character.
.TP
.B textsizey.i
The height of each character.
.TP
.B interrowspace.i
The amount of space to put between each row.
.TP
.B rowposspace.i
The amount of space to put between each box within a row.
.TP
.B trackspace.i
The amount of space to put between each routed line.
.TP
.B rowdir.s
"H" for horizontal rows, "V" for vertical rows.
.TP
.B label.s
A label for the overall plot.
.LP
A box record has the following fields:
.TP
.B name.s
The name of the box.
This is reference by connector records.
.TP
.B sizex.i
The width of the box.
.TP
.B sizey.i
The height of the box.
.TP
.B orgx.i
The x position of the lower left corner of the box.
.TP
.B orgy.i
The y position of the lower left corner of the box.
.TP
.B text.s
The text to go into the box.
This text may contain newlines (using C syntax, i.e. backslash-n).
.TP
.B textx.i
The x position of the text relative to the lower left corner of the box.
.TP
.B texty.i
The y position of the text relative to the lower left corner of the box.
.TP
.B textpos.s
Indicates which part of the text is to be placed at the point given by
the textx and texty values.
Textpos is one of the eight compass points (e.g. "N" or "SE"), or "C"
for center.
.LP
A conn record has the following fields:
.TP
.B boxname.s
The name of the box this connector is associated with.
.TP
.B name.s
The name of this connector on that box.
.TP
.B x.i
The x position of the connector relative to the lower left corner of
the box.
.TP
.B y.i
The y position of the connector relative to the lower left corner of
the box.
.TP
.B ax.i
The absolute x position of the connector.
.TP
.B ay.i
The absolute y position of the connector.
.TP
.B side.s
The side of the box the connector is on.
This string is one of the four compass points (e.g. "N" or "E").
.TP
.B netname.s
The name of the net this connector is associated with.
.LP
For a full place and route, row records are not required.
A row record has the following fields:
.TP
.B rownum.i
The index number of the row.
.TP
.B size.i
The size of the row (in the typically short dimension).
.TP
.B pos.i
The position of the row
(y location of the row if row direction is horizontal).
.LP
For a full place and route, records are not required.
A net record has the following fields:
.TP
.B name.s
The name of the net.
This name is referred to by connectors.
.TP
.B rownum.i
The row number which the net is in.
.LP
Path records are for specifying the path of a net.
A path record applies to the most recently preceding net record.
A path is actually specified as a series of path records, each of
which is just a point value.
A path record has the following fields:
.TP
.B x.i
The x position of a point in the path.
.TP
.B y.i
The y position of a point in the path.
.LP
An endpath record has no fields.
It is used to terminate one path before starting another path on a net.
This is only required when the path for a net is not a simple
multiline.

.SH SAMPLE DATA FILE
.LP
Here is a very small text file which illustrates the use of some of
the record types.
This is all the information which is required in order to do
a full place and route.
Note that there are no net records or row records, and various
fields are missing out of the box and connector records.
These values are generated during the place and route process.
.LP
.nf
.DS
globals schema ("textsizex.i" "textsizey.i" "rowposspace.i"
      "rowdir.s" "trackspace.i" "interrowspace.i" "label.s")
globals (6 10 20 "V" 20 30 "Sample Data File")

box schema ("name.s" "sizex.i" "sizey.i"
      "text.s" "textx.i" "texty.i" "textpos.s")
conn schema ("boxname.s" "name.s" "x.i" "y.i"
      "side.s" "netname.s")

box ("I74" 84 60 "Strauss\\n\\
=======\\n\\
[74] Hirsch\\n\\
 b: ca 1850?\\n\\
" 6 50 "NW")
conn ("I74" "i74" 72 23 "E" "i74")
conn ("I74" "i80" 0 50 "W" "i80")

box ("I80" 60 50 "Levi\\n\\
====\\n\\
[80] Ben\\n\\
" 6 40 "NW")
conn ("I80" "i80" 54 13 "E" "i80")
.DE

.SH BUGS
.LP
The routing algorithm sometimes does not notice when two connectors
on opposites sides of a routing channel are directly across from
each other but not on the same net;
it may generate lines which overlap.
A workaround is to output a text file, modify the positions of the boxes,
and finish the place and route with RRoute.
.LP
Connectors which are not on an appropriate side (for example, an East
connector when row direction is horizontal) may cause strange results.
