/* tfile.h
 *
 * 18.Jan.88  jimmc  Created by removing from tfile.c
 */

#define MAXARGS 12	/* max number of args to a setup function */

typedef int (*IFP)();

typedef struct _TFfiledef {	/* one field as defined in the file */
	struct _TFfiledef *next;
	char *fieldname;
	char *fieldtype;
	int tktype;	/* fieldtype expresses as TkXXX */
	union {
		int *i;		/* where to store if an int */
		char **s;	/* where to put pointer if a string */
	} destaddr;	/* pointer to where data is to be stored */
} TFfiledef;

typedef struct _TFprogdef {	/* one field as requested in the program */
	struct _TFprogdef *next;
	char *name;
	int tktype;
	int argnum;		/* which arg this is to the callback func */
} TFprogdef;

typedef struct _TFsymbol {	/* info about one table */
	struct _TFsymbol *next;	/* linked list */
	char *name;		/* name of the symbol */
	struct _TFfiledef *filedef;	/* head of file field list */
	struct _TFfiledef *filedeftail;
	struct _TFprogdef *progdef;	/* head of prog field list */
	struct _TFprogdef *progdeftail;
	int progdefcount;
	IFP funcp;		/* the func to call when reading in */
} TFsymbol;

typedef struct _TFstuff {
	TkHandle tkhandle;		/* handle to pass to TK routines */
	struct _TFsymbol *symbols;
	char *lasttype;
	int args[MAXARGS];
} TFstuff;

typedef TFstuff *TFhandle;

/* declarations of routines */
extern TFhandle TFInit();

/* end */
