/* plotTEST.c - plot driver for testing
 *
 *  2.Aug.87  jimmc  Initial definition
 * 17.Aug.87  jimmc  Add textsize function
 * 19.Aug.87  jimmc  Simplify text function
 * 27.Aug.87  jimmc  Remove box function
 */

#include <stdio.h>
#include "plot.h"

static FILE *PTfile;

#define TESTLEFT 0
#define TESTRIGHT 1000
#define TESTBOTTOM 0
#define TESTTOP 1000

int		/* 1 if OK */
PTInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	if (strcmp(filename,"stdout")==0) PTfile=stdout;
	else if (strcmp(filename,"stderr")==0) PTfile=stderr;
	else PTfile = fopen(filename,"w");
	if (!PTfile) {
		printf("can't open file %s",filename);
		return 0;
	}
	fprintf(PTfile,"Init %s\n", filename);
	*lxp = TESTLEFT;
	*lyp = TESTBOTTOM;
	*hxp = TESTRIGHT;
	*hyp = TESTTOP;
	return 1;
}

PTDone()
{
	fprintf(PTfile,"Done\n");
	if (PTfile!=stdout && PTfile!=stderr)
		fclose(PTfile);
}

PTTextSize(x,y)
int x,y;
{
	fprintf(PTfile,"TextSize (%d %d)\n",x,y);
}

PTLine(lx,ly,hx,hy)
int lx,ly,hx,hy;
{
	fprintf(PTfile,"Line (%d %d)(%d %d)\n",lx,ly,hx,hy);
}

PTText(x,y,text)
int x,y;
char *text;
{
	fprintf(PTfile,"Text \"%s\" at (%d,%d)\n",text,x,y);
}

PTSetup()
{
PDevInfo *p;

	p = Pnew();
	p->name = "TEST";
	p->init = PTInit;
	p->done = PTDone;
	p->line = PTLine;
	p->text = PTText;
	p->textsize = PTTextSize;
}

/* end */
