/* plotSIZE.c - plot driver for finding the size of a plot
 *
 * 22.Dec.87  jimmc  Initial definition
 */

#include <stdio.h>
#include "plot.h"

static FILE *PSZfile;
static minx, maxx, miny, maxy;
static int textxsize, textysize;

#define SIZELEFT 0
#define SIZERIGHT 1000
#define SIZEBOTTOM 0
#define SIZETOP 1000

int		/* 1 if OK */
PSZInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	if (strcmp(filename,"stdout")==0) PSZfile=stdout;
	else if (strcmp(filename,"stderr")==0) PSZfile=stderr;
	else PSZfile = fopen(filename,"w");
	if (!PSZfile) {
		printf("can't open file %s",filename);
		return 0;
	}
	*lxp = maxx = SIZELEFT;
	*lyp = maxy = SIZEBOTTOM;
	*hxp = minx = SIZERIGHT;
	*hyp = miny = SIZETOP;
	textxsize = textysize = 0;
	return 1;
}

#define CHECKX(x) { if ((x)<minx) minx=(x); if ((x)>maxx) maxx=(x); }
#define CHECKY(y) { if ((y)<miny) miny=(y); if ((y)>maxy) maxy=(y); }
#define CHECKXY(x,y) CHECKX(x) CHECKY(y)

PSZDone()
{
	fprintf(PSZfile,"On a scale of 0 to 1000, x=%d and y=%d\n",
		maxx-minx, maxy-miny);
	if (PSZfile!=stdout && PSZfile!=stderr)
		fclose(PSZfile);
}

PSZTextSize(x,y)
int x,y;
{
	fprintf(PSZfile,"TextSize (%d %d)\n",x,y);
	textxsize = x;
	textysize = y;
}

PSZLine(lx,ly,hx,hy)
int lx,ly,hx,hy;
{
	CHECKXY(lx,ly)
	CHECKXY(hx,hy)
}

PSZText(x,y,text)
int x,y;
char *text;
{
	CHECKXY(x,y)
	CHECKXY(x+strlen(text)*textxsize,y+textysize);
}

PSZSetup()
{
PDevInfo *p;

	p = Pnew();
	p->name = "SIZE";
	p->init = PSZInit;
	p->done = PSZDone;
	p->line = PSZLine;
	p->text = PSZText;
	p->textsize = PSZTextSize;
}

/* end */
