/* plotHP.c - plot driver for HPGL
 *
 *  1.Aug.87  jimmc  Initial definition
 * 17.Aug.87  jimmc  Add textsize function
 * 19.Aug.87  jimmc  Simplify text function
 * 20.Aug.87  jimmc  Allow selection of size A,B,C,D
 * 27.Aug.87  jimmc  Remove box function; add size E
 *  1.Sep.87  jimmc  Add R types (rotated)
 * 23.Dec.87  jimmc  Add HPPENNUM env var
 */

#include <stdio.h>
#include "plot.h"

#define NULL 0
#define DTCHAR '\003'

extern char *index(), *getenv();

extern char *Progname;

static FILE *PHPfile;
static int PHProtated;
static int PHPxtoy, PHPytox;
static int PenIsDown;
static int CurrentX,CurrentY;

#define HPGLELEFT	(-20320)
#define HPGLERIGHT	20319
#define HPGLETOP	16255
#define HPGLEBOTTOM	(-16256)

#define HPGLDLEFT	(-16256)
#define HPGLDRIGHT	16255
#define HPGLDTOP	10159
#define HPGLDBOTTOM	(-10160)

#define HPGLCLEFT	(-10160)
#define HPGLCRIGHT	10159
#define HPGLCTOP	8127
#define HPGLCBOTTOM	(-8128)

#define HPGLBLEFT	(-8128)
#define HPGLBRIGHT	8127
#define HPGLBTOP	5079
#define HPGLBBOTTOM	(-5080)

#define HPGLALEFT	(-5080)
#define HPGLARIGHT	5079
#define HPGLATOP	4063
#define HPGLABOTTOM	(-4064)

static double PHPTextWidth;
static double PHPTextHeight;
static int PHPFontHeight;

/* some utility subroutines first */

static
penDown()
{
	if (PenIsDown) return;
	fputs("PD;\n", PHPfile);
	PenIsDown++;
}

static
penUp()
{
	if (!(PenIsDown)) return;
	fputs("PU;\n", PHPfile);
	PenIsDown = 0;
}

/* go somewhere but don't worry about the pen */
static
to(x,y)
int x, y;
{
int newx, newy;

	if (x==CurrentX && y==CurrentY) return;
	CurrentX = x;
	CurrentY = y;
	if (PHProtated) {
		newx = PHPytox-y;
		newy = x-PHPxtoy;
		x = newx;
		y = newy;
	}
	fprintf(PHPfile, "PA%d,%d;\n", (x), (y));
}

/* get to a particular point with the pen up, but don't issue any pen
 * commands if we are already there */
static
toUp(x,y)
int x, y;
{
	if (x==CurrentX && y==CurrentY) return;
	penUp();
	to(x,y);
}

/* get to a particular point with the pen down, but don't issue any pen
 * commands if we are already there */
static
toDown(x,y)
int x, y;
{
	if (x==CurrentX && y==CurrentY) return;
	penDown();
	to(x,y);
}

/* externally callable routines */

int PHPAInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPxInit(filename,lxp,lyp,hxp,hyp,
		HPGLALEFT,HPGLABOTTOM,HPGLARIGHT,HPGLATOP);
}

int PHPBInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPxInit(filename,lxp,lyp,hxp,hyp,
		HPGLBLEFT,HPGLBBOTTOM,HPGLBRIGHT,HPGLBTOP);
}

int PHPCInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPxInit(filename,lxp,lyp,hxp,hyp,
		HPGLCLEFT,HPGLCBOTTOM,HPGLCRIGHT,HPGLCTOP);
}

int PHPDInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPxInit(filename,lxp,lyp,hxp,hyp,
		HPGLDLEFT,HPGLDBOTTOM,HPGLDRIGHT,HPGLDTOP);
}

int PHPEInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPxInit(filename,lxp,lyp,hxp,hyp,
		HPGLELEFT,HPGLEBOTTOM,HPGLERIGHT,HPGLETOP);
}

int PHPARInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPyInit(filename,lxp,lyp,hxp,hyp,
		HPGLALEFT,HPGLABOTTOM,HPGLARIGHT,HPGLATOP);
}

int PHPBRInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPyInit(filename,lxp,lyp,hxp,hyp,
		HPGLBLEFT,HPGLBBOTTOM,HPGLBRIGHT,HPGLBTOP);
}

int PHPCRInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPyInit(filename,lxp,lyp,hxp,hyp,
		HPGLCLEFT,HPGLCBOTTOM,HPGLCRIGHT,HPGLCTOP);
}

int PHPDRInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPyInit(filename,lxp,lyp,hxp,hyp,
		HPGLDLEFT,HPGLDBOTTOM,HPGLDRIGHT,HPGLDTOP);
}

int PHPERInit(filename,lxp,lyp,hxp,hyp)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
{
	return PHPyInit(filename,lxp,lyp,hxp,hyp,
		HPGLELEFT,HPGLEBOTTOM,HPGLERIGHT,HPGLETOP);
}

static int		/* 1 if OK */
PHPxInit(filename,lxp,lyp,hxp,hyp,left,bottom,right,top)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
int left,bottom,right,top;
{
	return PHPnInit(filename,lxp,lyp,hxp,hyp,left,bottom,right,top,0);
}

static int		/* 1 if OK */
PHPyInit(filename,lxp,lyp,hxp,hyp,left,bottom,right,top)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
int left,bottom,right,top;
{
	return PHPnInit(filename,lxp,lyp,hxp,hyp,left,bottom,right,top,1);
}

static int		/* 1 if OK */
PHPnInit(filename,lxp,lyp,hxp,hyp,left,bottom,right,top,rotated)
char *filename;
int *lxp,*lyp,*hxp,*hyp;	/* returns bounding box of window */
int left,bottom,right,top;
int rotated;
{
char *pn;

	if (strcmp(filename,"stdout")==0) PHPfile=stdout;
	else if (strcmp(filename,"stderr")==0) PHPfile=stderr;
	else PHPfile = fopen(filename,"w");
	if (!PHPfile) {
		printf("can't open file %s",filename);
		return 0;
	}
	fprintf(PHPfile,"IN;PA;\n");
	fprintf(PHPfile,"\033.I;0;17:\n\033.N;19:\n");	/* init handshake */
	fprintf(PHPfile,"IP %d,%d,%d,%d;\n",
		left,bottom,right,top);
	    /* make it square */
	fprintf(PHPfile,"SC %d,%d,%d,%d;\n",
		left,right,bottom,top);
	fprintf(PHPfile,"PU;PA0,0;\n");	/* go to origin */
	pn = getenv("HPPENNUM");
	if (!pn) pn = "1";
	fprintf(PHPfile,"SP%s;\n",pn);
	if (rotated) {
		fprintf(PHPfile,"DI0,1;\n");	/* rotate the text */
		PHProtated = 1;
		*lxp = bottom;	/* x and y sizes are swapped */
		*lyp = left;
		*hxp = top;
		*hyp = right;
		PHPytox = right+left;
		PHPxtoy = bottom+top;
	}
	else {
		PHProtated = 0;
		*lxp = left;
		*lyp = bottom;
		*hxp = right;
		*hyp = top;
	}
	return 1;
}

PHPDone()
{
	fprintf(PHPfile,"IW;PU;SP0;PA0,0;\n");
	fprintf(PHPfile,"NR;\n");
	if (PHPfile!=stdout && PHPfile!=stderr)
		fclose(PHPfile);
}

PHPTextSize(x,y)
int x,y;
{
	PHPFontHeight = y;
	PHPTextHeight = 0.0017 * (double)y;
	PHPTextWidth = 0.0017 * (double)x;
	fprintf(PHPfile,"SI%g,%g;\n",PHPTextWidth,PHPTextHeight);
			/* text size */
}

PHPLine(lx,ly,hx,hy)
int lx,ly,hx,hy;
{
	if (CurrentX==hx && CurrentY==hy) {
		toDown(lx,ly);
	}
	else {
		toUp(lx,ly);
		toDown(hx,hy);
	}
}

PHPText(x,y,text)
int x,y;	/* lower left corner of text */
char *text;
{
	toUp(x,y);
	fprintf(PHPfile,"LB%s%c\n",text,DTCHAR);
}

PHPSetup()
{
	PHPxSetup("HPA",PHPAInit);
	PHPxSetup("HPB",PHPBInit);
	PHPxSetup("HPC",PHPCInit);
	PHPxSetup("HPD",PHPDInit);
	PHPxSetup("HPE",PHPEInit);
	PHPxSetup("HPAR",PHPARInit);
	PHPxSetup("HPBR",PHPBRInit);
	PHPxSetup("HPCR",PHPCRInit);
	PHPxSetup("HPDR",PHPDRInit);
	PHPxSetup("HPER",PHPERInit);
}

static
PHPxSetup(name,init)
char *name;
int (*init)();
{
PDevInfo *p;

	p = Pnew();
	p->name = name;
	p->init = init;
	p->done = PHPDone;
	p->line = PHPLine;
	p->text = PHPText;
	p->textsize = PHPTextSize;
}

/* end */
