/*
  Prerelease 0.2 of the command line option parser, 28 Mar 88.
  options.c

  Copyright Arndt Jonasson, 1988. Please send enhancements and corrections
  back to the author.

  Author: Arndt Jonasson, Zyx Sweden
  aj@zyx.SE	(...<backbone>!mcvax!enea!zyx!aj)

  No manual page yet.
*/

#include "options.h"

extern void exit ();		/* '#define void' if your compiler doesn't */
				/* have it.*/

char *O_programname = NULL;

static char *usage_string = NULL;
static int option_error;

static fatal (msg)
char *msg;
{
   fprintf (stderr, "option parsing failure: %s\n", msg);
   exit (1);
}

static char *basename (str)
char *str;
{
   char *p1, *p2;
   extern char *strchr ();

   p2 = str;
   while ((p1 = strchr (p2, '/')) != NULL)
   {
      if (p1[1] == '\0')
      {
	 p1[0] = '\0';
	 return p2;
      }
      p2 = p1 + 1;
   }
   return p2;
}

static char *match (prefix, str)
char *prefix, *str;
{
   int n = strlen (prefix);

   if (strncmp (prefix, str, n) == 0)
      return str + n;
   else
      return NULL;
}

O_usage ()
{
   if (usage_string != NULL)
   {
      if (O_programname == NULL)
	 fprintf (stderr, "valid options: %s\n", usage_string);
      else
	 fprintf (stderr, "usage: %s %s\n", O_programname, usage_string);
   }
   else
   {
      if (O_programname != NULL)
	 fprintf (stderr, "%s: ", O_programname);
      fprintf (stderr, "invalid usage\n");
   }

   exit (1);
}

int O_atoi (str)
char *str;
{
   char c;
   int base = 10;
   int res = 0;
   int negative = 1;
   
/*
  No check for overflow.
*/

   c = str[0];
   
   if (*str == '-')
   {
      negative = -1;
      str++;
   }

   if (*str == '0')
   {
      if (*++str == 'x')
      {
	 str++;
	 base = 16;
      }
      else
	 base = 8;
   }
   
   if (*str == '\0' && (negative != -1 || base != 8)) /* kludgie */
   {
      option_error = 1;
      return 0;
   }

   for (;;)
   {
      switch (c = *str++)
      {
       case '8':
       case '9':
	 if (base == 8)
	 {
	    option_error = 1;
	    return 0;
	 }
       case '0':
       case '1':
       case '2':
       case '3':
       case '4':
       case '5':
       case '6':
       case '7':
	 res = base * res + c - '0';
	 break;
       case 'a':
       case 'b':
       case 'c':
       case 'd':
       case 'e':
       case 'f':
	 if (base == 16)
	    res = base * res + c - 'a' + 10;
	 else
	 {
	    option_error = 1;
	    return 0;
	 }
	 break;
       case '\0':
	 return (negative * res);
	 /* NOTREACHED */
	 break;
       default:
	 option_error = 1;
	 return 0;
      }
   }
}

double O_atof (s)
char *s;
{
/*
  No error-checking currently.
*/
   extern double atof ();

   return atof (s);
}

char *O_strid (s)
char *s;
{
   return s;
}

char O_chrid (s)
char *s;
{
   return s[0];
}

static get_it (p, arg, c)
Option *p;
char *arg;
char c;
{
   option_error = 0;

   switch ((p->flags & 037))
   {
    case O_INT:
      *p->ip = (*p->ipf) (arg);
      if (option_error)
      {
	 fprintf (stderr,
		  "Invalid integer '%s' given to the -%c option\n", arg, c);
	 O_usage ();
      }
      break;
    case O_STR:
      *p->cp = (*p->cpf) (arg);
      break;
    case O_DBL:
      *p->dp = (*p->dpf) (arg);
      if (option_error)
      {
	 fprintf (stderr,
      "Invalid floating-point number '%s' given to the -%c option\n", arg, c);
	 O_usage ();
      }
      break;
    case O_CHR:
      *p->tp = (*p->tpf) (arg);
      break;
    case O_MUL:
      (*p->table_p)[p->data++] = arg;
      break;
    default:
      fatal ("invalid option type");
   }
}

int O_parse_options (desc, argc, argv)
Option *desc;
int argc;
char **argv;
{
   static char *empty_table[] = {NULL};
   int first_char, multiple_error, multiple_add, hyphen_is_arg;
   int min, max, i, remaining;
   Option *p, *default_p = NULL;
   char *cp, *dir, *arg;
   char c;

   multiple_error = 1;
   multiple_add = 0;
   hyphen_is_arg = 1;
   min = 0;
   max = -1;

   for (p = desc; p->flags != O_END; p++)
   {
      p->data = 0;

      if (p->flags == O_DIR)
      {
	 dir = p->directive;
	 if (cp = match ("usage: ", dir))
	    usage_string = cp;
	 else if (cp = match ("multiple: ", dir))
	 {
	    multiple_error = (strcmp ("error", cp) == 0);
	    multiple_add = (strcmp ("add", cp) == 0);
	 }
	 else if (cp = match ("remaining: ", dir))
	 {
	    int n;
	    char dummy;

	    n = sscanf (cp, "%d%c%d", &min, &dummy, &max);
	    if (n == 1)
	       max = min;
	    else if (n == 2)
	       max = -1;
	 }
	 else
	    fatal ("unknown option directive");
      }
      else if (p->flags == O_MUL)
	 *p->table_p = (char **) malloc (argc * sizeof (char *));
      else if (p->flags == O_INT && p->c == '\0')
      {
	 p->c = -1;
	 default_p = p;
      }
      else if (p->flags == O_FLG && p->c == '\0')
	 hyphen_is_arg = 0;

      if (p->flags == O_FLG)
	 *p->ip = 0;
   }

   O_programname = basename (argv[0]);

   for (i = 1; i < argc; i++)
   {
      arg = argv[i];
      if (arg[0] != '-' || (arg[1] == '\0' && hyphen_is_arg))
	 break;

      first_char = 1;

      while ((c = *++arg) != '\0' || first_char)
      {
	 for (p = desc; p->flags != O_END; p++)
	    if (p->c == c)
	    {
	       if (p->flags & 040)
	       {
		  fprintf (stderr, "The -%c option was given twice\n", c);
		  O_usage ();
	       }

	       if (multiple_error && p->flags != O_MUL)
		  p->flags |= 040;

	       if ((p->flags & 037) == O_FLG)
	       {

		  if (multiple_add)
		     *(p->ip) += 1;
		  else
		     *(p->ip) = 1;
		  if (c == '\0')
		     goto next_argument;
		  else
		     goto next_character;
	       }

	       arg += 1;
	       if (arg[0] == '\0')
	       {
		  if (++i == argc)
		  {
		     fprintf (stderr,
			      "The -%c option requires an argument\n", c);
		     O_usage ();
		  }
		  arg = argv[i];
	       }
	       get_it (p, arg, c);
	       goto next_argument;
	    }
	 if ((p = default_p) != NULL && first_char)
	 {
	    *p->ip = (*p->ipf) (arg);
	    if (!option_error)
	       goto next_argument;
	 }
	 fprintf (stderr, "There is no -%c option\n", c);
	 O_usage ();

	 /* NOTREACHED*/

       next_character:
	 first_char = 0;
      }
    next_argument: ;
   }

   for (p = desc; p->flags != O_END; p++)
      if ((p->flags & 037) == O_MUL)
      {
	 if (p->data == 0)
	    (*p->table_p = empty_table);
	 else
	 {
	    (*p->table_p)[p->data++] = NULL;
	    *p->table_p = (char **) realloc (*p->table_p,
					     p->data * sizeof (char *));
	 }
      }

   remaining = argc - i;
   if (remaining < min || max != -1 && remaining > max)
   {
      if (max == -1)
	 fprintf (stderr, "At least %d non-option argument%s required\n",
		  min, min == 1 ? " is" : "s are");
      else if (max == 0)
	 fprintf (stderr, "No non-option arguments are allowed\n");
      else if (min == max)
	 fprintf (stderr, "Exactly %d non-option argument%s required\n",
		  min, min == 1 ? " is" : "s are");
      else
	 fprintf (stderr, "%d to %d non-option arguments are required\n",
		  min, max);
      O_usage ();
   }
   return i;
}
