/*
  Prerelease 0.2 of the command line option parser, 28 Mar 88.
  options.h

  Copyright Arndt Jonasson, 1988. Please send enhancements and corrections
  back to the author.

  Author: Arndt Jonasson, Zyx Sweden
  aj@zyx.SE	(...<backbone>!mcvax!enea!zyx!aj)

  No manual page yet.
*/

#include <stdio.h>

typedef struct
{
   char c;
   int flags;
   char **cp;
   char *(*cpf) ();
   int *ip;
   int (*ipf) ();
   double *dp;
   double (*dpf) ();
   char *tp;
   char (*tpf) ();
   char ***table_p;
   char *directive;
   int data;
} Option;

extern int O_atoi ();
extern double O_atof ();
extern char O_chrid ();

extern char *O_strid ();
extern char *O_programname;

#define O_FLG	0
#define O_INT	1
#define O_STR	2
#define O_DBL	3
#define O_END	4
#define O_DIR	5
#define O_CHR	6
#define O_MUL	7


#define O_flg(c, ip)	{c, O_FLG, 0, 0, &ip, 0, 0, 0, 0, 0, 0, 0}
#define O_int(c, ip)	{c, O_INT, 0, 0, &ip, O_atoi, 0, 0, 0, 0, 0, 0}
#define O_str(c, cp)	{c, O_STR, &cp, O_strid, 0, 0, 0, 0, 0, 0, 0, 0}
#define O_dbl(c, dp)	{c, O_DBL, 0, 0, 0, 0, &dp, O_atof, 0, 0, 0, 0}
#define O_end		{-1, O_END, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
#define O_directive(str) {-1, O_DIR, 0, 0, 0, 0, 0, 0, 0, 0, 0, str}
#define O_chr(c, cp)	{c, O_CHR, 0, 0, 0, 0, 0, 0, &cp, O_chrid, 0, 0}
#define O_mul(c, cpp)	{c, O_MUL, 0, 0, 0, 0, 0, 0, 0, 0, &cpp, 0}

#define O_Empty			'\0'

#define usage()			O_usage ()
