/*
	ChiSqTbl -- Pearson's chi-square test for a 2-way contingency table

	last edit:	88/09/19	D A Gwyn

	SCCS ID:	@(#)chisq.c	1.1 (edited for publication)

	Special return values:
		-1.0	insufficient degrees of freedom (too many 0 entries)
		-2.0	invalid table entry (frequency less than 0)
		-3.0	invalid table dimensions (r or c less than 2)
		-4.0	unable to allocate enough working storage
*/

#ifdef __STDC__
#include	<stdlib.h>		/* malloc, free */

#include	"std.h"
#else
#include	"std.h"

extern pointer	malloc();
extern void	free();
#endif

double
ChiSqTbl( r, c, f, pdf )
	int		r;		/* # rows in table */
	int		c;		/* # columns in table */
	const long	*f;		/* -> r*c frequency tallies */
	int		*pdf;		/* -> return # degrees of freedom */
	{
#define	x(i,j)	f[(i)*c+(j)]		/* convenient way to access freqs */
	register int	i;		/* row index */
	register int	j;		/* column index */
	double		N;		/* (double)n */
	double		chisq;		/* accumulates chi-square */
	double		*xi;		/* row sums */
	double		*xj;		/* col sums */
	int		rdf = r - 1;	/* row degrees of freedom */
	int		cdf = c - 1;	/* column degrees of freedom */

	if ( rdf <= 0 || cdf <= 0 )
		{
		chisq = -3.0;
		goto ret3;
		}

	if ( (xi = (double *)malloc( r * sizeof(double) )) == NULL )
		{
		chisq = -4.0;
		goto ret3;
		}

	if ( (xj = (double *)malloc( c * sizeof(double) )) == NULL )
		{
		chisq = -4.0;
		goto ret2;
		}

	/* compute row sums and total */

	N = 0.0;

	for ( i = 0; i < r; ++i )
		{
		double	sum = 0.0;	/* accumulator */

		for ( j = 0; j < c; ++j )
			{
			register long	k = x(i,j);

			if ( k < 0L )
				{
				chisq = -2.0;
				goto ret1;
				}

			sum += (double)k;
			}

		if ( (xi[i] = sum) <= 0.0 )
			--rdf;
		else
			N += sum;
		}

	/* compute column sums */

	for ( j = 0; j < c; ++j )
		{
		double	sum = 0.0;	/* accumulator */

		for ( i = 0; i < r; ++i )
			sum += (double)x(i,j);

		if ( (xj[j] = sum) <= 0.0 )
			--cdf;
		}

	if ( rdf <= 0 || cdf <= 0 )
		{
		chisq = -1.0;
		goto ret1;
		}

	*pdf = rdf * cdf;		/* total degrees of freedom */

	/* compute chi-square */

	chisq = 0.0;

	for ( i = 0; i < r; ++i )
		{
		double	pi = xi[i];	/* row sum */

		if ( pi > 0.0 )
			for ( j = 0; j < c; ++j )
				{
				double	pj = xj[j];	/* column sum */

				if ( pj > 0.0 )
					{
					double	expected = pi * pj / N;
					double	delta =
						(double)x(i,j) - expected;

					chisq += delta * delta / expected;
					}
				}
		}

    ret1:
	free( (pointer)xj );
    ret2:
	free( (pointer)xi );
    ret3:
	return chisq;
	}
