#!	/usr/local/bin/perl

# Save the ARGV list; if non-null, its a list of term entryies
$args = $#ARGV + 1;
while ( $ARGV[0] )
{
    $argv{$ARGV[0]} = 1;
    shift(@ARGV);
}

# Process the list of known termcap identifiers and their description

open(termlist, "/usr/local/lib/termlist");
while (<termlist>)
{
    chop;
    @line = split(/\t/);
    $symbol_definitions{$line[0]} = $line[1] if !/^#/;
}
close(termlist);

# process the termcap file presented on stdin

while ( <> )
{
    $comments = "";
    $namelist = "";
    # Dispose of the coments (if any)
    while ( /^#|^\n/ )
    {
	$comments .= length($_) <= 70 ? $_ : substr($_, 0, 70) . "...\n";
	$_ = <>;
    }

    # Get the entire entry
    $entry = $_;
    do
    {
	$entry .= <>;
    } while substr($entry, length($entry)-2, 1) eq "\\";

    # If the file had trailing comments we will have read a null entry
    exit if !$entry;

    # Clear leading whitespace and (possibly escaped) newlines,
    # using the multiple line record matching feature.
    $* = 1; $entry =~ s/\t|^ +|\\\n|\n//g; $* = 0;

    # Get the terminal names, delimited by "|", ended by ":"
    # and the capabilities, enclosed in one or more ":", being careful to 
    # avoid being confused by escaped colons and escaped backslashes at the
    # end of an entry.
    $entry =~ s/\\:/\\\001/g;
    $entry =~ s/\\\\/\\\002/g;
    @names = split(/:+/, $entry);

    # Look for a particular terminal if any were specified.  Otherwise do all.
    $found = 0;
    foreach $name ( split(/\|/, $names[0]) )
    {
	$found |= $argv{$name};
	$namelist .= "    " . $name . "\n";
    }

    # Loop to the next entry if a requested entry was not found.
    next if $args && !$found;

    # Print that part of the entry which we've saved waiting to see if
    # the entry would be selected.
    print $comments, "Names for this terminal:\n", $namelist,
	  "\nTerminal capabilities:\n";

    # Discard the first of the names entry, which contains the terminal names.
    shift(@names);

    # Clear the symbol tables
    @syms = ();
    @symtab = ();

    # Translate some of the more obscure things in the capability definitions
    # to "readable" definitions.  The order of the first five is important.
    foreach $nam ( @names )
    {
	($name, $value) = split(/=|#/, $nam);
	next if $name eq " ";
	$value =~ s/\\\^/^/g;
	$value =~ s/\\0x/0x/g;
	$value =~ s/\\\001/:/g;
	$value =~ s/\\\002/\\/g;
	$value =~ s/\\\\/\\/g;
	$value =~ s/\\b/<bs>/g;
	$value =~ s/\\f/<ff>/g;
	$value =~ s/\\n/<nl>/g;
	$value =~ s/\\E/<esc>/g;
	$value =~ s/\\1/01/g;
	$value =~ s/\\2/02/g;
	$value =~ s/\\3/03/g;
	$value =~ s/\\4/04/g;
	$value =~ s/\\5/05/g;
	$value =~ s/\\6/06/g;
	$value =~ s/\\7/07/g;
	$value =~ s/\\0/<nul>/g;
	$value =~ s/\\r/<ret>/g;
	$value =~ s/\\t/<tab>/g;
	$symtab{$name} = $value ? $value : "<set>";
	push(@syms, $name);
    }
    format stdout =
    @<<<<<<<  @<<<<<<<<<<<<<<<<<<<<   @<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
    $sym  $symtab_entry           $symbol_def 
.
    foreach $sym ( sort @syms )
    {
	$symtab_entry = $symtab{$sym};
	$symbol_def   = $symbol_definitions{$sym};
	$symbol_def   = "" if $symbol_def eq "0";
	write();
    }
    print "\f\n";
}
