/*header.h				*/
/*include file for tape sorting program	*/
/*by David Bleckmann			*/

/*#define MS_DOS	/*define if on compiling on turbo C*/

#include <stdio.h>
#include <ctype.h>

#ifdef MS_DOS
#include <string.h>
#include <conio.h>
#else
/*for system V you may need to change <strings.h> to <string.h>*/
#include <strings.h>
#include <curses.h>
#endif

#define SIDEAB  	/*define if sides to be accessed as A or B rather*/
			/*than side 1 or 2.			*/

/* The following are used as defines so that the user can set up */
/* the program as he/she would like, i.e. change the command key */
/* letters, etc.  It is permissible to make changes, but	 */
/* certainly isn't necesarry.				 	 */


#define MAX_NUM_TAPES 300
#define STR_LEN 80
#define SCRHT 11	/* number of tapes that fits on one screen */

#define VERT_BAR '|'
#define COLEN    ':'
#define SPACE	' '
#ifndef MS_DOS
#define CR	'\12'
#else
#define CR	'\15'
#endif

/* COMMAND DEFINES */
#define READCOM 	'r'
#define ADDCOM          'a'
#define WR1COM  	's'
#define WR2COM 		'w'
#define EDITCOM		'e'
#define LISTCOM 	'l'
#define LIST2COM	'L'
#define PRINTCOM	'p'
#define DELCOM		'D'
#define CLEARCOM	'C'
#define RECOVCOM	'R'
#define ORDCOM		'o'
#define ALPHACOM	'A'
#define QUITCOM		'Q'

#ifndef MS_DOS
/*LEFTCHAR and RIGHTCHAR are used in the Unix version of ALPHACOM*/
#define LEFTCHAR 'h'
#define RIGHTCHAR 'l'
#endif

/* All further lines should probably not be changed	*/
/*--------------------------------------------------------------------*/

#ifndef TRUE	/* sometimes not defined */
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif


#ifdef SIDEAB
#define SIDECHAR(pdq) ((pdq)!=2?'A':'B')
#define SIDE1CHAR 'A'
#define SIDE2CHAR 'B'
#else
#define SIDECHAR(pdq) ((pdq)!=2?'1':'2')
#define SIDE1CHAR '1'
#define SIDE2CHAR '2'
#endif

#ifdef MS_DOS
#define BACKSPACE() gotoxy(wherex()-1, wherey())
#else
#define BS	'\10'
#define BACKSPACE() putchar(BS)

/* For some reason TC's strncmp is strnicmp, thus the following macro */
#define strnicmp(aaa, bbb, ccc) strncmp(aaa, bbb, ccc)
#endif

/* Side X macro; refers to the side yyy in the  struct tape *xxx */
#define Sx(xxx, yyy) ((yyy)==2 ? (xxx)->s2 : (xxx)->s1)

typedef char string[STR_LEN];

struct tape {
    int num;
    string s1;
    string s2;
};


