#include "header.h"

int nindex(s, c)	/*returns the position of the char c in the string s*/
char *s, c;
{
int n;

    n=0;

    while(*s!=c && *s!='\0')
    {
	n++;
	s++;
    }

    if (*s=='\0')
	return(-1);	/* -1 if not found */

    return(n);
}

int allblank(s)	/* returns TRUE if no chars in string s */
char *s;
{
    while (*s!='\0')
	if (!isspace(*s++))
	    return FALSE;

    return TRUE;
}

char *decode(p2, p1)	/*undoes alpha coding*/
char *p2, *p1;
{
int vb, colen;

    if ((vb=nindex(p1, VERT_BAR))!=-1)
    {
	colen=nindex(p1+vb, COLEN);
	colen=(colen!=-1) ? colen+vb : strlen(p1);
	strncpy(p2, p1+vb+1, colen-vb-1);
	p2[colen-vb-1]=' ';
	p2[colen-vb]='\0';
	strncat(p2, p1, vb);
	strcat(p2, p1+colen);
    }
    else
	strcpy(p2, p1);

    return(p2);
}

void alpha_out(fp, t, count)
FILE *fp;
struct tape *t[];
int count;
{
int t_mark[MAX_NUM_TAPES][2], least_num, least_side, a, b;
string tmp;

/* we need to fprint to fp an alphabetized list of tiles, and */
/* of course we do this inefficiently ;-).  We keep track of  */
/* what titles we have printed out so far in t_mark[] and     */
/* then print out the least of the remaining tapes.           */

    for(a=0; a<count; a++)
	t_mark[a][0]=t_mark[a][1]=0;

    for(;;)
    {
	least_num=count;	/*indicates we don't have least yet*/
	least_side=1;
	for(a=0; a<count; a++) 		/* a == tape number */
	    for(b=1; b<=2; b++)		/* b == side        */

 	        if(!t_mark[a][b-1] &&
		    (least_num==count ||
		        strcmp(Sx(t[a],b), Sx(t[least_num],least_side))<0))
		{
		    least_num=a;
		    least_side=b;
		}

        if (least_num==count)	/* we must be done with the lot */
	    break;		/* so exit the for(;;) */

        if (!allblank(Sx(t[least_num], least_side)))
            fprintf(fp, "Tape %-4d Side %c: %s\n", t[least_num]->num,
			SIDECHAR(least_side),
		        decode(tmp, Sx(t[least_num],least_side)));

        t_mark[least_num][least_side-1]=1;	/* mark this one as printed */
    }
}

int mvcur(cur, new)	/*returns new cursor position*/
int cur, new;
{
int a;

    if (new < cur)
	for(a=cur; a>new; a--)
	    BACKSPACE();

    if (new > cur)
	for(a=cur; a<new; a++)
	    putchar(SPACE);

    return new;
}

int correct(s)	/*returns 1 if changes made, 0 if not*/
		/*-1 if Quit is incountered*/
char *s;
{
int curpos, colenpos, a, b;
string tmp;

#ifdef MS_DOS
    printf("\nUse <- and -> , hit space to insert a '%c'\n", VERT_BAR);
    printf("Return for no change; Q to quit\n\n");

    fflush(stdin);
    printf("%s\n",  s);

    colenpos=(a=nindex(s, COLEN))==-1 ? strlen(s) : a ;

    if ((curpos=nindex(s, SPACE))==-1 || colenpos<curpos)
    {
	printf("No spaces found - No changes made.\n");
	return 0;
    }

    mvcur(0, curpos);

    do {
	while(!kbhit())
	    ;

        if ((b=getch())=='\0')	/*a function key is hit*/
	    b=getch()+128;

	if (b=='Q')
	    return(-1); 

        if (b==205)	/* -> */
        {
	    a=nindex(s+curpos+1, SPACE)+curpos+1;
	    if (a!=-1 && a<colenpos)
		curpos=mvcur(curpos, a);
	}

        if (b==203)	/* <- */
	{
	    b=curpos;	/* last known space */
	    a=0;
	    while ((a=nindex(s+a+1, SPACE)+a+1)<curpos && a!=-1)
		b=a;

            curpos=mvcur(curpos, b);  /**/
	}

        if (b==SPACE)	/* Alpha encode word */
	{
	    a=nindex(s+curpos, COLEN);
	    strncpy(tmp, s+curpos+1,
			 (a=(a!=-1)?a+curpos:strlen(s)) - curpos - 1);
	    tmp[a-curpos-1]=VERT_BAR;
	    tmp[a-curpos]='\0';
            strncat(tmp, s, curpos);
	    strcat(tmp, s+a);

	    strcpy(s, tmp);
	    printf("\n%s\n", s);
	    return(1);
	}

    } while (b!=CR);

    return 0;	/* CR hit, no changes made */
#else
    printf("\nUse '%c' and '%c', hit space to insert a '%c'\n", 
		LEFTCHAR, RIGHTCHAR, VERT_BAR);
    printf("Return for no change; Q to quit\n\n");

    noecho();
    cbreak();

    fflush(stdin);
    printf("%s\n",  s);

    colenpos=(a=nindex(s, COLEN))==-1 ? strlen(s) : a ;

    if ((curpos=nindex(s, SPACE))==-1 || colenpos<curpos)
    {
	printf("No spaces found - No changes made.\n");
	echo();
	nocbreak();
	return 0;
    }

    mvcur(0, curpos);

    do {
	b=getchar();

        if (b==RIGHTCHAR)	/* -> */
        {
	    a=nindex(s+curpos+1, SPACE)+curpos+1;
	    if (a!=-1 && a<colenpos)
		curpos=mvcur(curpos, a);
	}

        if (b==LEFTCHAR)	/* <- */
	{
	    b=curpos;	/* last known space */
	    a=0;
	    while ((a=nindex(s+a+1, SPACE)+a+1)<curpos && a!=-1)
		b=a;

            curpos=mvcur(curpos, b);  /**/
	}

	if (b=='Q') 	/* Quit */
	{
	    echo();
	    nocbreak();
	    return(-1);
	}

        if (b==SPACE)	/* Alpha encode word */
	{
	    a=nindex(s+curpos, COLEN);
	    strncpy(tmp, s+curpos+1,
			 (a=(a!=-1)?a+curpos:strlen(s)) - curpos - 1);
	    tmp[a-curpos-1]=VERT_BAR;
	    tmp[a-curpos]='\0';
            strncat(tmp, s, curpos);
	    strcat(tmp, s+a);

	    strcpy(s, tmp);
	    printf("\n%s\n", s);

	    echo();
	    nocbreak();
	    return(1);
	}

    } while (b!=CR);

    echo();
    nocbreak();
    return 0;	/* CR hit, no changes made */
#endif
}

